/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.loader.overlay.OverlayLoaderBuilder;
import xfacthd.framedblocks.client.model.cube.FramedMarkedCubeModel;
import xfacthd.framedblocks.client.model.interactive.FramedMarkedPressurePlateModel;
import xfacthd.framedblocks.client.model.rail.FramedFancyRailModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.datagen.providers.FramedSpriteSourceProvider;

public final class FramedBlockStateProvider
extends BlockStateProvider {
    private final ResourceLocation TEXTURE = this.modLoc("block/framed_block");
    private final ResourceLocation TEXTURE_ALT = this.modLoc("block/framed_block_alt");
    private final ResourceLocation TEXTURE_UNDERLAY = this.mcLoc("block/stripped_dark_oak_log");

    public FramedBlockStateProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, "framedblocks", fileHelper);
    }

    protected void registerStatesAndModels() {
        ModelBuilder cube = ((BlockModelBuilder)this.models().cubeAll("framed_cube", this.TEXTURE)).renderType("cutout");
        BlockModelBuilder stoneCube = this.makeUnderlayedCube("framed_stone_cube", this.mcLoc("block/stone"));
        BlockModelBuilder obsidianCube = this.makeUnderlayedCube("framed_obsidian_cube", this.mcLoc("block/obsidian"));
        BlockModelBuilder ironCube = this.makeUnderlayedCube("framed_iron_cube", this.mcLoc("block/iron_block"));
        BlockModelBuilder goldCube = this.makeUnderlayedCube("framed_gold_cube", this.mcLoc("block/gold_block"));
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_CORNER_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INNER_CORNER_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_PRISM_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INNER_PRISM_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_THREEWAY_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INNER_THREEWAY_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLOPE_EDGE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_ELEVATED_SLOPE_EDGE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_ELEVATED_DOUBLE_SLOPE_EDGE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_STACKED_SLOPE_EDGE, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_DIVIDED_SLAB.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_PANEL.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_DIVIDED_PANEL_HOR.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_DIVIDED_PANEL_VERT.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_MASONRY_CORNER_SEGMENT.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_MASONRY_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_IRON_TRAP_DOOR.get(), (ModelFile)ironCube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_THREEWAY_CORNER_PILLAR, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_THREEWAY_CORNER_PILLAR, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FENCE_GATE, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_STONE_BUTTON.get(), (ModelFile)stoneCube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WALL_SIGN.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LATTICE, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_THICK_LATTICE.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_SLAB.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_COPYCAT_SLAB.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_PANEL.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_COPYCAT_PANEL.get(), (ModelFile)cube);
        this.simpleBlockWithItem((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLOPE.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_PRISM_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_THREEWAY_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_POWERED_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DETECTOR_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_ACTIVATOR_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_PILLAR.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_HALF_PILLAR.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_POST, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_DIVIDED_STAIRS.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_HALF_STAIRS, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLICED_STAIRS_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLICED_STAIRS_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_PRISM, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INNER_PRISM, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_PRISM, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLOPED_PRISM, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INNER_SLOPED_PRISM, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_SLOPED_PRISM, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLOPE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_ELEVATED_SLOPE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_COMPOUND_SLOPE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_SLOPE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_SLOPE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_STACKED_SLOPE_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_ELEVATED_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_ELEVATED_INNER_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_INVERSE_DOUBLE_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_ELEVATED_DOUBLE_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_ELEVATED_INNER_DOUBLE_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_VERTICAL_DIVIDED_STAIRS.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_STAIRS, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_VERTICAL_SLICED_STAIRS, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_COMPOUND_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_STACKED_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_EXTENDED_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_EXTENDED_INNER_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_INVERSE_DOUBLE_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_EXTENDED_DOUBLE_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_EXTENDED_INNER_DOUBLE_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_INNER_DOUBLE_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_EXTENDED_INNER_DOUBLE_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_STACKED_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_STACKED_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_WALL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_STAIRS, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_STAIRS, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WALL_BOARD.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_CORNER_STRIP, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_PYRAMID, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_PYRAMID_SLAB, (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_HORIZONTAL_PANE.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_LARGE_BUTTON.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_LARGE_STONE_BUTTON.get(), (ModelFile)stoneCube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_GATE.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_IRON_GATE.get(), (ModelFile)ironCube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FANCY_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_HALF_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DIVIDED_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_DOUBLE_HALF_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_SLOPE, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SLOPED_STAIRS, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_VERTICAL_SLOPED_STAIRS, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_CENTERED_SLAB.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_CENTERED_PANEL.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_CHECKERED_CUBE_SEGMENT.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_CHECKERED_CUBE, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_CHECKERED_SLAB_SEGMENT.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_CHECKERED_SLAB, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_CHECKERED_PANEL_SEGMENT.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_CHECKERED_PANEL, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_TUBE, (ModelFile)cube, "cutout");
        this.registerFramedCube((ModelFile)cube);
        this.registerFramedSlab((ModelFile)cube);
        this.registerFramedStairs((ModelFile)cube);
        this.registerFramedWall((ModelFile)cube);
        this.registerFramedFence((ModelFile)cube);
        this.registerFramedDoor((ModelFile)cube);
        this.registerFramedIronDoor((ModelFile)ironCube);
        this.registerFramedTrapDoor((ModelFile)cube);
        this.registerFramedPressurePlate((ModelFile)cube);
        this.registerFramedStonePressurePlate((ModelFile)stoneCube);
        this.registerFramedObsidianPressurePlate((ModelFile)obsidianCube);
        this.registerFramedGoldPressurePlate((ModelFile)goldCube);
        this.registerFramedIronPressurePlate((ModelFile)ironCube);
        this.registerFramedLadder();
        this.registerFramedButton((ModelFile)cube);
        this.registerFramedLever();
        this.registerFramedSign((ModelFile)cube);
        this.registerFramedHangingSign();
        this.registerFramedWallHangingSign();
        this.registerFramedTorch();
        this.registerFramedWallTorch();
        this.registerFramedSoulTorch();
        this.registerFramedSoulWallTorch();
        this.registerFramedRedstoneTorch();
        this.registerFramedRedstoneWallTorch();
        this.registerFramedFloorBoard((ModelFile)cube);
        this.registerFramedChest();
        this.registerFramedBarsBlock((ModelFile)cube);
        this.registerFramedPaneBlock((ModelFile)cube);
        this.registerFramedFlowerPotBlock((ModelFile)cube);
        this.registerFramedCollapsibleBlock();
        this.registerFramedCollapsibleCopycatBlock();
        this.registerFramedBouncyBlock();
        this.registerFramedSecretStorage();
        this.registerFramedRedstoneBlock();
        this.registerFramedGlowingCube();
        this.registerFramedTarget((ModelFile)cube);
        this.registerFramedItemFrame();
        this.registerFramedFancyRail();
        this.registerFramedFancyPoweredRail();
        this.registerFramedFancyDetectorRail();
        this.registerFramedFancyActivatorRail();
        this.registerFramedMiniCube((ModelFile)cube);
        this.registerFramedOneWayWindow();
        this.registerFramedBookshelf();
        this.registerFramedChiseledBookshelf((ModelFile)cube);
        this.registerFramingSaw();
        this.registerPoweredFramingSaw();
    }

    private void registerFramedCube(ModelFile cube) {
        ModelBuilder solidUnderlay = ((BlockModelBuilder)((BlockModelBuilder)this.models().cubeAll("framed_underlay", this.TEXTURE_UNDERLAY)).texture("particle", this.TEXTURE)).renderType("cutout");
        ModelBuilder altCube = ((BlockModelBuilder)this.models().cubeAll("framed_cube_alt", this.modLoc("block/framed_block_alt"))).renderType("cutout");
        ModelBuilder reinforcement = ((BlockModelBuilder)this.models().cubeAll("framed_reinforcement", this.modLoc("block/framed_reinforcement"))).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)FBContent.BLOCK_FRAMED_CUBE.get()).part().modelFile((ModelFile)solidUnderlay).addModel()).condition((Property)FramedProperties.SOLID_BG, (Comparable[])new Boolean[]{true}).end().part().modelFile(cube).addModel()).condition((Property)FramedProperties.ALT, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)altCube).addModel()).condition((Property)FramedProperties.ALT, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)reinforcement).addModel()).condition((Property)FramedProperties.REINFORCED, (Comparable[])new Boolean[]{true}).end();
        this.simpleBlockItem(FBContent.BLOCK_FRAMED_CUBE, cube);
    }

    private void registerFramedSlab(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_SLAB.get(), cube);
        ((ItemModelBuilder)this.itemModels().slab("framed_slab", this.TEXTURE, this.TEXTURE, this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedStairs(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_STAIRS.get(), cube);
        ((ItemModelBuilder)this.itemModels().stairs("framed_stairs", this.TEXTURE, this.TEXTURE, this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedWall(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WALL.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_wall")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/wall_inventory")))).texture("wall", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedFence(ModelFile cube) {
        this.getMultipartBuilder((Block)FBContent.BLOCK_FRAMED_FENCE.get()).part().modelFile(cube).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_fence")).parent((ModelFile)this.models().getExistingFile(this.modLoc("item/framed_fence_inventory")))).texture("texture", this.TEXTURE)).texture("underlay", this.TEXTURE_UNDERLAY)).renderType("cutout");
    }

    private void registerFramedDoor(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_DOOR.get(), cube);
        this.simpleItem(FBContent.BLOCK_FRAMED_DOOR, "cutout");
    }

    private void registerFramedIronDoor(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_IRON_DOOR.get(), cube);
        this.simpleItem(FBContent.BLOCK_FRAMED_IRON_DOOR, "cutout");
    }

    private void registerFramedTrapDoor(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_TRAP_DOOR.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_trapdoor", this.mcLoc("block/template_orientable_trapdoor_bottom"))).texture("texture", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_PRESSURE_PLATE.get(), cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_PRESSURE_PLATE.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedStonePressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_STONE_PRESSURE_PLATE.get(), cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.STONE_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/stone_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.STONE_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/stone_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_stone_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/stone"))).renderType("cutout");
    }

    private void registerFramedObsidianPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_OBSIDIAN_PRESSURE_PLATE.get(), cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.OBSIDIAN_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/obsidian_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.OBSIDIAN_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/obsidian_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_obsidian_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/obsidian"))).renderType("cutout");
    }

    private void registerFramedGoldPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_GOLD_PRESSURE_PLATE.get(), cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.GOLD_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/gold_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.GOLD_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/gold_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_gold_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/gold_block"))).renderType("cutout");
    }

    private void registerFramedIronPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_IRON_PRESSURE_PLATE.get(), cube);
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.IRON_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/iron_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.IRON_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/iron_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_iron_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/iron_block"))).renderType("cutout");
    }

    private void registerFramedLadder() {
        ModelBuilder ladder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_ladder", this.mcLoc("block/cube"))).texture("0", this.TEXTURE)).texture("particle", this.TEXTURE)).element().face(Direction.NORTH).texture("#0").end().face(Direction.SOUTH).texture("#0").end().end();
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_LADDER, (ModelFile)ladder, "cutout");
    }

    private void registerFramedButton(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_BUTTON.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_button")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/button_inventory")))).texture("texture", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedLever() {
        ModelBuilder lever = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever", this.mcLoc("block/lever"))).texture("base", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder leverOn = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever_on", this.mcLoc("block/lever_on"))).texture("base", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_LEVER.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedLever$0((ModelFile)lever, (ModelFile)leverOn, arg_0), new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
        this.simpleItem(FBContent.BLOCK_FRAMED_LEVER, "cutout");
    }

    private void registerFramedSign(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_SIGN.get(), cube);
        this.simpleItem(FBContent.BLOCK_FRAMED_SIGN, "cutout");
    }

    private void registerFramedHangingSign() {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/framed_hanging_sign"));
        ModelFile.ExistingModelFile modelAttached = this.models().getExistingFile(this.modLoc("block/framed_hanging_sign_attached"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_HANGING_SIGN.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedHangingSign$1((ModelFile)modelAttached, (ModelFile)model, arg_0), new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT, BlockStateProperties.f_61362_});
        this.simpleItem(FBContent.BLOCK_FRAMED_HANGING_SIGN, "cutout");
    }

    private void registerFramedWallHangingSign() {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/framed_wall_hanging_sign"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_WALL_HANGING_SIGN.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedWallHangingSign$2((ModelFile)model, arg_0), new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT, BlockStateProperties.f_61362_});
    }

    private void registerFramedTorch() {
        ModelFile.ExistingModelFile torch = this.models().getExistingFile(this.modLoc("framed_torch"));
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_TORCH.get(), (ModelFile)torch);
        this.simpleItem(FBContent.BLOCK_FRAMED_TORCH, "block/framed_torch", "cutout");
    }

    private void registerFramedWallTorch() {
        ModelFile.ExistingModelFile wallTorch = this.models().getExistingFile(this.modLoc("framed_wall_torch"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_WALL_TORCH.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedWallTorch$3((ModelFile)wallTorch, arg_0), new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    private void registerFramedSoulTorch() {
        ModelBuilder torch = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_soul_torch", this.modLoc("framed_torch"))).texture("particle", this.modLoc("block/framed_soul_torch"))).texture("top", this.mcLoc("block/soul_torch"));
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_SOUL_TORCH.get(), (ModelFile)torch);
        this.simpleItem(FBContent.BLOCK_FRAMED_SOUL_TORCH, "block/framed_soul_torch", "cutout");
    }

    private void registerFramedSoulWallTorch() {
        ModelBuilder wallTorch = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_soul_wall_torch", this.modLoc("framed_wall_torch"))).texture("particle", this.modLoc("block/framed_soul_torch"))).texture("top", this.mcLoc("block/soul_torch"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_SOUL_WALL_TORCH.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedSoulWallTorch$4((ModelFile)wallTorch, arg_0), new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    private void registerFramedRedstoneTorch() {
        ModelFile.ExistingModelFile torch = this.models().getExistingFile(this.modLoc("framed_redstone_torch"));
        ModelBuilder torchOff = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_redstone_torch_off", this.modLoc("framed_torch"))).texture("particle", this.modLoc("block/framed_redstone_torch_off"))).texture("top", this.mcLoc("block/redstone_torch_off"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_REDSTONE_TORCH.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedRedstoneTorch$5((ModelFile)torch, (ModelFile)torchOff, arg_0), new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
        this.simpleItem(FBContent.BLOCK_FRAMED_REDSTONE_TORCH, "block/framed_redstone_torch", "cutout");
    }

    private void registerFramedRedstoneWallTorch() {
        ModelFile.ExistingModelFile wallTorch = this.models().getExistingFile(this.modLoc("framed_redstone_wall_torch"));
        ModelBuilder wallTorchOff = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_redstone_wall_torch_off", this.modLoc("framed_wall_torch"))).texture("particle", this.modLoc("block/framed_redstone_torch_off"))).texture("top", this.mcLoc("block/redstone_torch_off"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_REDSTONE_WALL_TORCH.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedRedstoneWallTorch$6((ModelFile)wallTorch, (ModelFile)wallTorchOff, arg_0), new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    private void registerFramedFloorBoard(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_FLOOR.get(), cube);
        ((ItemModelBuilder)this.itemModels().carpet("framed_floor_board", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedChest() {
        ModelFile.ExistingModelFile chest = this.models().getExistingFile(this.modLoc("block/framed_chest"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_CHEST.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedChest$7((ModelFile)chest, arg_0), new Property[]{BlockStateProperties.f_61362_, PropertyHolder.LATCH_TYPE, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
        this.simpleBlockItem(FBContent.BLOCK_FRAMED_CHEST, (ModelFile)chest, "cutout");
    }

    private void registerFramedBarsBlock(ModelFile cube) {
        this.getMultipartBuilder((Block)FBContent.BLOCK_FRAMED_BARS.get()).part().modelFile(cube).addModel();
        this.simpleItem(FBContent.BLOCK_FRAMED_BARS, "cutout");
    }

    private void registerFramedPaneBlock(ModelFile cube) {
        this.getMultipartBuilder((Block)FBContent.BLOCK_FRAMED_PANE.get()).part().modelFile(cube).addModel();
        this.simpleItem(FBContent.BLOCK_FRAMED_PANE, this.TEXTURE.m_135815_(), "cutout");
    }

    private void registerFramedFlowerPotBlock(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_FLOWER_POT.get(), cube);
        this.simpleItem(FBContent.BLOCK_FRAMED_FLOWER_POT, "cutout");
    }

    private void registerFramedCollapsibleBlock() {
        ModelBuilder block = this.makeUnderlayedCube("framed_collapsible_block", this.mcLoc("block/oak_planks")).renderType("cutout");
        this.makeUnderlayedCube("framed_collapsible_block_alt", this.TEXTURE_ALT, this.mcLoc("block/spruce_planks")).renderType("cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_COLLAPSIBLE_BLOCK, (ModelFile)block, "cutout");
    }

    private void registerFramedCollapsibleCopycatBlock() {
        ModelBuilder block = this.makeUnderlayedCube("framed_collapsible_copycat_block", this.mcLoc("block/copper_block")).renderType("cutout");
        this.makeUnderlayedCube("framed_collapsible_copycat_block_alt", this.TEXTURE_ALT, this.mcLoc("block/copper_block")).renderType("cutout");
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_COLLAPSIBLE_COPYCAT_BLOCK, (ModelFile)block, "cutout");
    }

    private void registerFramedBouncyBlock() {
        BlockModelBuilder block = this.makeUnderlayedCube("framed_bouncy_cube", this.mcLoc("block/slime_block"));
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_BOUNCY_CUBE, (ModelFile)block, "cutout");
        this.makeOverlayModel(FramedMarkedCubeModel.SLIME_FRAME_LOCATION, this.mcLoc("block/cube_all"), "all", this.modLoc("block/slime_frame"));
    }

    private void registerFramedSecretStorage() {
        ModelBuilder block = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_secret_storage", "block/block")).element().cube("#barrel").face(Direction.UP).texture("#barrel_top").end().face(Direction.DOWN).texture("#barrel_bottom").end().end()).element().cube("#frame").end()).texture("barrel", this.mcLoc("block/barrel_side"))).texture("barrel_top", this.mcLoc("block/barrel_top"))).texture("barrel_bottom", this.mcLoc("block/barrel_bottom"))).texture("frame", this.TEXTURE)).texture("particle", this.TEXTURE);
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_SECRET_STORAGE, (ModelFile)block, "cutout");
    }

    private void registerFramedRedstoneBlock() {
        BlockModelBuilder block = this.makeUnderlayedCube("framed_redstone_block", this.mcLoc("block/redstone_block"));
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_REDSTONE_BLOCK, (ModelFile)block, "cutout");
        this.makeOverlayModel(FramedMarkedCubeModel.REDSTONE_FRAME_LOCATION, this.mcLoc("block/cube_all"), "all", this.modLoc("block/redstone_frame"));
    }

    private void registerFramedGlowingCube() {
        BlockModelBuilder block = this.makeUnderlayedCube("framed_glowing_cube", new ResourceLocation("forge", "white"));
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_GLOWING_CUBE, (ModelFile)block);
    }

    private void registerFramedTarget(ModelFile cube) {
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_TARGET, cube, "cutout");
        ((OverlayLoaderBuilder)((BlockModelBuilder)this.models().getBuilder("target_overlay")).customLoader(OverlayLoaderBuilder::new)).model((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).element().cube("#overlay").faces((dir, face) -> face.tintindex(1024)).end()).texture("overlay", this.modLoc("block/target_overlay"))).renderType("cutout"));
    }

    private void registerFramedItemFrame() {
        ModelBuilder normalFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_item_frame", this.modLoc("block/template_framed_item_frame"))).texture("front", this.mcLoc("block/item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder normalMapFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_item_frame_map", this.modLoc("block/template_framed_item_frame_map"))).texture("front", this.mcLoc("block/item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder glowFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_glow_item_frame", this.modLoc("block/template_framed_item_frame"))).texture("front", this.mcLoc("block/glow_item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder glowMapFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_glow_item_frame_map", this.modLoc("block/template_framed_item_frame_map"))).texture("front", this.mcLoc("block/glow_item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        BiFunction<ModelFile, ModelFile, Function> mapper = (frame, mapFrame) -> state -> {
            int xRot = 0;
            int yRot = 0;
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            if (Utils.isY(dir)) {
                xRot = dir == Direction.UP ? 90 : -90;
            } else {
                yRot = (int)dir.m_122435_();
            }
            boolean map = (Boolean)state.m_61143_((Property)PropertyHolder.MAP_FRAME);
            return ConfiguredModel.builder().modelFile(map ? mapFrame : frame).rotationX(xRot).rotationY(yRot).build();
        };
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_ITEM_FRAME.get()).forAllStatesExcept(mapper.apply((ModelFile)normalFrame, (ModelFile)normalMapFrame), new Property[]{PropertyHolder.LEATHER, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_GLOWING_ITEM_FRAME.get()).forAllStatesExcept(mapper.apply((ModelFile)glowFrame, (ModelFile)glowMapFrame), new Property[]{PropertyHolder.LEATHER, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
        this.simpleItem(FBContent.BLOCK_FRAMED_ITEM_FRAME, "cutout");
        this.simpleItem(FBContent.BLOCK_FRAMED_GLOWING_ITEM_FRAME, "cutout");
    }

    private static Function<BlockState, ConfiguredModel[]> railStates(EnumProperty<RailShape> shapeProp, Function<BlockState, ModelFile> normalRail, Function<BlockState, ModelFile> ascendingRail, Function<BlockState, ModelFile> curvedRail) {
        return state -> {
            ModelFile model;
            RailShape shape = (RailShape)state.m_61143_((Property)shapeProp);
            int rotY = (int)FramedFancyRailModel.getDirectionFromRailShape(shape).m_122435_();
            if (shape.m_61745_()) {
                model = (ModelFile)ascendingRail.apply((BlockState)state);
                rotY = (rotY + 180) % 360;
            } else if (shape == RailShape.NORTH_SOUTH || shape == RailShape.EAST_WEST) {
                model = (ModelFile)normalRail.apply((BlockState)state);
            } else {
                model = (ModelFile)curvedRail.apply((BlockState)state);
                rotY = shape == RailShape.NORTH_EAST || shape == RailShape.SOUTH_WEST ? (rotY + 180) % 360 : (rotY + 90) % 360;
            }
            return ConfiguredModel.builder().rotationY(rotY).modelFile(model).build();
        };
    }

    private void registerFramedFancyRail() {
        ModelFile normalRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_RAIL);
        ModelFile ascendingRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_RAIL, "ascending");
        ModelFile curvedRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_RAIL, "curved");
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61403_, state -> normalRail, state -> ascendingRail, state -> curvedRail), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    private void registerFramedFancyPoweredRail() {
        ModelFile normalRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL);
        ModelBuilder normalRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL, "on").parent(normalRail)).texture("texture", this.mcLoc("block/powered_rail_on"))).texture("particle", this.mcLoc("block/powered_rail_on"));
        ModelFile ascendingRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL, "ascending");
        ModelBuilder ascendingRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL, "ascending_on").parent(ascendingRail)).texture("texture", this.mcLoc("block/powered_rail_on"))).texture("particle", this.mcLoc("block/powered_rail_on"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61404_, arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyPoweredRail$15((ModelFile)normalRailOn, normalRail, arg_0), arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyPoweredRail$16((ModelFile)ascendingRailOn, ascendingRail, arg_0), state -> null), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    private void registerFramedFancyDetectorRail() {
        ModelFile normalRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL);
        ModelBuilder normalRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL, "on").parent(normalRail)).texture("texture", this.mcLoc("block/detector_rail_on"))).texture("particle", this.mcLoc("block/detector_rail_on"));
        ModelFile ascendingRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL, "ascending");
        ModelBuilder ascendingRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL, "ascending_on").parent(ascendingRail)).texture("texture", this.mcLoc("block/detector_rail_on"))).texture("particle", this.mcLoc("block/detector_rail_on"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61404_, arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyDetectorRail$18((ModelFile)normalRailOn, normalRail, arg_0), arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyDetectorRail$19((ModelFile)ascendingRailOn, ascendingRail, arg_0), state -> null), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    private void registerFramedFancyActivatorRail() {
        ModelFile normalRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL);
        ModelBuilder normalRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL, "on").parent(normalRail)).texture("texture", this.mcLoc("block/activator_rail_on"))).texture("particle", this.mcLoc("block/activator_rail_on"));
        ModelFile ascendingRail = this.existingBlock(FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL, "ascending");
        ModelBuilder ascendingRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL, "ascending_on").parent(ascendingRail)).texture("texture", this.mcLoc("block/activator_rail_on"))).texture("particle", this.mcLoc("block/activator_rail_on"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61404_, arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyActivatorRail$21((ModelFile)normalRailOn, normalRail, arg_0), arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyActivatorRail$22((ModelFile)ascendingRailOn, ascendingRail, arg_0), state -> null), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    private void registerFramedMiniCube(ModelFile cube) {
        this.simpleBlock((Block)FBContent.BLOCK_FRAMED_MINI_CUBE.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_mini_cube", this.mcLoc("block/block"))).element().from(4.0f, 0.0f, 4.0f).to(12.0f, 8.0f, 12.0f).allFaces((d, f) -> f.uvs(0.0f, 0.0f, 16.0f, 16.0f)).textureAll("#all").end()).texture("all", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedOneWayWindow() {
        BlockModelBuilder model = this.makeUnderlayedCube("framed_one_way_window", this.mcLoc("block/moss_block"));
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_ONE_WAY_WINDOW, (ModelFile)model);
    }

    private void registerFramedBookshelf() {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/framed_bookshelf"));
        this.simpleBlockWithItem(FBContent.BLOCK_FRAMED_BOOKSHELF, (ModelFile)model);
    }

    private void registerFramedChiseledBookshelf(ModelFile cube) {
        String template = "block/template_framed_chiseled_bookshelf_slot_";
        String baseName = "framed_chiseled_bookshelf";
        String[] slots = new String[]{"top_left", "top_mid", "top_right", "bottom_left", "bottom_mid", "bottom_right"};
        ModelFile[] modelsEmpty = new ModelFile[6];
        ModelFile[] modelsFilled = new ModelFile[6];
        for (int i = 0; i < 6; ++i) {
            String slot = slots[i];
            modelsEmpty[i] = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_empty_slot_" + slot, this.modLoc(template + slot))).texture("texture", this.mcLoc("block/chiseled_bookshelf_empty"));
            modelsFilled[i] = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_occupied_slot_" + slot, this.modLoc(template + slot))).texture("texture", "minecraft:block/chiseled_bookshelf_occupied");
        }
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)FBContent.BLOCK_FRAMED_CHISELED_BOOKSHELF.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.mcLoc("block/block"))).addModel()).end();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (int i = 0; i < 6; ++i) {
                BooleanProperty prop = (BooleanProperty)ChiseledBookShelfBlock.f_260698_.get(i);
                int rot = (int)((dir.m_122435_() + 180.0f) % 360.0f);
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(modelsEmpty[i]).rotationY(rot).addModel()).nestedGroup().condition((Property)prop, (Comparable[])new Boolean[]{false}).condition((Property)FramedProperties.FACING_HOR, (Comparable[])new Direction[]{dir}).end().end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(modelsFilled[i]).rotationY(rot).addModel()).nestedGroup().condition((Property)prop, (Comparable[])new Boolean[]{true}).condition((Property)FramedProperties.FACING_HOR, (Comparable[])new Direction[]{dir}).end().end();
            }
        }
        this.simpleBlockItem(FBContent.BLOCK_FRAMED_CHISELED_BOOKSHELF, cube);
    }

    private void registerFramingSaw() {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/framing_saw"));
        this.getVariantBuilder((Block)FBContent.BLOCK_FRAMING_SAW.get()).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramingSaw$25((ModelFile)model, arg_0));
        this.simpleBlockItem(FBContent.BLOCK_FRAMING_SAW, (ModelFile)model);
    }

    private void registerPoweredFramingSaw() {
        ModelBuilder modelInactive = ((BlockModelBuilder)this.models().withExistingParent("powered_framing_saw_inactive", this.modLoc("block/powered_framing_saw"))).texture("saw", FramedSpriteSourceProvider.SPRITE_SAW_STILL);
        ModelBuilder modelActive = ((BlockModelBuilder)this.models().withExistingParent("powered_framing_saw_active", this.modLoc("block/powered_framing_saw"))).texture("saw", this.mcLoc("block/stonecutter_saw"));
        this.getVariantBuilder((Block)FBContent.BLOCK_POWERED_FRAMING_SAW.get()).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerPoweredFramingSaw$26((ModelFile)modelActive, (ModelFile)modelInactive, arg_0));
        this.simpleBlockItem(FBContent.BLOCK_POWERED_FRAMING_SAW, (ModelFile)modelActive);
    }

    private BlockModelBuilder block(RegistryObject<Block> block) {
        return this.block(block, "");
    }

    private BlockModelBuilder block(RegistryObject<Block> block, String suffix) {
        String name = block.getId().m_135815_();
        String path = "block/" + name;
        if (!suffix.isBlank()) {
            path = path + "_" + suffix;
        }
        return (BlockModelBuilder)this.models().getBuilder(path);
    }

    private ModelFile existingBlock(RegistryObject<Block> block) {
        return this.existingBlock(block, "");
    }

    private ModelFile existingBlock(RegistryObject<Block> block, String suffix) {
        ResourceLocation name = block.getId();
        String path = "block/" + name.m_135815_();
        if (!suffix.isBlank()) {
            path = path + "_" + suffix;
        }
        return this.models().getExistingFile(new ResourceLocation(name.m_135827_(), path));
    }

    private ItemModelBuilder simpleBlockWithItem(RegistryObject<Block> block, ModelFile model, String itemRenderType) {
        return (ItemModelBuilder)this.simpleBlockWithItem(block, model).renderType(itemRenderType);
    }

    private ItemModelBuilder simpleBlockWithItem(RegistryObject<Block> block, ModelFile model) {
        this.simpleBlock((Block)block.get(), model);
        return this.simpleBlockItem(block, model);
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> block, ModelFile model, String renderType) {
        return (ItemModelBuilder)this.simpleBlockItem(block, model).renderType(renderType);
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> block, ModelFile model) {
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(block.getId().m_135815_())).parent(model);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Block> block, String renderType) {
        return this.simpleItem(block.getId().m_135815_(), renderType);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Block> block, String texture, String renderType) {
        return this.simpleItem(block.getId().m_135815_(), texture, renderType);
    }

    private ItemModelBuilder simpleItem(String name, String renderType) {
        return this.simpleItem(name, "item/" + name, renderType);
    }

    private ItemModelBuilder simpleItem(String name, String texture, String renderType) {
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().singleTexture(name, this.mcLoc("item/generated"), "layer0", this.modLoc(texture))).renderType(renderType);
    }

    private BlockModelBuilder makeUnderlayedCube(String name, ResourceLocation underlayTex) {
        return this.makeUnderlayedCube(name, this.TEXTURE, underlayTex);
    }

    private BlockModelBuilder makeUnderlayedCube(String name, ResourceLocation frameTex, ResourceLocation underlayTex) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/block")).element().cube("#underlay").end()).element().cube("#frame").end()).texture("frame", frameTex)).texture("underlay", underlayTex)).texture("particle", frameTex)).renderType("cutout");
    }

    private void makeOverlayModel(ResourceLocation name, ResourceLocation parent, String textureKey, ResourceLocation texture) {
        this.makeOverlayModel(name, parent, textureKey, texture, null);
    }

    private void makeOverlayModel(ResourceLocation name, ResourceLocation parent, String textureKey, ResourceLocation texture, Vector3f center) {
        OverlayLoaderBuilder builder = ((OverlayLoaderBuilder)((BlockModelBuilder)this.models().getBuilder(name.m_135815_())).customLoader(OverlayLoaderBuilder::new)).model((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(parent))).texture(textureKey, texture));
        if (center != null) {
            builder.center(center);
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerPoweredFramingSaw$26(ModelFile modelActive, ModelFile modelInactive, BlockState state) {
        int rotY = (int)((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122435_();
        return ConfiguredModel.builder().rotationY(rotY).modelFile((Boolean)state.m_61143_((Property)PropertyHolder.ACTIVE) != false ? modelActive : modelInactive).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramingSaw$25(ModelFile model, BlockState state) {
        int rotY = (int)((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122435_();
        return ConfiguredModel.builder().rotationY(rotY).modelFile(model).build();
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyActivatorRail$22(ModelFile ascendingRailOn, ModelFile ascendingRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? ascendingRailOn : ascendingRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyActivatorRail$21(ModelFile normalRailOn, ModelFile normalRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? normalRailOn : normalRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyDetectorRail$19(ModelFile ascendingRailOn, ModelFile ascendingRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? ascendingRailOn : ascendingRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyDetectorRail$18(ModelFile normalRailOn, ModelFile normalRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? normalRailOn : normalRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyPoweredRail$16(ModelFile ascendingRailOn, ModelFile ascendingRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? ascendingRailOn : ascendingRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyPoweredRail$15(ModelFile normalRailOn, ModelFile normalRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? normalRailOn : normalRail;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedChest$7(ModelFile chest, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 180) % 360;
        return ConfiguredModel.builder().modelFile(chest).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedRedstoneWallTorch$6(ModelFile wallTorch, ModelFile wallTorchOff, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        ModelFile model = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? wallTorch : wallTorchOff;
        return ConfiguredModel.builder().modelFile(model).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedRedstoneTorch$5(ModelFile torch, ModelFile torchOff, BlockState state) {
        ModelFile model = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? torch : torchOff;
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedSoulWallTorch$4(ModelFile wallTorch, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        return ConfiguredModel.builder().modelFile(wallTorch).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedWallTorch$3(ModelFile wallTorch, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        return ConfiguredModel.builder().modelFile(wallTorch).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedWallHangingSign$2(ModelFile model, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return ConfiguredModel.builder().modelFile(model).rotationY((int)facing.m_122435_()).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedHangingSign$1(ModelFile modelAttached, ModelFile model, BlockState state) {
        int rotation = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
        Direction facing = Direction.m_122407_((int)(rotation / 4));
        boolean attached = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61386_);
        return ConfiguredModel.builder().modelFile(attached ? modelAttached : model).rotationY((int)facing.m_122435_()).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedLever$0(ModelFile lever, ModelFile leverOn, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        AttachFace face = (AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
        boolean powered = (Boolean)state.m_61143_((Property)LeverBlock.f_54622_);
        int rotY = (int)(facing.m_122435_() + (face != AttachFace.CEILING ? 180.0f : 0.0f)) % 360;
        int rotX = face.ordinal() * 90;
        ModelFile model = powered ? lever : leverOn;
        return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(rotY).build();
    }
}

