/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.FTBEssentialsPlatform;
import dev.ftb.mods.ftbessentials.command.FTBEssentialsCommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.OtherPlayerInventory;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;

public class CheatCommands {
    private static final UUID ESSENTIALS_SPEED_UUID = UUID.fromString("3a8a9187-94ab-4272-99c0-ca764a19f8f1");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.HEAL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"heal").requires(FTBEConfig.HEAL.enabledAndOp())).executes(context -> CheatCommands.heal(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.heal(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.FEED.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"feed").requires(FTBEConfig.FEED.enabledAndOp())).executes(context -> CheatCommands.feed(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.feed(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.EXTINGUISH.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"extinguish").requires(FTBEConfig.EXTINGUISH.enabledAndOp())).executes(context -> CheatCommands.extinguish(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.extinguish(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.FLY.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fly").requires(FTBEConfig.FLY.enabledAndOp())).executes(context -> CheatCommands.fly(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.fly(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.SPEED.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"speed").executes(context -> CheatCommands.speed((CommandSourceStack)context.getSource(), Attributes.f_22279_, ((CommandSourceStack)context.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"boost_percent", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)2000)).requires(FTBEConfig.SPEED.enabledAndOp())).executes(context -> CheatCommands.speed((CommandSourceStack)context.getSource(), Attributes.f_22279_, ((CommandSourceStack)context.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"boost_percent")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.speed((CommandSourceStack)context.getSource(), Attributes.f_22279_, EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"boost_percent"))))));
        }
        if (FTBEConfig.GOD.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"god").requires(FTBEConfig.GOD.enabledAndOp())).executes(context -> CheatCommands.god(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.god(EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.INVSEE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"invsee").requires(FTBEConfig.INVSEE.enabledAndOp())).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.viewInventory(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.NICK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nicknamefor").requires(FTBEConfig.NICK.enabledAndOp())).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.nicknameFor((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.m_6761_(2))).executes(context -> CheatCommands.nicknameFor((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"nickname"))))));
        }
        if (FTBEConfig.MUTE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mute").requires(FTBEConfig.MUTE.enabledAndOp())).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.mute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), ""))).then(Commands.m_82129_((String)"until", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> FTBEssentialsCommands.suggestDurations(builder)).executes(context -> CheatCommands.mute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"until"))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unmute").requires(FTBEConfig.MUTE.enabledAndOp())).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CheatCommands.unmute((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.TP_OFFLINE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tp_offline").requires(FTBEConfig.TP_OFFLINE.enabledAndOp())).then(Commands.m_82127_((String)"name").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CheatCommands.tpOffline((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), ((CommandSourceStack)ctx.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)ctx, (String)"pos"))))))).then(Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"player_id", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CheatCommands.tpOffline((CommandSourceStack)ctx.getSource(), UuidArgument.m_113853_((CommandContext)ctx, (String)"player_id"), ((CommandSourceStack)ctx.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)ctx, (String)"pos")))))));
        }
    }

    private static int speed(CommandSourceStack source, Attribute attr, ServerPlayer player) {
        AttributeInstance attrInstance = player.m_21051_(attr);
        CheatCommands.showSpeed(source, player, attrInstance);
        return 1;
    }

    private static int speed(CommandSourceStack source, Attribute attr, ServerPlayer target, int boostPct) {
        AttributeInstance attrInstance = target.m_21051_(attr);
        if (attrInstance != null) {
            float speedMult = (float)boostPct / 100.0f;
            attrInstance.m_22120_(ESSENTIALS_SPEED_UUID);
            if (speedMult != 0.0f) {
                attrInstance.m_22125_(new AttributeModifier(ESSENTIALS_SPEED_UUID, "FTB Essentials speed boost", (double)speedMult, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            CheatCommands.showSpeed(source, target, attrInstance);
        }
        return 1;
    }

    private static void showSpeed(CommandSourceStack source, ServerPlayer target, AttributeInstance attrInstance) {
        MutableComponent msg;
        if (attrInstance != null && attrInstance.m_22111_(ESSENTIALS_SPEED_UUID) != null) {
            double speedMult = attrInstance.m_22111_(ESSENTIALS_SPEED_UUID).m_22218_();
            int boostPct = (int)(speedMult * 100.0);
            msg = Component.m_237113_((String)"Speed boost for ").m_7220_(target.m_5446_()).m_130946_(" (").m_7220_((Component)Component.m_237115_((String)attrInstance.m_22099_().m_22087_())).m_130946_(") = " + boostPct + "%");
        } else {
            msg = Component.m_237113_((String)"No speed boost for ").m_7220_(target.m_5446_());
        }
        source.m_288197_(() -> CheatCommands.lambda$showSpeed$24((Component)msg), false);
        if (!source.m_230897_() || source.m_230896_() != target) {
            target.m_5661_((Component)msg, false);
        }
    }

    public static int heal(ServerPlayer player) {
        player.m_21153_(player.m_21233_());
        player.m_36324_().m_38707_(40, 40.0f);
        player.m_20095_();
        FTBEssentialsPlatform.curePotionEffects(player);
        return 1;
    }

    public static int feed(ServerPlayer player) {
        player.m_36324_().m_38707_(40, 40.0f);
        return 1;
    }

    public static int extinguish(ServerPlayer player) {
        player.m_20095_();
        return 1;
    }

    public static int fly(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            Abilities abilities = player.m_150110_();
            if (data.canFly()) {
                data.setCanFly(false);
                abilities.f_35936_ = false;
                abilities.f_35935_ = false;
                player.m_5661_((Component)Component.m_237113_((String)"Flight disabled"), true);
            } else {
                data.setCanFly(true);
                abilities.f_35936_ = true;
                player.m_5661_((Component)Component.m_237113_((String)"Flight enabled"), true);
            }
            player.m_6885_();
            return 1;
        }).orElse(0);
    }

    public static int god(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            Abilities abilities = player.m_150110_();
            if (data.isGod()) {
                data.setGod(false);
                abilities.f_35934_ = false;
                player.m_5661_((Component)Component.m_237113_((String)"God mode disabled"), true);
            } else {
                data.setGod(true);
                abilities.f_35934_ = true;
                player.m_5661_((Component)Component.m_237113_((String)"God mode enabled"), true);
            }
            player.m_6885_();
            return 1;
        }).orElse(0);
    }

    public static int viewInventory(ServerPlayer source, final ServerPlayer player) {
        source.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return player.m_5446_();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p) {
                return new ChestMenu(MenuType.f_39961_, id, playerInventory, (Container)new OtherPlayerInventory(player), 5);
            }
        });
        return 1;
    }

    public static int nicknameFor(CommandSourceStack source, ServerPlayer player, String nick) {
        if (nick.length() > 30) {
            player.m_5661_((Component)Component.m_237113_((String)"Nickname too long!"), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setNick(nick.trim());
            data.markDirty();
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getNick().isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"Nickname reset!"), true);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Nickname changed to '" + data.getNick() + "'")), true);
            }
            data.sendTabName(source.m_81377_());
            return 1;
        }).orElse(0);
    }

    public static int mute(CommandSourceStack source, ServerPlayer player, String duration) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            try {
                DurationInfo info = DurationInfo.fromString(duration);
                data.setMuted(true);
                FTBEWorldData.instance.setMuteTimeout(player, info.until());
                MutableComponent msg = player.m_5446_().m_6881_().m_130946_(" has been muted by ").m_7220_(source.m_81357_()).m_130946_(", ").m_130946_(info.desc());
                CheatCommands.notifyMuting(source, (Player)player, (Component)msg);
                return 1;
            }
            catch (IllegalArgumentException e) {
                source.m_81352_((Component)Component.m_237113_((String)("Invalid duration syntax: '" + duration + "': " + e.getMessage())));
                return 0;
            }
        }).orElse(0);
    }

    public static int unmute(CommandSourceStack source, ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setMuted(false);
            FTBEWorldData.instance.setMuteTimeout(player, -1L);
            MutableComponent msg = player.m_5446_().m_6881_().m_130946_(" has been unmuted by ").m_7220_(source.m_81357_());
            CheatCommands.notifyMuting(source, (Player)player, (Component)msg);
            return 1;
        }).orElse(0);
    }

    private static void notifyMuting(CommandSourceStack source, Player target, Component msg) {
        source.m_81377_().m_6846_().m_11314_().forEach(p -> {
            if (p.m_20310_(2) || p == target) {
                p.m_5661_(msg, false);
            }
        });
        if (!source.m_230897_()) {
            source.m_288197_(() -> msg, true);
        }
    }

    private static int tpOffline(CommandSourceStack source, String playerName, ServerLevel level, Coordinates dest) {
        source.m_81377_().m_129927_().m_143967_(playerName, profileOpt -> source.m_81377_().m_201446_(() -> profileOpt.ifPresentOrElse(profile -> CheatCommands.tpOffline(source, profile.getId(), level, dest), () -> source.m_81352_((Component)Component.m_237113_((String)("Unknown player: " + playerName))))));
        return 1;
    }

    private static int tpOffline(CommandSourceStack source, UUID playerId, ServerLevel level, Coordinates dest) {
        MinecraftServer server = source.m_81377_();
        Path playerDir = server.m_129843_(LevelResource.f_78176_);
        File datFile = playerDir.resolve(playerId + ".dat").toFile();
        if (server.m_6846_().m_11259_(playerId) != null) {
            source.m_81352_((Component)Component.m_237113_((String)"Player is online! Use regular /tp command instead"));
            return 0;
        }
        try {
            CompoundTag tag = NbtIo.m_128937_((File)datFile);
            Vec3 vec = dest.m_6955_(source);
            ListTag newPos = new ListTag();
            newPos.add((Object)DoubleTag.m_128500_((double)vec.f_82479_));
            newPos.add((Object)DoubleTag.m_128500_((double)vec.f_82480_));
            newPos.add((Object)DoubleTag.m_128500_((double)vec.f_82481_));
            tag.m_128365_("Pos", (Tag)newPos);
            tag.m_128359_("Dimension", level.m_46472_().m_135782_().toString());
            File tempFile = File.createTempFile(playerId + "-", ".dat", playerDir.toFile());
            NbtIo.m_128944_((CompoundTag)tag, (File)tempFile);
            File backupFile = new File(playerDir.toFile(), playerId + ".dat_old");
            Util.m_137462_((File)datFile, (File)tempFile, (File)backupFile);
            source.m_288197_(() -> Component.m_237113_((String)String.format("Offline player %s moved to [%.2f,%.2f,%.2f] in %s", playerId, vec.f_82479_, vec.f_82480_, vec.f_82481_, source.m_81372_().m_46472_().m_135782_())), false);
            return 1;
        }
        catch (IOException e) {
            source.m_81352_((Component)Component.m_237113_((String)("Can't update dat file: " + e.getMessage())));
            return 0;
        }
    }

    private static /* synthetic */ Component lambda$showSpeed$24(Component msg) {
        return msg;
    }
}

