/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbessentials.command.MiscCommands;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;

public class Leaderboard<N extends Number> {
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("########0.00"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final Map<String, Leaderboard<?>> MAP = new LinkedHashMap();
    private final String name;
    private final N defaultValue;
    private Function<ServerStatsCounter, N> valueGetter;
    private Predicate<N> filter;
    private Function<N, String> stringGetter;

    public static <T extends Number> Leaderboard<T> add(String name, T defaultValue) {
        Leaderboard<T> leaderboard = new Leaderboard<T>(name, defaultValue);
        MAP.put(name, leaderboard);
        return leaderboard;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> buildCommand() {
        LiteralArgumentBuilder res = Commands.m_82127_((String)"leaderboard");
        for (Leaderboard<?> leaderboard : MAP.values()) {
            res = (LiteralArgumentBuilder)res.then(Commands.m_82127_((String)leaderboard.name).executes(context -> MiscCommands.leaderboard((CommandSourceStack)context.getSource(), leaderboard, false)));
        }
        return res;
    }

    public Leaderboard(String name, N defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.valueGetter = stats -> this.defaultValue;
        this.filter = num -> !num.equals(this.defaultValue);
        this.stringGetter = num -> NumberFormat.getIntegerInstance(Locale.US).format(num.intValue());
    }

    public String getName() {
        return this.name;
    }

    public Leaderboard<N> withValueGetter(Function<ServerStatsCounter, N> v) {
        this.valueGetter = v;
        return this;
    }

    public Leaderboard<N> withFilter(Predicate<N> f) {
        this.filter = f;
        return this;
    }

    public Leaderboard<N> withStringGetter(Function<N, String> s) {
        this.stringGetter = s;
        return this;
    }

    public N getValue(ServerStatsCounter stats) {
        return (N)((Number)this.valueGetter.apply(stats));
    }

    public boolean test(N num) {
        return this.filter.test(num);
    }

    public String asString(N num) {
        return this.stringGetter.apply(num);
    }

    public Leaderboard<N> formatDivideByTen() {
        return this.withStringGetter(value -> DECIMAL_FORMAT.format(value.doubleValue() * 0.1));
    }

    public Leaderboard<N> formatDistance() {
        return this.withStringGetter(value -> {
            double d0 = value.doubleValue() / 100.0;
            double d1 = d0 / 1000.0;
            if (d1 > 0.5) {
                return DECIMAL_FORMAT.format(d1) + " km";
            }
            return d0 > 0.5 ? DECIMAL_FORMAT.format(d0) + " m" : value + " cm";
        });
    }

    public Leaderboard<N> formatTime() {
        return this.withStringGetter(value -> {
            double d0 = value.doubleValue() / 20.0;
            double d1 = d0 / 60.0;
            double d2 = d1 / 60.0;
            double d3 = d2 / 24.0;
            double d4 = d3 / 365.0;
            if (d4 > 0.5) {
                return DECIMAL_FORMAT.format(d4) + " y";
            }
            if (d3 > 0.5) {
                return DECIMAL_FORMAT.format(d3) + " d";
            }
            if (d2 > 0.5) {
                return DECIMAL_FORMAT.format(d2) + " h";
            }
            return d1 > 0.5 ? DECIMAL_FORMAT.format(d1) + " m" : d0 + " s";
        });
    }

    static {
        Leaderboard.add("deaths", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)));
        Leaderboard.add("time_played", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_))).formatTime();
        Leaderboard.add("deaths_per_hour", 0.0).withValueGetter(stats -> {
            int d = stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_));
            int t = stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_));
            return d <= 0 || t < 72000 ? 0.0 : (double)d * 72000.0 / (double)t;
        }).withStringGetter(value -> DECIMAL_FORMAT.format((double)value));
        Leaderboard.add("player_kills", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12938_)));
        Leaderboard.add("mob_kills", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12936_)));
        Leaderboard.add("damage_dealt", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12928_))).formatDivideByTen();
        Leaderboard.add("jumps", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12926_)));
        Leaderboard.add("distance_walked", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12994_))).formatDistance();
        Leaderboard.add("time_since_death", 0).withValueGetter(stats -> stats.m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_))).formatTime();
    }
}

