/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.roller;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlock;
import com.simibubi.create.content.contraptions.actors.roller.RollerMovementBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RollerBlockEntity
extends SmartBlockEntity {
    private float manuallyAnimatedSpeed;
    public FilteringBehaviour filtering;
    public ScrollOptionBehaviour<RollingMode> mode;
    private boolean dontPropagate = false;

    public RollerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new RollerValueBox(3));
        behaviours.add(this.filtering);
        this.mode = new ScrollOptionBehaviour<RollingMode>(RollingMode.class, (Component)CreateLang.translateDirect("contraptions.roller_mode", new Object[0]), this, new RollerValueBox(-3));
        behaviours.add(this.mode);
        this.filtering.setLabel(CreateLang.translateDirect("contraptions.mechanical_roller.pave_material", new Object[0]));
        this.filtering.withCallback(this::onFilterChanged);
        this.filtering.withPredicate(this::isValidMaterial);
        this.mode.withCallback(this::onModeChanged);
    }

    protected void onModeChanged(int mode) {
        this.shareValuesToAdjacent();
    }

    protected void onFilterChanged(ItemStack newFilter) {
        this.shareValuesToAdjacent();
    }

    protected boolean isValidMaterial(ItemStack newFilter) {
        if (newFilter.m_41619_()) {
            return true;
        }
        BlockState appliedState = RollerMovementBehaviour.getStateToPaveWith(newFilter);
        if (appliedState.m_60795_()) {
            return false;
        }
        if (appliedState.m_60734_() instanceof EntityBlock) {
            return false;
        }
        if (appliedState.m_60734_() instanceof StairBlock) {
            return false;
        }
        VoxelShape shape = appliedState.m_60808_((BlockGetter)this.f_58857_, this.f_58858_);
        if (shape.m_83281_() || !shape.m_83215_().equals((Object)Shapes.m_83144_().m_83215_())) {
            return false;
        }
        VoxelShape collisionShape = appliedState.m_60812_((BlockGetter)this.f_58857_, this.f_58858_);
        return !collisionShape.m_83281_();
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(1.0);
    }

    public float getAnimatedSpeed() {
        return this.manuallyAnimatedSpeed;
    }

    public void setAnimatedSpeed(float speed) {
        this.manuallyAnimatedSpeed = speed;
    }

    public void searchForSharedValues() {
        BlockState blockState = this.m_58900_();
        Direction facing = blockState.m_61145_((Property)RollerBlock.f_54117_).orElse(Direction.SOUTH);
        for (int side : Iterate.positiveAndNegative) {
            BlockEntity blockEntity;
            BlockPos pos = this.f_58858_.m_5484_(facing.m_122427_(), side);
            if (this.f_58857_.m_8055_(pos) != blockState || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof RollerBlockEntity)) continue;
            RollerBlockEntity otherRoller = (RollerBlockEntity)blockEntity;
            this.acceptSharedValues(otherRoller.mode.getValue(), otherRoller.filtering.getFilter());
            this.shareValuesToAdjacent();
            break;
        }
    }

    protected void acceptSharedValues(int mode, ItemStack filter) {
        this.dontPropagate = true;
        this.filtering.setFilter(filter.m_41777_());
        this.mode.setValue(mode);
        this.dontPropagate = false;
        this.notifyUpdate();
    }

    public void shareValuesToAdjacent() {
        if (this.dontPropagate || this.f_58857_.m_5776_()) {
            return;
        }
        BlockState blockState = this.m_58900_();
        Direction facing = blockState.m_61145_((Property)RollerBlock.f_54117_).orElse(Direction.SOUTH);
        for (int side : Iterate.positiveAndNegative) {
            BlockEntity blockEntity;
            BlockPos pos;
            for (int i = 1; i < 100 && this.f_58857_.m_8055_(pos = this.f_58858_.m_5484_(facing.m_122427_(), side * i)) == blockState && (blockEntity = this.f_58857_.m_7702_(pos)) instanceof RollerBlockEntity; ++i) {
                RollerBlockEntity otherRoller = (RollerBlockEntity)blockEntity;
                otherRoller.acceptSharedValues(this.mode.getValue(), this.filtering.getFilter());
            }
        }
    }

    private final class RollerValueBox
    extends ValueBoxTransform {
        private int hOffset;

        public RollerValueBox(int hOffset) {
            this.hOffset = hOffset;
        }

        @Override
        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            Direction facing = (Direction)state.m_61143_((Property)RollerBlock.f_54117_);
            float yRot = AngleHelper.horizontalAngle((Direction)facing) + 180.0f;
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(90.0f);
        }

        @Override
        public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
            Vec3 offset = this.getLocalOffset(level, pos, state);
            if (offset == null) {
                return false;
            }
            return localHit.m_82554_(offset) < (double)(this.scale / 3.0f);
        }

        @Override
        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)RollerBlock.f_54117_);
            float stateAngle = AngleHelper.horizontalAngle((Direction)facing) + 180.0f;
            return VecHelper.rotateCentered((Vec3)VecHelper.voxelSpace((double)(8 + this.hOffset), (double)15.5, (double)11.0), (double)stateAngle, (Direction.Axis)Direction.Axis.Y);
        }
    }

    static enum RollingMode implements INamedIconOptions
    {
        TUNNEL_PAVE(AllIcons.I_ROLLER_PAVE),
        STRAIGHT_FILL(AllIcons.I_ROLLER_FILL),
        WIDE_FILL(AllIcons.I_ROLLER_WIDE_FILL);

        private String translationKey;
        private AllIcons icon;

        private RollingMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.roller_mode." + Lang.asId((String)this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

