/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link.controller;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.content.redstone.link.controller.LecternControllerBlock;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerBindPacket;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerInputPacket;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerItemRenderer;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerStopLecternPacket;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Vector;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class LinkedControllerClientHandler {
    public static final IGuiOverlay OVERLAY = LinkedControllerClientHandler::renderOverlay;
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    private static BlockPos lecternPos;
    private static BlockPos selectedLocation;
    private static int packetCooldown;

    public static void toggleBindMode(BlockPos location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static void toggle() {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = null;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static void activateInLectern(BlockPos lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = lecternAt;
        }
    }

    public static void deactivateInLectern() {
        if (MODE == Mode.ACTIVE && LinkedControllerClientHandler.inLectern()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static boolean inLectern() {
        return lecternPos != null;
    }

    protected static void onReset() {
        ControlsUtil.getControls().forEach(kb -> kb.m_7249_(ControlsUtil.isActuallyPressed(kb)));
        packetCooldown = 0;
        selectedLocation = BlockPos.f_121853_;
        if (LinkedControllerClientHandler.inLectern()) {
            AllPackets.getChannel().sendToServer((Object)new LinkedControllerStopLecternPacket(lecternPos));
        }
        lecternPos = null;
        if (!currentlyPressed.isEmpty()) {
            AllPackets.getChannel().sendToServer((Object)new LinkedControllerInputPacket(currentlyPressed, false));
        }
        currentlyPressed.clear();
        LinkedControllerItemRenderer.resetButtons();
    }

    public static void tick() {
        LinkedControllerItemRenderer.tick();
        if (MODE == Mode.IDLE) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (player.m_5833_()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (!(LinkedControllerClientHandler.inLectern() || AllItems.LINKED_CONTROLLER.isIn(heldItem) || AllItems.LINKED_CONTROLLER.isIn(heldItem = player.m_21206_()))) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (LinkedControllerClientHandler.inLectern() && ((LecternControllerBlock)AllBlocks.LECTERN_CONTROLLER.get()).getBlockEntityOptional((BlockGetter)mc.f_91073_, lecternPos).map(be -> !be.isUsedBy((Player)mc.f_91074_)).orElse(true).booleanValue()) {
            LinkedControllerClientHandler.deactivateInLectern();
            return;
        }
        if (mc.f_91080_ != null) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)256)) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        Vector<KeyMapping> controls = ControlsUtil.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed(controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (MODE == Mode.ACTIVE) {
            if (!releasedKeys.isEmpty()) {
                AllPackets.getChannel().sendToServer((Object)new LinkedControllerInputPacket(releasedKeys, false, lecternPos));
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 0.5f, true);
            }
            if (!newKeys.isEmpty()) {
                AllPackets.getChannel().sendToServer((Object)new LinkedControllerInputPacket(newKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 0.75f, true);
            }
            if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
                AllPackets.getChannel().sendToServer((Object)new LinkedControllerInputPacket(pressedKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
            }
        }
        if (MODE == Mode.BIND) {
            Iterator iterator;
            VoxelShape shape = mc.f_91073_.m_8055_(selectedLocation).m_60808_((BlockGetter)mc.f_91073_, selectedLocation);
            if (!shape.m_83281_()) {
                Outliner.getInstance().showAABB((Object)"controller", shape.m_83215_().m_82338_(selectedLocation)).colored(12008493).lineWidth(0.0625f);
            }
            if ((iterator = newKeys.iterator()).hasNext()) {
                Integer integer = (Integer)iterator.next();
                LinkBehaviour linkBehaviour = BlockEntityBehaviour.get((BlockGetter)mc.f_91073_, selectedLocation, LinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    AllPackets.getChannel().sendToServer((Object)new LinkedControllerBindPacket(integer, selectedLocation));
                    CreateLang.translate("linked_controller.key_bound", controls.get(integer).m_90863_().getString()).sendStatus((Player)mc.f_91074_);
                }
                MODE = Mode.IDLE;
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.m_7249_(false));
    }

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width1, int height1) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        if (MODE != Mode.BIND) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        Screen tooltipScreen = new Screen(CommonComponents.f_237098_){};
        tooltipScreen.m_6575_(mc, width1, height1);
        Object[] keys = new Object[6];
        Vector<KeyMapping> controls = ControlsUtil.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            KeyMapping keyBinding = controls.get(i);
            keys[i] = keyBinding.m_90863_().getString();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(CreateLang.translateDirect("linked_controller.bind_mode", new Object[0]).m_130940_(ChatFormatting.GOLD));
        list.addAll(TooltipHelper.cutTextComponent((Component)CreateLang.translateDirect("linked_controller.press_keybind", keys), FontHelper.Palette.ALL_GRAY));
        int width = 0;
        int n = list.size();
        Objects.requireNonNull(mc.f_91062_);
        int height = n * 9;
        for (Component component : list) {
            width = Math.max(width, mc.f_91062_.m_92852_((FormattedText)component));
        }
        int x = width1 / 3 - width / 2;
        int n2 = height1 - height - 24;
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, x, n2);
        poseStack.m_85849_();
    }

    static {
        selectedLocation = BlockPos.f_121853_;
    }

    public static enum Mode {
        IDLE,
        ACTIVE,
        BIND;

    }
}

