/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class ShulkerBoxFromVanillaShapelessRecipe
extends ShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapelessRecipe compose;

    public ShulkerBoxFromVanillaShapelessRecipe(ShapelessRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.f_44243_, compose.m_7527_());
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public boolean m_5818_(CraftingContainer inventory, Level level) {
        return super.m_5818_(inventory, level) && this.getVanillaShulkerBox(inventory).map(storage -> !(storage.m_41720_() instanceof WoodStorageBlockItem) || !WoodStorageBlockItem.isPacked(storage)).orElse(false) != false;
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public ItemStack m_5874_(CraftingContainer input, RegistryAccess registries) {
        ItemStack upgradedStorage = super.m_5874_(input, registries);
        this.getVanillaShulkerBox(input).ifPresent(vanillaShulkerBox -> vanillaShulkerBox.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemCap -> upgradedStorage.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).ifPresent(wrapper -> InventoryHelper.iterate((IItemHandler)itemCap, (slot, stack) -> {
            if (!stack.m_41619_()) {
                wrapper.getInventoryHandler().insertItem(stack, false);
            }
        }))));
        return upgradedStorage;
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getVanillaShulkerBox(CraftingContainer input) {
        for (int slot = 0; slot < input.m_6643_(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = input.m_8020_(slot);
            Item item = slotStack.m_41720_();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return ModBlocks.SHULKER_BOX_FROM_VANILLA_SHAPELESS_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, ShulkerBoxFromVanillaShapelessRecipe> {
        public Serializer() {
            super(ShulkerBoxFromVanillaShapelessRecipe::new, RecipeSerializer.f_44077_);
        }
    }
}

