/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.extractinator.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.recipes.IngredientCodec;
import com.teamresourceful.resourcefullib.common.codecs.tags.HolderSetCodec;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipe;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.extractinator.common.registry.ModRecipeSerializers;
import tech.alexnijjar.extractinator.common.registry.ModRecipeTypes;

public record ExtractinatorRecipe(ResourceLocation id, Ingredient input, List<Drop> outputs) implements CodecRecipe<Container>
{
    public static Codec<ExtractinatorRecipe> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)IngredientCodec.CODEC.fieldOf("input").forGetter(ExtractinatorRecipe::input), (App)Drop.CODEC.listOf().fieldOf("drops").forGetter(ExtractinatorRecipe::outputs)).apply((Applicative)instance, ExtractinatorRecipe::new));
    }

    public static Codec<ExtractinatorRecipe> networkingCodec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)IngredientCodec.NETWORK_CODEC.fieldOf("input").forGetter(ExtractinatorRecipe::input), (App)Drop.CODEC.listOf().fieldOf("drops").forGetter(ExtractinatorRecipe::outputs)).apply((Applicative)instance, ExtractinatorRecipe::new));
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.EXTRACTINATOR_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.EXTRACTINATOR_RECIPE.get();
    }

    public List<Ingredient> getOutputs() {
        return this.outputs().stream().map(d -> d.drops.m_203614_().map(Holder::m_203334_).map(i -> new ItemStack((ItemLike)i, d.maxDropCount())).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).toList()).flatMap(Collection::stream).toList();
    }

    public record Drop(HolderSet<Item> drops, double dropChance, int minDropCount, int maxDropCount) {
        public static final Codec<Drop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HolderSetCodec.of((Registry)BuiltInRegistries.f_257033_).fieldOf("drop").forGetter(Drop::drops), (App)Codec.DOUBLE.fieldOf("drop_chance").orElse((Object)1.0).forGetter(Drop::dropChance), (App)Codec.INT.fieldOf("min_drop_count").orElse((Object)1).forGetter(Drop::minDropCount), (App)Codec.INT.fieldOf("max_drop_count").orElse((Object)1).forGetter(Drop::maxDropCount)).apply((Applicative)instance, Drop::new));
    }
}

