/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block;

import com.ferreusveritas.dynamictrees.block.GrowableBlock;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class FruitBlock
extends Block
implements BonemealableBlock,
GrowableBlock {
    protected final Fruit fruit;

    public FruitBlock(BlockBehaviour.Properties properties, Fruit fruit) {
        super(properties);
        this.fruit = fruit;
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.f_49792_ = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.fruit != null) {
            builder.m_61104_(new Property[]{this.fruit.getAgeProperty()});
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.fruit.getBlockShape(this.getAge(state));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.doTick(state, (Level)level, pos, random);
    }

    public void doTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop(level, pos, state);
            return;
        }
        int age = this.getAge(state);
        Float season = SeasonHelper.getSeasonValue(LevelContext.create((LevelAccessor)level), pos);
        if (season != null) {
            if (this.fruit.isOutOfSeason(level, pos)) {
                this.outOfSeason(level, pos);
                return;
            }
            if (age == 0 && this.fruit.isInFlowerHoldPeriod((LevelAccessor)level, pos, season)) {
                return;
            }
        }
        if (age < this.fruit.getMaxAge()) {
            this.tryGrow(state, level, pos, random, age, season);
        } else {
            this.tickMature(level, pos, state);
        }
    }

    private void outOfSeason(Level level, BlockPos pos) {
        level.m_46961_(pos, false);
    }

    private void tryGrow(BlockState state, Level level, BlockPos pos, RandomSource random, int age, @Nullable Float season) {
        boolean doGrow = random.m_188501_() < this.getGrowthChance(level, pos);
        boolean eventGrow = ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)doGrow);
        if (season != null ? doGrow || eventGrow : eventGrow) {
            this.setAge(level, pos, state, age + 1);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private float getGrowthChance(Level level, BlockPos pos) {
        return this.fruit.getGrowthChance();
    }

    public void tickMature(Level level, BlockPos pos, BlockState state) {
        this.fruit.performMatureAction(new GrowableBlock.Info((LevelAccessor)level, pos, state));
    }

    @Override
    public void performMatureAction(LevelAccessor level, BlockPos pos, BlockState state) {
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop(level, pos, state);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.isSupported(level, pos, state);
    }

    @Override
    public boolean isSupported(LevelReader level, BlockPos pos, BlockState state) {
        return level.m_8055_(pos.m_7494_()).m_60734_() instanceof LeavesBlock;
    }

    protected void drop(Level level, BlockPos pos, BlockState state) {
        level.m_46961_(pos, true);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ResourceLocation resourcelocation = this.m_60589_();
        if (resourcelocation == BuiltInLootTables.f_78712_) {
            return Collections.emptyList();
        }
        LootParams lootParams = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81421_);
        LootTable table = lootParams.m_287182_().m_7654_().m_278653_().m_278676_(resourcelocation);
        if (table == LootTable.f_79105_ && state.m_61138_((Property)this.fruit.getAgeProperty()) && ((Integer)state.m_61143_((Property)this.fruit.getAgeProperty())).intValue() == this.fruit.getMaxAge()) {
            return Collections.singletonList(this.fruit.getItemStack());
        }
        return table.m_287195_(lootParams);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return this.fruit.getItemStack();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.getAge(state) >= this.fruit.getMaxAge()) {
            this.drop(level, pos, state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.fruit.canBoneMeal() && this.getAge(state) < this.fruit.getMaxAge();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        int newAge = Math.min(age + 1, this.fruit.getMaxAge());
        if (newAge != age) {
            this.setAge((Level)level, pos, state, newAge);
        }
    }

    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.fruit.getAgeProperty());
    }

    public float getAgeAsPercentage(BlockState state) {
        return (float)this.getAge(state) * 100.0f / (float)this.getMaxAge();
    }

    public int getMaxAge() {
        return this.fruit.getMaxAge();
    }

    private void setAge(Level level, BlockPos pos, BlockState state, int newAge) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.fruit.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 2);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

