/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.block.entity.PottedSaplingBlockEntity;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import com.ferreusveritas.dynamictrees.util.Null;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PottedSaplingBlock
extends BaseEntityBlock {
    public static final ResourceLocation REG_NAME = DynamicTrees.location("potted_sapling");
    protected static final AABB FLOWER_POT_AABB = new AABB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public PottedSaplingBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY));
    }

    public Species getSpecies(BlockGetter level, BlockPos pos) {
        return Null.applyIfNonnull(this.getTileEntityPottedSapling(level, pos), PottedSaplingBlockEntity::getSpecies, Species.NULL_SPECIES);
    }

    public boolean setSpecies(Level level, BlockPos pos, BlockState state, Species species) {
        return Null.consumeIfNonnull(this.getTileEntityPottedSapling((BlockGetter)level, pos), pottedSaplingBlockEntity -> pottedSaplingBlockEntity.setSpecies(species));
    }

    public BlockState getPotState(Level level, BlockPos pos) {
        return Null.applyIfNonnull(this.getTileEntityPottedSapling((BlockGetter)level, pos), PottedSaplingBlockEntity::getPot, Blocks.f_50276_.m_49966_());
    }

    public boolean setPotState(Level level, BlockState potState, BlockPos pos) {
        return Null.consumeIfNonnull(this.getTileEntityPottedSapling((BlockGetter)level, pos), pottedSaplingBlockEntity -> pottedSaplingBlockEntity.setPot(potState));
    }

    @javax.annotation.Nullable
    private PottedSaplingBlockEntity getTileEntityPottedSapling(BlockGetter level, BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        return tileEntity instanceof PottedSaplingBlockEntity ? (PottedSaplingBlockEntity)tileEntity : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PottedSaplingBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        Species species = this.getSpecies((BlockGetter)level, pos);
        if (!species.isValid()) {
            return InteractionResult.FAIL;
        }
        ItemStack seedStack = species.getSeedStack(1);
        if (heldItem.m_41720_() == seedStack.m_41720_() || hand == InteractionHand.OFF_HAND && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == seedStack.m_41720_()) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_41619_()) {
            player.m_21008_(hand, seedStack);
        } else if (!player.m_36356_(seedStack)) {
            player.m_36176_(seedStack, false);
        }
        level.m_7731_(pos, this.getPotState(level, pos), 3);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Species species;
        if (target.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)target).m_82434_() == Direction.UP && (species = this.getSpecies(level, pos)).isValid()) {
            return species.getSeedStack(1);
        }
        BlockState potState = Null.applyIfNonnull(this.getTileEntityPottedSapling(level, pos), PottedSaplingBlockEntity::getPot, BlockStates.AIR);
        if (potState.m_60734_() == Blocks.f_50276_) {
            return new ItemStack((ItemLike)Items.f_42618_);
        }
        if (potState.m_60734_() instanceof FlowerPotBlock) {
            return new ItemStack((ItemLike)potState.m_60734_(), 1);
        }
        return new ItemStack((ItemLike)Items.f_42618_);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP)) {
            this.spawnDrops(level, pos);
            level.m_46597_(pos, BlockStates.AIR);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            return true;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(level, player, pos, state, te, stack);
        this.spawnDrops(level, pos);
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public void spawnDrops(Level level, BlockPos pos) {
        ItemUtils.spawnItemStack(level, pos, new ItemStack((ItemLike)Blocks.f_50276_), false);
        if (this.getSpecies((BlockGetter)level, pos) != Species.NULL_SPECIES) {
            ItemUtils.spawnItemStack(level, pos, this.getSpecies((BlockGetter)level, pos).getSeedStack(1), false);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)FLOWER_POT_AABB);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

