/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.rooty;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.data.AerialRootsSoilGenerator;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.BlockWithDynamicHardness;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.RootIntegrityNode;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.EntityUtils;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;

public class AerialRootsSoilProperties
extends SoilProperties {
    public static final TypedRegistry.EntryType<SoilProperties> TYPE = TypedRegistry.newType(AerialRootsSoilProperties::new);
    protected MangroveFamily family;

    public AerialRootsSoilProperties(ResourceLocation registryName) {
        super(registryName);
        this.soilStateGenerator.reset(AerialRootsSoilGenerator::new);
    }

    public void setFamily(MangroveFamily family) {
        this.family = family;
    }

    public MangroveFamily getFamily() {
        return this.family;
    }

    @Override
    protected RootyBlock createBlock(BlockBehaviour.Properties blockProperties) {
        return new RootRootyBlock(this, blockProperties);
    }

    @Override
    public BlockState getSoilState(BlockState primitiveSoilState, int fertility, boolean requireTileEntity) {
        BlockState rootyState = super.getSoilState(primitiveSoilState, fertility, requireTileEntity);
        if (rootyState.m_60734_() instanceof RootRootyBlock) {
            return (BlockState)rootyState.m_61124_((Property)RootRootyBlock.WATERLOGGED, (Comparable)Boolean.valueOf(primitiveSoilState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)));
        }
        return rootyState;
    }

    @Override
    public List<TagKey<Block>> defaultSoilBlockTags() {
        LinkedList<TagKey<Block>> defaultTags = new LinkedList<TagKey<Block>>(super.defaultSoilBlockTags());
        defaultTags.add(DTBlockTags.AERIAL_ROOTS_ROOTY_SOIL);
        return defaultTags;
    }

    public static class RootRootyBlock
    extends RootyBlock
    implements SimpleWaterloggedBlock {
        protected static final IntegerProperty RADIUS = IntegerProperty.m_61631_((String)"radius", (int)1, (int)8);
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

        public RootRootyBlock(SoilProperties properties, BlockBehaviour.Properties blockProperties) {
            super(properties, blockProperties);
            this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(8))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{RADIUS, WATERLOGGED}));
        }

        public FluidState m_5888_(BlockState state) {
            return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
        }

        public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
            return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        }

        @Override
        public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
            BlockState up = level.m_8055_(pos.m_7494_());
            float hardness = 2.0f;
            Block block = up.m_60734_();
            if (block instanceof BlockWithDynamicHardness) {
                BlockWithDynamicHardness upBlock = (BlockWithDynamicHardness)block;
                hardness = upBlock.getHardness(up, level, pos.m_7494_());
            }
            return (float)((double)hardness * (Double)DTConfigs.ROOTY_BLOCK_HARDNESS_MULTIPLIER.get());
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            int radius = (Integer)state.m_61143_((Property)RADIUS);
            return Block.m_49796_((double)(8 - radius), (double)0.0, (double)(8 - radius), (double)(radius + 8), (double)16.0, (double)(radius + 8));
        }

        @Override
        public int getRadius(BlockState state) {
            return (Integer)state.m_61143_((Property)RADIUS);
        }

        public boolean isStructurallyStable(LevelAccessor level, BlockPos rootPos) {
            BlockPos belowPos = rootPos.m_7495_();
            RootIntegrityNode node = new RootIntegrityNode();
            BlockState belowState = level.m_8055_(belowPos);
            TreeHelper.getTreePart(belowState).analyse(belowState, level, belowPos, null, new MapSignal(node));
            return !node.getStable().isEmpty();
        }

        public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
            this.updateRadius((LevelAccessor)pLevel, pState, pPos, 3, false);
            super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        }

        @Override
        public void destroyTree(Level level, BlockPos rootPos, @Nullable Player player) {
            BranchDestructionData destroyData;
            Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.m_8055_(rootPos.m_7494_()));
            Optional<BranchBlock> root = TreeHelper.getBranchOpt(level.m_8055_(rootPos.m_7495_()));
            if (branch.isPresent()) {
                destroyData = branch.get().destroyBranchFromNode(level, rootPos.m_7494_(), Direction.DOWN, true, null);
                FallingTreeEntity.dropTree(level, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
            }
            if (root.isPresent()) {
                destroyData = root.get().destroyBranchFromNode(level, rootPos.m_7495_(), Direction.UP, true, null);
                FallingTreeEntity.dropTree(level, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
            }
        }

        @Override
        public boolean fallWithTree(BlockState state, Level level, BlockPos pos, boolean hasRoots) {
            if (hasRoots) {
                level.m_46597_(pos, this.getDecayBlockState(state, (BlockGetter)level, pos));
                return true;
            }
            return false;
        }

        @Override
        public BlockState getDecayBlockState(BlockState state, BlockGetter level, BlockPos pos) {
            if (state.m_61138_((Property)WATERLOGGED)) {
                return this.m_5888_(state).m_76188_();
            }
            return super.getDecayBlockState(state, level, pos);
        }

        @Override
        public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
            if (!level.f_46443_) {
                this.dropWholeTree(level, pos, player);
            }
            return false;
        }

        public void dropWholeTree(Level level, BlockPos rootPos, @Nullable Player player) {
            Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.m_8055_(rootPos.m_7494_()));
            Optional<BranchBlock> root = TreeHelper.getBranchOpt(level.m_8055_(rootPos.m_7495_()));
            BranchDestructionData destroyData = null;
            Optional<Direction> toolDir = Optional.empty();
            if (player != null) {
                double reachDistance = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())).m_22135_();
                BlockHitResult ragTraceResult = EntityUtils.playerRayTrace((LivingEntity)player, reachDistance, 1.0f);
                toolDir = Optional.of(ragTraceResult != null ? (player.m_6144_() ? ragTraceResult.m_82434_().m_122424_() : ragTraceResult.m_82434_()) : Direction.DOWN);
            }
            if (branch.isPresent()) {
                destroyData = branch.get().destroyBranchFromNode(level, rootPos.m_7494_(), toolDir.orElse(Direction.DOWN), false, (LivingEntity)player);
            }
            if (root.isPresent()) {
                BranchDestructionData rootDestroyData = root.get().destroyBranchFromNode(level, rootPos.m_7495_(), toolDir.orElse(Direction.UP), false, (LivingEntity)player);
                if (destroyData == null) {
                    destroyData = rootDestroyData;
                } else {
                    System.out.println(destroyData.getNumBranches() + " " + rootDestroyData.getNumBranches());
                    destroyData = destroyData.merge(rootDestroyData);
                }
            }
            if (destroyData != null) {
                ItemStack heldItem = player == null ? ItemStack.f_41583_ : player.m_21205_();
                int fortune = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)heldItem);
                float fortuneFactor = 1.0f + 0.25f * (float)fortune;
                NetVolumeNode.Volume woodVolume = destroyData.woodVolume;
                woodVolume.multiplyVolume(fortuneFactor);
                List<ItemStack> woodItems = destroyData.species.getBranchesDrops(level, woodVolume, heldItem);
                FallingTreeEntity.dropTree(level, destroyData, woodItems, FallingTreeEntity.DestroyType.HARVEST);
                if (player != null) {
                    ItemUtils.damageAxe((LivingEntity)player, heldItem, this.getRadius(level.m_8055_(rootPos)), woodVolume, true);
                }
            }
        }

        @Override
        public int updateRadius(LevelAccessor level, BlockState state, BlockPos pos, int flags, boolean force) {
            if (!(state.m_60734_() instanceof RootRootyBlock)) {
                return 8;
            }
            int upRad = TreeHelper.getRadius((BlockGetter)level, pos.m_7494_());
            if (upRad > 0) {
                int thisRad = (Integer)state.m_61143_((Property)RADIUS);
                if (upRad != thisRad || force) {
                    int newRadius = Math.min(upRad, 8);
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(newRadius)), flags);
                    return newRadius;
                }
                return upRad;
            }
            return 0;
        }
    }
}

