/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.systems.nodemapper.TransformNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public final class TransformCommand
extends SubCommand {
    private static final Dynamic2CommandExceptionType SPECIES_EQUAL = new Dynamic2CommandExceptionType((toSpecies, fromSpecies) -> Component.m_237110_((String)"commands.dynamictrees.error.species_equal", (Object[])new Object[]{TransformCommand.darkRed(toSpecies), TransformCommand.darkRed(fromSpecies)}));

    @Override
    protected String getName() {
        return "transform";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return TransformCommand.blockPosArgument().then(TransformCommand.transformableSpeciesArgument().executes(context -> TransformCommand.executesSuccess(() -> this.transformSpecies((CommandSourceStack)context.getSource(), TransformCommand.rootPosArgument((CommandContext<CommandSourceStack>)context), TransformCommand.speciesArgument((CommandContext<CommandSourceStack>)context)))));
    }

    private void transformSpecies(CommandSourceStack source, BlockPos rootPos, Species toSpecies) throws CommandSyntaxException {
        ServerLevel level = source.m_81372_();
        Species fromSpecies = TreeHelper.getExactSpecies((Level)level, rootPos);
        if (toSpecies == fromSpecies) {
            throw SPECIES_EQUAL.create((Object)toSpecies.getTextComponent(), (Object)fromSpecies.getTextComponent());
        }
        if (!toSpecies.isTransformable() || !fromSpecies.isTransformable()) {
            throw SPECIES_NOT_TRANSFORMABLE.create((Object)(!toSpecies.isTransformable() ? toSpecies.getTextComponent() : fromSpecies.getTextComponent()));
        }
        BlockState rootyState = level.m_8055_(rootPos);
        RootyBlock rootyBlock = (RootyBlock)rootyState.m_60734_();
        rootyBlock.startAnalysis((LevelAccessor)level, rootPos, new MapSignal(new TransformNode(fromSpecies, toSpecies)));
        if (rootyBlock.getSpecies(rootyState, (LevelAccessor)level, rootPos) != toSpecies) {
            toSpecies.placeRootyDirtBlock((LevelAccessor)level, rootPos, rootyBlock.getFertility(rootyState, (BlockGetter)level, rootPos));
        }
        TransformCommand.sendSuccessAndLog(source, (Component)Component.m_237110_((String)"commands.dynamictrees.success.transform", (Object[])new Object[]{fromSpecies.getTextComponent(), CommandHelper.posComponent((Vec3i)rootPos, ChatFormatting.AQUA), toSpecies.getTextComponent()}));
        WailaOther.invalidateWailaPosition();
    }
}

