/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.api.configuration.Configurable;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurableRegistryEntry;
import com.ferreusveritas.dynamictrees.api.configuration.Configuration;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationTemplate;
import com.ferreusveritas.dynamictrees.api.configuration.Properties;
import com.ferreusveritas.dynamictrees.api.configuration.TemplateRegistry;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public final class ConfiguredDeserialiser<T extends Configuration<T, C>, C extends Configurable>
implements JsonDeserialiser<T> {
    private final String configurableName;
    private final Class<C> configurableClass;
    private final TemplateRegistry<T> templates;

    public ConfiguredDeserialiser(String configurableName, Class<C> configurableClass, TemplateRegistry<T> templates) {
        this.configurableName = configurableName;
        this.configurableClass = configurableClass;
        this.templates = templates;
    }

    @Override
    public Result<T, JsonElement> deserialise(JsonElement jsonElement) {
        return JsonResult.forInput(jsonElement).mapIfType(String.class, (name, warningConsumer) -> {
            ConfigurationTemplate<T> template = this.getTemplate(ResourceLocationUtils.parse(name, "dynamictrees"));
            return (Configuration)template.apply(Properties.NONE).orElseThrow();
        }).elseMapIfType(this.configurableClass, configurable -> configurable.getDefaultConfiguration()).elseMapIfType(JsonObject.class, (object, warningConsumer) -> {
            ConfigurationTemplate<T> template = this.getTemplate(this.getTemplateName((JsonObject)object));
            JsonObject propertiesJson = JsonHelper.getOrDefault(object, "properties", JsonObject.class, new JsonObject());
            Properties properties = new Properties();
            StreamSupport.stream(template.getRegisteredProperties().spliterator(), false).forEach(property -> this.addProperty(properties, (ConfigurationProperty)property, propertiesJson, (Consumer<String>)warningConsumer));
            return (Configuration)template.apply(properties).orElseThrow();
        }).elseError(this::isConfigurationValid, this.configurableName + " couldn't be found from input \"{}\".");
    }

    private boolean isConfigurationValid(@Nullable T config) {
        return config != null && ((Configuration)config).getConfigurable() instanceof ConfigurableRegistryEntry && ((ConfigurableRegistryEntry)((Configuration)config).getConfigurable()).isValid();
    }

    private ConfigurationTemplate<T> getTemplate(ResourceLocation templateName) throws DeserialisationException {
        return this.templates.get(templateName).orElseThrow(() -> new DeserialisationException("No such template \"" + templateName + "\" for \"" + this.configurableName + "\"."));
    }

    private ResourceLocation getTemplateName(JsonObject json) throws DeserialisationException {
        return JsonHelper.getAsOptional(json, "name", JsonDeserialisers.DT_RESOURCE_LOCATION).orElseThrow(() -> new DeserialisationException("Configurable must state name of template to use."));
    }

    private <V> void addProperty(Properties properties, ConfigurationProperty<V> property, JsonObject propertiesJson, Consumer<String> warningConsumer) {
        property.deserialise(propertiesJson).map(result -> result.ifSuccessOrElse(value -> properties.put(property, value), warningConsumer, warningConsumer));
    }
}

