/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.item;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.RootsJoCode;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Staff
extends Item {
    public static final String HANDLE = "handle";
    public static final String COLOR = "color";
    public static final String READ_ONLY = "read_only";
    public static final String TREE = "tree";
    public static final String CODE = "code";
    public static final String ROOTS_CODE = "roots_code";
    public static final String USES = "uses";
    public static final String MAX_USES = "max_uses";
    public static final float REACH_DISTANCE = 256.0f;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public Staff() {
        super(new Item.Properties().m_41487_(1));
        DTRegistries.CREATIVE_TAB_ITEMS.add(this);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60734_() instanceof BranchBlock || state.m_60734_() instanceof TrunkShellBlock) {
            return 64.0f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.m_60734_() instanceof BranchBlock || state.m_60734_() instanceof TrunkShellBlock) {
            if (this.decUses(stack)) {
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.m_5776_() || !pPlayer.m_7500_()) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        ItemStack handItem = pPlayer.m_21120_(pUsedHand).m_41777_();
        HitResult hitResult = pPlayer.m_19907_(256.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK && this.m_6225_(new UseOnContext(pPlayer, pUsedHand, (BlockHitResult)hitResult)) == InteractionResult.SUCCESS) {
            return InteractionResultHolder.m_19090_((Object)handItem);
        }
        return InteractionResultHolder.m_19098_((Object)handItem);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Species species;
        Level level = context.m_43725_();
        ItemStack heldStack = context.m_43723_().m_21120_(context.m_43724_());
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (state.m_247087_() || state.m_204336_(DTBlockTags.FOLIAGE)) {
            pos = pos.m_7495_();
            state = level.m_8055_(pos);
        }
        BlockPos rootPos = TreeHelper.findRootNode(level, pos);
        TreePart treePart = TreeHelper.getTreePart(level.m_8055_(rootPos));
        if (!this.isReadOnly(heldStack) && treePart.isRootNode() && (species = TreeHelper.getExactSpecies(level, rootPos)).isValid()) {
            if (!context.m_43723_().m_6144_()) {
                String code = new JoCode(level, rootPos, context.m_43723_().m_6350_()).toString();
                this.setCode(heldStack, code);
                String rootCode = new RootsJoCode(level, rootPos, context.m_43723_().m_6350_()).toString();
                this.setRootsCode(heldStack, rootCode);
                if (level.f_46443_) {
                    Minecraft.m_91087_().f_91068_.m_90911_(code);
                }
            }
            this.setSpecies(heldStack, species);
            return InteractionResult.SUCCESS;
        }
        species = this.getSpecies(heldStack);
        if (species.isValid() && species.isAcceptableSoil((LevelReader)level, pos, state)) {
            GenerationContext generationContext = new GenerationContext(LevelContext.create((LevelAccessor)level), species, pos, pos.m_122032_(), (Holder<Biome>)level.m_204166_(pos), context.m_43723_().m_6350_(), 8, SafeChunkBounds.ANY);
            species.getJoCode(this.getCode(heldStack)).setCareful(true).generate(generationContext);
            String rootsCode = this.getRootsCode(heldStack);
            if (!rootsCode.isEmpty()) {
                species.getRootsJoCode(rootsCode).setCareful(true).generate(generationContext);
            }
            if (this.hasMaxUses(heldStack)) {
                if (this.decUses(heldStack)) {
                    heldStack.m_41774_(1);
                }
            } else {
                heldStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.hasMaxUses(pStack);
    }

    public int m_142158_(ItemStack stack) {
        int damage = this.getUses(stack) / this.getMaxUses(stack);
        return 1 - damage;
    }

    public boolean isReadOnly(ItemStack itemStack) {
        return itemStack.m_41784_().m_128471_(READ_ONLY);
    }

    public Staff setReadOnly(ItemStack itemStack, boolean readonly) {
        itemStack.m_41784_().m_128379_(READ_ONLY, readonly);
        return this;
    }

    public Staff setSpecies(ItemStack itemStack, Species species) {
        String name = species == Species.NULL_SPECIES ? "null" : species.getRegistryName().toString();
        itemStack.m_41784_().m_128359_(TREE, name);
        return this;
    }

    public Staff setCode(ItemStack itemStack, String code) {
        itemStack.m_41784_().m_128359_(CODE, code);
        return this;
    }

    public Staff setRootsCode(ItemStack itemStack, String code) {
        itemStack.m_41784_().m_128359_(ROOTS_CODE, code);
        return this;
    }

    public Species getSpecies(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128441_(TREE)) {
            return TreeRegistry.findSpecies(nbt.m_128461_(TREE));
        }
        Species species = TreeRegistry.findSpeciesSloppy("oak");
        this.setSpecies(itemStack, species);
        return species;
    }

    public int getUses(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128441_(USES)) {
            return nbt.m_128451_(USES);
        }
        int uses = this.getMaxUses(itemStack);
        this.setUses(itemStack, uses);
        return uses;
    }

    public Staff setUses(ItemStack itemStack, int value) {
        itemStack.m_41784_().m_128405_(USES, value);
        return this;
    }

    public int getMaxUses(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128441_(MAX_USES)) {
            return nbt.m_128451_(MAX_USES);
        }
        return 0;
    }

    public Staff setMaxUses(ItemStack itemStack, int value) {
        itemStack.m_41784_().m_128405_(MAX_USES, value);
        return this;
    }

    public boolean hasMaxUses(ItemStack itemStack) {
        return itemStack.m_41784_().m_128441_(MAX_USES);
    }

    public boolean decUses(ItemStack itemStack) {
        int uses = Math.max(0, this.getUses(itemStack) - 1);
        this.setUses(itemStack, uses);
        return uses == 0;
    }

    public int getColor(ItemStack itemStack, int tint) {
        CompoundTag tag = itemStack.m_41784_();
        if (tint == 0) {
            int color = 5981999;
            Species species = this.getSpecies(itemStack);
            if (tag.m_128441_(HANDLE)) {
                try {
                    color = Color.decode(tag.m_128461_(HANDLE)).getRGB();
                }
                catch (NumberFormatException e) {
                    tag.m_128473_(HANDLE);
                }
            } else if (species.isValid()) {
                color = species.getFamily().woodBarkColor;
            }
            return color;
        }
        if (tint == 1) {
            int color = 65535;
            if (tag.m_128441_(COLOR)) {
                if (tag.m_128435_(COLOR) == 8) {
                    this.tryConvertLegacyTag(tag);
                }
                color = tag.m_128451_(COLOR);
            }
            return color;
        }
        return -1;
    }

    @Deprecated
    private void tryConvertLegacyTag(CompoundTag tag) {
        String color = tag.m_128461_(COLOR);
        tag.m_128473_(COLOR);
        try {
            tag.m_128405_(COLOR, Color.decode(color).getRGB());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Staff setColor(ItemStack itemStack, int color) {
        itemStack.m_41784_().m_128405_(COLOR, color);
        return this;
    }

    public String getCode(ItemStack itemStack) {
        String code = "P";
        if (itemStack.m_41784_().m_128441_(CODE)) {
            code = itemStack.m_41783_().m_128461_(CODE);
        } else {
            itemStack.m_41783_().m_128359_(CODE, code);
        }
        return code;
    }

    public String getRootsCode(ItemStack itemStack) {
        if (itemStack.m_41784_().m_128441_(ROOTS_CODE)) {
            return itemStack.m_41783_().m_128461_(ROOTS_CODE);
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.dynamictrees.species", (Object[])new Object[]{this.getSpecies(stack).getTextComponent()}));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.dynamictrees.jo_code", (Object[])new Object[]{new JoCode(this.getCode(stack)).getTextComponent()}));
        String rootsCode = this.getRootsCode(stack);
        if (!rootsCode.isEmpty()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.dynamictrees.roots_jo_code", (Object[])new Object[]{new RootsJoCode(rootsCode).getTextComponent()}));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }
}

