/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.family;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.data.BranchItemModelGenerator;
import com.ferreusveritas.dynamictrees.api.data.BranchStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.FamilyLangGenerator;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.StrippedBranchStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.SurfaceRootStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.block.branch.ThickBranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.cell.MetadataCell;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.DTItemTags;
import com.ferreusveritas.dynamictrees.data.provider.BranchLoaderBuilder;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entity.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.tree.Resettable;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class Family
extends RegistryEntry<Family>
implements Resettable<Family> {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(Family::new);
    public static final Family NULL_FAMILY = new Family(){

        @Override
        public void setupCommonSpecies(Species species) {
        }

        @Override
        public Species getCommonSpecies() {
            return Species.NULL_SPECIES;
        }

        @Override
        public boolean onTreeActivated(TreeActivationContext context) {
            return false;
        }

        @Override
        public ItemStack getStick(int qty) {
            return ItemStack.f_41583_;
        }

        @Override
        public BranchBlock getValidBranchBlock(int index) {
            return null;
        }

        @Override
        public Species getSpeciesForLocation(LevelAccessor level, BlockPos trunkPos) {
            return Species.NULL_SPECIES;
        }
    };
    public static final TypedRegistry<Family> REGISTRY = new TypedRegistry<Family>(Family.class, NULL_FAMILY, TYPE);
    protected Species commonSpecies;
    protected LeavesProperties commonLeaves = LeavesProperties.NULL;
    private Supplier<BranchBlock> branch;
    private Supplier<BranchBlock> strippedBranch;
    protected boolean hasStrippedBranch = true;
    protected Integer minRadiusForStripping = null;
    protected boolean reduceRadiusWhenStripping = true;
    private Supplier<Item> branchItem;
    private Supplier<SurfaceRootBlock> surfaceRoot;
    protected boolean hasSurfaceRoot = false;
    private Block primitiveLog = Blocks.f_50016_;
    private Block primitiveStrippedLog = Blocks.f_50016_;
    private final List<BranchBlock> validBranches = new LinkedList<BranchBlock>();
    private int maxBranchRadius = 8;
    private Item stick = Items.f_42398_;
    protected float lootVolumeMultiplier = 1.0f;
    @OnlyIn(value=Dist.CLIENT)
    public int woodRingColor;
    @OnlyIn(value=Dist.CLIENT)
    public int woodBarkColor;
    private final Set<Species> species = new HashSet<Species>();
    private boolean isFireProof = false;
    private BlockBehaviour.Properties properties;
    private int primaryThickness = 1;
    private int secondaryThickness = 2;
    private boolean branchIsLadder = true;
    private int maxSignalDepth = 32;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> branchStateGenerator = MutableLazyValue.supplied(BranchStateGenerator::new);
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> strippedBranchStateGenerator = MutableLazyValue.supplied(StrippedBranchStateGenerator::new);
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> surfaceRootStateGenerator = MutableLazyValue.supplied(SurfaceRootStateGenerator::new);
    protected final MutableLazyValue<Generator<DTItemModelProvider, Family>> branchItemModelGenerator = MutableLazyValue.supplied(BranchItemModelGenerator::new);
    protected final MutableLazyValue<Generator<DTLangProvider, Family>> familyLangGenerator = MutableLazyValue.supplied(FamilyLangGenerator::new);
    protected List<String> onlyIfLoaded = new ArrayList<String>();
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    protected HashMap<String, String> langOverrides = new HashMap();
    public static final String BRANCH = "branch";
    public static final String BRANCH_TOP = "branch_top";
    public static final String STRIPPED_BRANCH = "stripped_branch";
    public static final String STRIPPED_BRANCH_TOP = "stripped_branch_top";
    public static final String ROOTS_SIDE = "roots_side";
    public static final String ROOTS_TOP = "roots_top";
    public static final String COVERED_ROOTS_BLOCK = "covered_roots_block";

    private Family() {
        this.setRegistryName(DTTrees.NULL);
    }

    public Family(ResourceLocation name) {
        this.setRegistryName(name);
        this.commonSpecies = Species.NULL_SPECIES;
    }

    public void setupBlocks() {
        this.setBranch(this.createBranch(this.getBranchName()));
        this.setBranchItem(this.createBranchItem(this.getBranchName(), this.branch));
        if (this.hasStrippedBranch()) {
            this.setStrippedBranch(this.createBranch(this.getBranchName("stripped_")));
        }
        if (this.hasSurfaceRoot()) {
            this.setSurfaceRoot(this.createSurfaceRoot());
        }
    }

    public void setCommonSpecies(Species species) {
        this.commonSpecies = species;
    }

    public void setupCommonSpecies(Species species) {
        this.commonSpecies = species.setShouldGenerateSeedIfNull(true).setShouldGenerateSaplingIfNull(true).generateSeed().generateSapling();
    }

    public Species getCommonSpecies() {
        return this.commonSpecies;
    }

    public Family addSpecies(Species species) {
        this.species.add(species);
        return this;
    }

    public Set<Species> getSpecies() {
        return this.species;
    }

    public Species getSpeciesForLocation(LevelAccessor level, BlockPos trunkPos) {
        return this.getSpeciesForLocation((BlockGetter)level, trunkPos, this.commonSpecies);
    }

    public Species getSpeciesForLocation(BlockGetter level, BlockPos trunkPos, Species defaultSpecies) {
        for (Species species : this.species) {
            if (!species.shouldOverrideCommon(level, trunkPos)) continue;
            return species;
        }
        return defaultSpecies;
    }

    public boolean onTreeActivated(TreeActivationContext context) {
        if (this.canStripBranch(context.hitState, context.level, context.hitPos, context.player, context.heldItem)) {
            return this.stripBranch(context.hitState, context.level, context.hitPos, context.player, context.heldItem);
        }
        if (context.rootPos != BlockPos.f_121853_) {
            return TreeHelper.getExactSpecies(context.level, context.hitPos).onTreeActivated(context);
        }
        return false;
    }

    public boolean canStripBranch(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        BranchBlock branchBlock = TreeHelper.getBranch(state);
        if (branchBlock == null) {
            return false;
        }
        return branchBlock.canBeStripped(state, level, pos, player, heldItem);
    }

    public boolean stripBranch(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        if (this.hasStrippedBranch()) {
            this.getBranch().ifPresent(branch -> {
                branch.stripBranch(state, level, pos, player, heldItem);
                if (level.f_46443_) {
                    level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    WailaOther.invalidateWailaPosition();
                }
            });
            return this.getBranch().isPresent();
        }
        return false;
    }

    public boolean isWood() {
        return true;
    }

    protected ResourceLocation getBranchName() {
        return this.getBranchName("");
    }

    protected ResourceLocation getBranchName(String prefix) {
        return ResourceLocationUtils.prefix(this.getRegistryName(), prefix);
    }

    protected String getBranchNameSuffix() {
        return "_branch";
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        BasicBranchBlock branch;
        BasicBranchBlock basicBranchBlock = branch = this.isThick() ? new ThickBranchBlock(name, this.getProperties()) : new BasicBranchBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    protected Supplier<BranchBlock> createBranch(ResourceLocation name) {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(name, this.getBranchNameSuffix()), () -> this.createBranchBlock(name));
    }

    public Supplier<BlockItem> createBranchItem(ResourceLocation registryName, Supplier<BranchBlock> branchSup) {
        return RegistryHandler.addItem(ResourceLocationUtils.suffix(registryName, this.getBranchNameSuffix()), () -> new BlockItem((Block)branchSup.get(), new Item.Properties()));
    }

    protected Family setBranch(Supplier<BranchBlock> branchSup) {
        this.branch = this.setupBranch(branchSup, this.hasStrippedBranch);
        return this;
    }

    protected Family setStrippedBranch(Supplier<BranchBlock> branch) {
        this.strippedBranch = this.setupBranch(branch, false);
        return this;
    }

    protected Supplier<BranchBlock> setupBranch(Supplier<BranchBlock> branchBlockSup, boolean canBeStripped) {
        return () -> {
            BranchBlock branchBlock = (BranchBlock)branchBlockSup.get();
            branchBlock.setFamily(this);
            branchBlock.setCanBeStripped(canBeStripped);
            this.addValidBranches(branchBlock);
            return branchBlock;
        };
    }

    protected <T extends Item> Family setBranchItem(Supplier<T> branchItemSup) {
        this.branchItem = branchItemSup;
        return this;
    }

    public Optional<BranchBlock> getBranch() {
        return Optionals.ofBlock(this.branch);
    }

    public Optional<BranchBlock> getBranchForPlacement(LevelAccessor level, Species species, BlockPos pos) {
        return this.getBranch();
    }

    public Optional<BranchBlock> getBranchForRootsPlacement(LevelAccessor level, Species species, BlockPos pos) {
        return this.getBranch();
    }

    public Optional<BranchBlock> getStrippedBranch() {
        return Optionals.ofBlock(this.strippedBranch);
    }

    public Optional<Item> getBranchItem() {
        return Optionals.ofItem(this.branchItem);
    }

    public boolean isThick() {
        return this.maxBranchRadius > 8;
    }

    public int getMaxBranchRadius() {
        return this.maxBranchRadius;
    }

    public void setMaxBranchRadius(int maxBranchRadius) {
        this.maxBranchRadius = maxBranchRadius;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRootColor(BlockState state, boolean getBark) {
        return getBark ? this.woodBarkColor : this.woodRingColor;
    }

    @Deprecated(forRemoval=true)
    public void setHasConiferVariants(boolean hasConiferVariants) {
    }

    public Family setStick(Item item) {
        this.stick = item;
        return this;
    }

    public ItemStack getStick(int qty) {
        return this.stick == Items.f_41852_ ? ItemStack.f_41583_ : new ItemStack((ItemLike)this.stick, Mth.m_14045_((int)qty, (int)0, (int)64));
    }

    public Family setPrimitiveLog(Block primitiveLog) {
        this.primitiveLog = primitiveLog;
        if (this.branch != null) {
            this.branch.get().setPrimitiveLogDrops(new ItemStack((ItemLike)primitiveLog));
        }
        return this;
    }

    public Family setPrimitiveStrippedLog(Block primitiveStrippedLog) {
        this.primitiveStrippedLog = primitiveStrippedLog;
        if (this.strippedBranch != null) {
            this.strippedBranch.get().setPrimitiveLogDrops(new ItemStack((ItemLike)primitiveStrippedLog));
        }
        return this;
    }

    public Optional<Block> getPrimitiveLog() {
        return Optionals.ofBlock(this.primitiveLog);
    }

    public Optional<Block> getPrimitiveStrippedLog() {
        return Optionals.ofBlock(this.primitiveStrippedLog);
    }

    public List<ItemStack> getLogDropsForBranch(float volume, int branch) {
        BranchBlock branchBlock = this.getValidBranchBlock(branch);
        LinkedList<ItemStack> logs = new LinkedList<ItemStack>();
        if (branchBlock != null) {
            branchBlock.getPrimitiveLogs(volume, logs);
        }
        return logs;
    }

    public boolean isFireProof() {
        return this.isFireProof;
    }

    public void setIsFireProof(boolean isFireProof) {
        this.isFireProof = isFireProof;
    }

    @Deprecated
    public SoundType getBranchSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return null;
    }

    @Nullable
    public Tier getDefaultBranchHarvestTier() {
        return null;
    }

    @Nullable
    public Tier getDefaultStrippedBranchHarvestTier() {
        return null;
    }

    public MapColor getDefaultBranchMapColor() {
        return MapColor.f_283825_;
    }

    public boolean getDefaultFlammable() {
        return true;
    }

    public SoundType getDefaultBranchSoundType() {
        return SoundType.f_56736_;
    }

    public BlockBehaviour.Properties getDefaultBranchProperties(MapColor mapColor) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_60918_(this.getDefaultBranchSoundType()).m_284180_(mapColor).m_222994_().m_60999_();
        if (!this.isFireProof()) {
            properties.m_278183_();
        }
        return properties;
    }

    public BlockBehaviour.Properties getProperties() {
        return this.properties == null ? this.getDefaultBranchProperties(this.getDefaultBranchMapColor()) : this.properties;
    }

    public Family setProperties(BlockBehaviour.Properties properties) {
        this.properties = properties;
        return this;
    }

    public float getLootVolumeMultiplier() {
        return this.lootVolumeMultiplier;
    }

    public void setLootVolumeMultiplier(float lootVolumeMultiplier) {
        this.lootVolumeMultiplier = lootVolumeMultiplier;
    }

    public int getRadiusForCellKit(BlockGetter blockAccess, BlockPos pos, BlockState blockState, Direction dir, BranchBlock branch) {
        int radius = branch.getRadius(blockState);
        int meta = 0;
        if (radius == this.getPrimaryThickness() && blockAccess.m_8055_(pos.m_7495_()).m_60734_() == branch) {
            meta = 1;
        }
        return MetadataCell.radiusAndMeta(radius, meta);
    }

    public void setPrimaryThickness(int primaryThickness) {
        this.primaryThickness = primaryThickness;
    }

    public void setSecondaryThickness(int secondaryThickness) {
        this.secondaryThickness = secondaryThickness;
    }

    public int getPrimaryThickness() {
        return this.primaryThickness;
    }

    public int getPrimaryRootThickness() {
        return this.primaryThickness;
    }

    public int getSecondaryThickness() {
        return this.secondaryThickness;
    }

    public int getSecondaryRootThickness() {
        return this.secondaryThickness;
    }

    public boolean hasStrippedBranch() {
        return this.hasStrippedBranch;
    }

    public void setHasStrippedBranch(boolean hasStrippedBranch) {
        this.hasStrippedBranch = hasStrippedBranch;
    }

    public int getMinRadiusForStripping() {
        if (this.minRadiusForStripping == null) {
            return (Integer)DTConfigs.MIN_RADIUS_FOR_STRIP.get();
        }
        return this.minRadiusForStripping;
    }

    public void setMinRadiusForStripping(int radius) {
        this.minRadiusForStripping = radius;
    }

    public boolean reduceRadiusWhenStripping() {
        if (((Boolean)DTConfigs.ENABLE_STRIP_RADIUS_REDUCTION.get()).booleanValue()) {
            return this.reduceRadiusWhenStripping;
        }
        return false;
    }

    public void setReduceRadiusWhenStripping(boolean reduceRadiusWhenStripping) {
        this.reduceRadiusWhenStripping = reduceRadiusWhenStripping;
    }

    public void addValidBranches(BranchBlock ... branches) {
        this.validBranches.addAll(Arrays.asList(branches));
    }

    public int getBranchBlockIndex(BranchBlock block) {
        int index = this.validBranches.indexOf(block);
        if (index < 0) {
            LogManager.getLogger().warn("Block {} not valid branch for {}.", (Object)block, (Object)this);
            return 0;
        }
        return index;
    }

    @Nullable
    public BranchBlock getValidBranchBlock(int index) {
        if (index < this.validBranches.size()) {
            return this.validBranches.get(index);
        }
        LogManager.getLogger().warn("Attempted to get branch block of index {} but {} only has {} valid branches.", (Object)index, (Object)this, (Object)this.validBranches.size());
        return this.validBranches.get(0);
    }

    public boolean isValidBranchBlock(BranchBlock block) {
        return this.validBranches.contains(block);
    }

    public int getNumberOfValidBranchBlocks() {
        return this.validBranches.size();
    }

    public void setBranchIsLadder(boolean branchIsLadder) {
        this.branchIsLadder = branchIsLadder;
    }

    public boolean branchIsLadder() {
        return this.branchIsLadder;
    }

    public int getMaxSignalDepth() {
        return this.maxSignalDepth;
    }

    public void setMaxSignalDepth(int maxSignalDepth) {
        this.maxSignalDepth = maxSignalDepth;
    }

    public boolean hasSurfaceRoot() {
        return this.hasSurfaceRoot;
    }

    public void setHasSurfaceRoot(boolean hasSurfaceRoot) {
        this.hasSurfaceRoot = hasSurfaceRoot;
    }

    public Supplier<SurfaceRootBlock> createSurfaceRoot() {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(this.getRegistryName(), "_root"), () -> new SurfaceRootBlock(this));
    }

    public Optional<SurfaceRootBlock> getSurfaceRoot() {
        return Optionals.ofBlock(this.surfaceRoot);
    }

    protected Family setSurfaceRoot(Supplier<SurfaceRootBlock> surfaceRootSup) {
        this.surfaceRoot = surfaceRootSup;
        return this;
    }

    public boolean isAcceptableSoilForRootSystem(BlockState soilBlockState) {
        return this.getCommonSpecies().isAcceptableSoil(soilBlockState);
    }

    public AnimationHandler selectAnimationHandler(FallingTreeEntity fallingEntity) {
        return fallingEntity.defaultAnimationHandler();
    }

    public BlockBounds expandLeavesBlockBounds(BlockBounds bounds) {
        return bounds.expand(3);
    }

    public boolean isCompatibleDynamicLeaves(Species species, BlockState blockState, BlockGetter blockAccess, BlockPos pos) {
        DynamicLeavesBlock leaves = TreeHelper.getLeaves(blockState);
        return leaves != null && (this == leaves.getFamily(blockState, blockAccess, pos) || species.isValidLeafBlock(leaves));
    }

    public boolean isCompatibleGenericLeaves(Species species, BlockState blockState, LevelAccessor blockAccess, BlockPos pos) {
        return this.isCompatibleDynamicLeaves(species, blockState, (BlockGetter)blockAccess, pos);
    }

    public LeavesProperties getCommonLeaves() {
        return this.commonLeaves;
    }

    public void setCommonLeaves(LeavesProperties properties) {
        this.commonLeaves = properties;
        properties.setFamily(this);
    }

    public List<TagKey<Block>> defaultBranchTags() {
        return this.isFireProof ? Collections.singletonList(DTBlockTags.BRANCHES) : Collections.singletonList(DTBlockTags.BRANCHES_THAT_BURN);
    }

    public List<TagKey<Item>> defaultBranchItemTags() {
        return this.isFireProof ? Collections.singletonList(DTItemTags.BRANCHES) : Collections.singletonList(DTItemTags.BRANCHES_THAT_BURN);
    }

    public List<TagKey<Block>> defaultStrippedBranchTags() {
        return this.isFireProof ? Collections.singletonList(DTBlockTags.STRIPPED_BRANCHES) : Collections.singletonList(DTBlockTags.STRIPPED_BRANCHES_THAT_BURN);
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getBranch().ifPresent(branch -> {
            this.tierTag(this.getDefaultBranchHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.m_255245_(branch));
            this.defaultBranchTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_255245_(branch);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_176839_(BuiltInRegistries.f_256975_.m_7981_(branch));
                }
            });
        });
        this.getStrippedBranch().ifPresent(strippedBranch -> {
            this.tierTag(this.getDefaultStrippedBranchHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.m_255245_(strippedBranch));
            this.defaultStrippedBranchTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_255245_(strippedBranch);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_176839_(BuiltInRegistries.f_256975_.m_7981_(strippedBranch));
                }
            });
        });
    }

    protected Optional<IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tierTag(@Nullable Tier tier, Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        if (tier == null) {
            return Optional.empty();
        }
        TagKey tag = tier.getTag();
        return tag == null ? Optional.empty() : Optional.of(tagAppender.apply((TagKey<Block>)tag));
    }

    public void addGeneratedItemTags(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tagAppender) {
        this.getBranchItem().ifPresent(item -> {
            if (!this.isOnlyIfLoaded()) {
                this.defaultBranchItemTags().forEach(tag -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).m_255245_(item));
            } else {
                this.defaultBranchItemTags().forEach(tag -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).m_176839_(BuiltInRegistries.f_257033_.m_7981_(item)));
            }
        });
    }

    public BiFunction<BlockModelBuilder, ExistingFileHelper, BranchLoaderBuilder> getBranchLoaderConstructor() {
        return BranchLoaderBuilder::branch;
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.branchStateGenerator.get().generate(provider, this);
        this.strippedBranchStateGenerator.get().generate(provider, this);
        this.surfaceRootStateGenerator.get().generate(provider, this);
    }

    public ResourceLocation getBranchItemParentLocation() {
        return DynamicTrees.location("item/branch");
    }

    public ResourceLocation getRootItemParentLocation() {
        return DynamicTrees.location("item/root_branch");
    }

    public void setOnlyIfLoaded(String onlyIfLoaded) {
        this.onlyIfLoaded.add(onlyIfLoaded);
    }

    public boolean isOnlyIfLoaded() {
        return !this.onlyIfLoaded.isEmpty();
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }

    public void setLangOverrides(Map<String, String> langOverrides) {
        this.langOverrides.putAll(langOverrides);
    }

    public Optional<String> getLangOverride(String key) {
        return Optional.ofNullable(this.langOverrides.getOrDefault(key, null));
    }

    public void addBranchTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation, Block sourceBlock) {
        ResourceLocation bark = primitiveLogLocation;
        ResourceLocation rings = ResourceLocationUtils.suffix(primitiveLogLocation, "_top");
        AtomicBoolean isStripped = new AtomicBoolean(false);
        this.getPrimitiveStrippedLog().ifPresent(l -> isStripped.set(l.equals(sourceBlock)));
        if (isStripped.get()) {
            if (this.textureOverrides.containsKey(STRIPPED_BRANCH)) {
                bark = this.textureOverrides.get(STRIPPED_BRANCH);
            }
            if (this.textureOverrides.containsKey(STRIPPED_BRANCH_TOP)) {
                rings = this.textureOverrides.get(STRIPPED_BRANCH_TOP);
            }
        } else {
            if (this.textureOverrides.containsKey(BRANCH)) {
                bark = this.textureOverrides.get(BRANCH);
            }
            if (this.textureOverrides.containsKey(BRANCH_TOP)) {
                rings = this.textureOverrides.get(BRANCH_TOP);
            }
        }
        textureConsumer.accept("bark", bark);
        textureConsumer.accept("rings", rings);
    }

    public void addRootTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation) {
        ResourceLocation bark = ResourceLocationUtils.suffix(primitiveLogLocation, "_side");
        ResourceLocation rings = ResourceLocationUtils.suffix(primitiveLogLocation, "_top");
        if (this.textureOverrides.containsKey(ROOTS_SIDE)) {
            bark = this.textureOverrides.get(ROOTS_SIDE);
        }
        if (this.textureOverrides.containsKey(ROOTS_TOP)) {
            rings = this.textureOverrides.get(ROOTS_TOP);
        }
        textureConsumer.accept("bark", bark);
        textureConsumer.accept("rings", rings);
    }

    @Override
    public void generateItemModelData(DTItemModelProvider provider) {
        this.branchItemModelGenerator.get().generate(provider, this);
    }

    @Override
    public void generateLangData(DTLangProvider provider) {
        this.familyLangGenerator.get().generate(provider, this);
    }

    @Override
    public String toLoadDataString() {
        return this.getString(Pair.of((Object)"commonLeaves", (Object)this.commonLeaves), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"hasSurfaceRoot", (Object)this.hasSurfaceRoot), Pair.of((Object)"hasStrippedBranch", (Object)this.hasStrippedBranch));
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"commonLeaves", (Object)this.commonLeaves), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"commonSpecies", (Object)this.commonSpecies), Pair.of((Object)"primitiveLog", (Object)this.primitiveLog), Pair.of((Object)"primitiveStrippedLog", (Object)this.primitiveStrippedLog), Pair.of((Object)"stick", (Object)this.stick), Pair.of((Object)"minRadiusForStrip", (Object)this.minRadiusForStripping));
    }

    public static class TreeActivationContext {
        public final Level level;
        public final BlockPos rootPos;
        public final BlockPos hitPos;
        public final BlockState hitState;
        public final Player player;
        public final InteractionHand hand;
        @Nullable
        public final ItemStack heldItem;
        public final BlockHitResult hitResult;

        public TreeActivationContext(Level level, BlockPos rootPos, BlockPos hitPos, BlockState hitState, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hitResult) {
            this.level = level;
            this.rootPos = rootPos;
            this.hitPos = hitPos;
            this.hitState = hitState;
            this.player = player;
            this.hand = hand;
            this.heldItem = heldItem;
            this.hitResult = hitResult;
        }
    }
}

