/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.species;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.mojang.datafixers.util.Function3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class SwampOakSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = SwampOakSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)SwampOakSpecies::new));
    private static final int minRadiusForSunkGeneration = 5;

    public SwampOakSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    @Override
    public boolean generate(GenerationContext context) {
        if (this.isWater(context.level().m_8055_((BlockPos)context.rootPos()))) {
            switch ((DynamicTrees.SwampOakWaterState)((Object)DTConfigs.SWAMP_OAKS_IN_WATER.get())) {
                case SUNK: {
                    if (context.radius() >= 5) {
                        context.rootPos().m_122175_(Direction.DOWN, this.countWaterBlocksBelow(context.level(), (BlockPos)context.rootPos(), this.getAllowedWaterHeightForWorldgen()));
                        break;
                    }
                    return false;
                }
                case DISABLED: {
                    return false;
                }
            }
        }
        return super.generate(context);
    }
}

