/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class ShapeFunctions {
    private static final Map<String, ShapeFunction<?>> SHAPE_FUNCTIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), shapeFunctions -> {
        shapeFunctions.put("fruit", new FruitShapeFunction());
        shapeFunctions.put("pod", new PodShapeFunction());
    });

    public static boolean registerShapeFunction(String functionId, ShapeFunction<?> shapeFunction) {
        return SHAPE_FUNCTIONS.putIfAbsent(functionId, shapeFunction) == null;
    }

    public static DataResult<VoxelShape> calculateShape(String functionId, JsonElement parametersJson) {
        ShapeFunction<?> shapeFunction = SHAPE_FUNCTIONS.get(functionId);
        return shapeFunction != null ? ShapeFunctions.calculateShape(shapeFunction, parametersJson) : DataResult.error(() -> "No shape function with ID \"" + functionId + "\".");
    }

    private static <P> DataResult<VoxelShape> calculateShape(ShapeFunction<P> shapeFunction, JsonElement parametersJson) {
        DataResult<Pair<P, JsonElement>> parametersResult = shapeFunction.getParameters(parametersJson);
        DataResult shapeResult = parametersResult.map(pair -> shapeFunction.calculateShape(pair.getFirst()));
        return shapeResult;
    }

    public static interface ShapeFunction<P> {
        public DataResult<Pair<P, JsonElement>> getParameters(JsonElement var1);

        public VoxelShape calculateShape(P var1);
    }

    public static class FruitShapeFunction
    implements ShapeFunction<Parameters> {
        @Override
        public DataResult<Pair<Parameters, JsonElement>> getParameters(JsonElement json) {
            return Parameters.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        }

        @Override
        public VoxelShape calculateShape(Parameters parameters) {
            float fraction = parameters.fraction;
            float radius = parameters.radius;
            float topHeight = fraction - parameters.stemLength;
            float bottomHeight = topHeight - parameters.height;
            return Shapes.m_83064_((AABB)FruitShapeFunction.createFruitShape(fraction, radius, topHeight, bottomHeight));
        }

        public static AABB createFruitShape(float fraction, float radius, float topHeight, float bottomHeight) {
            return new AABB((double)((fraction / 2.0f - radius) / fraction), (double)(topHeight / fraction), (double)((fraction / 2.0f - radius) / fraction), (double)((fraction / 2.0f + radius) / fraction), (double)(bottomHeight / fraction), (double)((fraction / 2.0f + radius) / fraction));
        }

        public record Parameters(float radius, float height, float stemLength, float fraction) {
            public static final Codec<Parameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("radius").forGetter(Parameters::radius), (App)Codec.FLOAT.fieldOf("height").forGetter(Parameters::height), (App)Codec.FLOAT.fieldOf("stem_length").forGetter(Parameters::stemLength), (App)Codec.FLOAT.optionalFieldOf("fraction", (Object)Float.valueOf(20.0f)).forGetter(Parameters::fraction)).apply((Applicative)instance, Parameters::new));
        }
    }

    public static class PodShapeFunction
    implements ShapeFunction<Parameters> {
        @Override
        public DataResult<Pair<Parameters, JsonElement>> getParameters(JsonElement json) {
            return Parameters.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        }

        @Override
        public VoxelShape calculateShape(Parameters parameters) {
            float fraction = parameters.fraction;
            float radius = parameters.radius;
            float topHeight = fraction - parameters.stemLength;
            float bottomHeight = topHeight - parameters.height;
            float sideOffset = parameters.sideOffset / fraction;
            Direction side = parameters.side;
            return Shapes.m_83064_((AABB)PodShapeFunction.offsetBoundingBox(FruitShapeFunction.createFruitShape(fraction, radius, topHeight, bottomHeight), side, sideOffset));
        }

        public static AABB offsetBoundingBox(AABB box, Direction dir, float offset) {
            return box.m_82386_((double)((float)dir.m_122429_() * offset), (double)((float)dir.m_122430_() * offset), (double)((float)dir.m_122431_() * offset));
        }

        public record Parameters(float radius, float height, float stemLength, float fraction, float sideOffset, Direction side) {
            public static final Codec<Direction> SIDE_CODEC = Codec.STRING.comapFlatMap(side -> DataResult.success((Object)Optional.ofNullable(Direction.m_122402_((String)side)).orElse(Direction.NORTH)), Enum::name);
            public static final Codec<Parameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("radius").forGetter(Parameters::radius), (App)Codec.FLOAT.fieldOf("height").forGetter(Parameters::height), (App)Codec.FLOAT.fieldOf("stem_length").forGetter(Parameters::stemLength), (App)Codec.FLOAT.optionalFieldOf("fraction", (Object)Float.valueOf(16.0f)).forGetter(Parameters::fraction), (App)Codec.FLOAT.fieldOf("side_offset").forGetter(Parameters::sideOffset), (App)SIDE_CODEC.fieldOf("side").forGetter(Parameters::side)).apply((Applicative)instance, Parameters::new));
        }
    }
}

