/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util.holderset;

import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.holdersets.CompositeHolderSet;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.ICustomHolderSet;

public class IncludesExcludesHolderSet<T>
extends CompositeHolderSet<T> {
    private final HolderSet<T> includes;
    private final HolderSet<T> excludes;

    public static <T> Codec<? extends ICustomHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        Codec holderSetCodec = HolderSetCodec.m_206685_(registryKey, holderCodec, (boolean)forceList);
        return RecordCodecBuilder.create(builder -> builder.group((App)holderSetCodec.fieldOf("includes").forGetter(IncludesExcludesHolderSet::includes), (App)holderSetCodec.fieldOf("excludes").forGetter(IncludesExcludesHolderSet::excludes)).apply((Applicative)builder, IncludesExcludesHolderSet::new));
    }

    public IncludesExcludesHolderSet(HolderSet<T> includes, HolderSet<T> excludes) {
        super(List.of(includes, excludes));
        this.includes = includes;
        this.excludes = excludes;
    }

    public HolderSet<T> includes() {
        return this.includes;
    }

    public List<HolderSet<T>> getIncludeComponents() {
        List list;
        HolderSet<T> holderSet = this.includes;
        if (holderSet instanceof CompositeHolderSet) {
            CompositeHolderSet compositeHolderSet = (CompositeHolderSet)holderSet;
            list = compositeHolderSet.getComponents();
        } else {
            list = null;
        }
        return list;
    }

    public List<HolderSet<T>> getExcludeComponents() {
        List list;
        HolderSet<T> holderSet = this.excludes;
        if (holderSet instanceof CompositeHolderSet) {
            CompositeHolderSet compositeHolderSet = (CompositeHolderSet)holderSet;
            list = compositeHolderSet.getComponents();
        } else {
            list = null;
        }
        return list;
    }

    public void clear() {
        this.getIncludeComponents().clear();
        this.getExcludeComponents().clear();
    }

    public HolderSet<T> excludes() {
        return this.excludes;
    }

    protected Set<Holder<T>> createSet() {
        return this.includes.m_203614_().filter(holder -> !this.excludes.m_203333_(holder)).collect(Collectors.toSet());
    }

    public HolderSetType type() {
        return (HolderSetType)DTRegistries.INCLUDES_EXCLUDES_HOLDER_SET_TYPE.get();
    }
}

