/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.init.registrate.neapolitan;

import com.teamabnormals.neapolitan.common.block.FlavoredCandleCakeBlock;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.twilightdelight.compat.neapolitan.TDCakeBlock;
import dev.xkmc.twilightdelight.content.item.food.TDFoodItem;
import dev.xkmc.twilightdelight.init.TwilightDelight;
import dev.xkmc.twilightdelight.init.registrate.TDEffects;
import dev.xkmc.twilightdelight.init.registrate.TDItems;
import dev.xkmc.twilightdelight.init.registrate.delight.DelightFoodType;
import dev.xkmc.twilightdelight.init.registrate.delight.EffectSupplier;
import dev.xkmc.twilightdelight.init.registrate.delight.IFoodType;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;

public final class NeapolitanCakes
extends Enum<NeapolitanCakes> {
    public static final /* enum */ NeapolitanCakes AURORA = new NeapolitanCakes(MapColor.f_283772_, new EffectSupplier((Supplier<MobEffect>)TDEffects.AURORA_GLOWING, 300, 0, 1.0f), new EffectSupplier(() -> MobEffects.f_19596_, 300, 2, 1.0f), new EffectSupplier(() -> MobEffects.f_19603_, 300, 1, 1.0f));
    public static final /* enum */ NeapolitanCakes TORCHBERRY = new NeapolitanCakes(MapColor.f_283832_, new EffectSupplier((Supplier<MobEffect>)TDEffects.FIRE_RANGE, 300, 0, 1.0f));
    public static final /* enum */ NeapolitanCakes PHYTOCHEMICAL = new NeapolitanCakes(MapColor.f_283784_, new EffectSupplier((Supplier<MobEffect>)TDEffects.POISON_RANGE, 300, 0, 1.0f));
    public static final /* enum */ NeapolitanCakes GLACIER = new NeapolitanCakes(MapColor.f_283869_, new EffectSupplier((Supplier<MobEffect>)TDEffects.FROZEN_RANGE, 300, 0, 1.0f));
    private final String base = this.name().toLowerCase(Locale.ROOT);
    public final BlockEntry<TDCakeBlock> block;
    public final BlockEntry<FlavoredCandleCakeBlock> candle;
    public final BlockEntry<FlavoredCandleCakeBlock>[] colored_candles;
    public final ItemEntry<TDFoodItem> item;
    private static final /* synthetic */ NeapolitanCakes[] $VALUES;

    public static NeapolitanCakes[] values() {
        return (NeapolitanCakes[])$VALUES.clone();
    }

    public static NeapolitanCakes valueOf(String name) {
        return Enum.valueOf(NeapolitanCakes.class, name);
    }

    private NeapolitanCakes(MapColor color, EffectSupplier ... effects) {
        FoodProperties food = TDItems.simpleFood((IFoodType)DelightFoodType.NONE, 1, 0.1f, effects);
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY);
        this.item = TwilightDelight.REGISTRATE.item(this.base + "_cake_slice", p -> new TDFoodItem(p.m_41489_(food))).defaultModel().defaultLang().register();
        this.block = ((BlockBuilder)TwilightDelight.REGISTRATE.block(this.base + "_cake", p -> new TDCakeBlock(food, props, this)).blockstate(this::genCakeModels).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)this.item.get())).item().model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx)).build()).register();
        this.candle = TwilightDelight.REGISTRATE.block(this.base + "_candle_cake", p -> new FlavoredCandleCakeBlock(() -> this.block.get(), Blocks.f_152482_, props)).blockstate((ctx, pvd) -> this.genCandleModels((DataGenContext<Block, FlavoredCandleCakeBlock>)ctx, (RegistrateBlockstateProvider)pvd, "candle")).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)Items.f_151065_)).register();
        this.colored_candles = new BlockEntry[DyeColor.values().length];
        for (DyeColor dye : DyeColor.values()) {
            String color_name = dye.m_41065_();
            Block candle = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color_name + "_candle"));
            assert (candle != null);
            this.colored_candles[dye.ordinal()] = TwilightDelight.REGISTRATE.block(color_name + "_" + this.base + "_candle_cake", p -> new FlavoredCandleCakeBlock(() -> this.block.get(), candle, props)).blockstate((ctx, pvd) -> this.genCandleModels((DataGenContext<Block, FlavoredCandleCakeBlock>)ctx, (RegistrateBlockstateProvider)pvd, color_name + "_candle")).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)candle.m_5456_())).register();
        }
    }

    private void genCandleModels(DataGenContext<Block, FlavoredCandleCakeBlock> ctx, RegistrateBlockstateProvider pvd, String candle) {
        BlockModelBuilder nolit = this.genCandleCakeModel(ctx, pvd, candle, false);
        BlockModelBuilder lit = this.genCandleCakeModel(ctx, pvd, candle, true);
        pvd.getVariantBuilder((Block)ctx.getEntry()).forAllStates(e -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)e.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lit : nolit)).build());
    }

    private void genCakeModels(DataGenContext<Block, TDCakeBlock> ctx, RegistrateBlockstateProvider pvd) {
        BlockModelBuilder[] slice = new BlockModelBuilder[7];
        slice[0] = this.genCakeModel(pvd, "cake");
        for (int i = 1; i <= 6; ++i) {
            slice[i] = this.genCakeModel(pvd, "cake_slice" + i);
        }
        pvd.getVariantBuilder((Block)ctx.getEntry()).forAllStates(e -> ConfiguredModel.builder().modelFile((ModelFile)slice[(Integer)e.m_61143_((Property)BlockStateProperties.f_61412_)]).build());
    }

    private BlockModelBuilder genCakeModel(RegistrateBlockstateProvider pvd, String model) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(this.base + "_" + model, new ResourceLocation("block/" + model))).texture("particle", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("bottom", pvd.modLoc("block/" + this.base + "_cake_bottom"))).texture("top", pvd.modLoc("block/" + this.base + "_cake_top"))).texture("side", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("inside", pvd.modLoc("block/" + this.base + "_cake_inner"));
    }

    private BlockModelBuilder genCandleCakeModel(DataGenContext<Block, FlavoredCandleCakeBlock> ctx, RegistrateBlockstateProvider pvd, String candle, boolean lit) {
        Object name = ctx.getName();
        if (lit) {
            name = (String)name + "_lit";
            candle = (String)candle + "_lit";
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent((String)name, new ResourceLocation("block/template_cake_with_candle"))).texture("particle", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("bottom", pvd.modLoc("block/" + this.base + "_cake_bottom"))).texture("top", pvd.modLoc("block/" + this.base + "_cake_top"))).texture("side", pvd.modLoc("block/" + this.base + "_cake_side"))).texture("candle", pvd.mcLoc("block/" + (String)candle));
    }

    public static void register() {
    }

    private static /* synthetic */ NeapolitanCakes[] $values() {
        return new NeapolitanCakes[]{AURORA, TORCHBERRY, PHYTOCHEMICAL, GLACIER};
    }

    static {
        $VALUES = NeapolitanCakes.$values();
    }
}

