/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Block
extends Block {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.m_61587_((String)"connection", ConnectionStatus.class);
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)4.0, (double)15.99);
    protected static final VoxelShape SIDE_0 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_90 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_180 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0));
    protected static final VoxelShape SIDE_270 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape CORNER_0 = Shapes.m_83110_((VoxelShape)SIDE_180, (VoxelShape)SIDE_90);
    protected static final VoxelShape CORNER_90 = Shapes.m_83110_((VoxelShape)SIDE_180, (VoxelShape)SIDE_270);
    protected static final VoxelShape CORNER_180 = Shapes.m_83110_((VoxelShape)SIDE_270, (VoxelShape)SIDE_0);
    protected static final VoxelShape CORNER_270 = Shapes.m_83110_((VoxelShape)SIDE_0, (VoxelShape)SIDE_90);
    protected static final VoxelShape MIDDLE_90 = Shapes.m_83110_((VoxelShape)SIDE_0, (VoxelShape)SIDE_180);
    protected static final VoxelShape MIDDLE_0 = Shapes.m_83110_((VoxelShape)SIDE_90, (VoxelShape)SIDE_270);
    protected static final VoxelShape BASE_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)3.0, (double)15.99);
    protected static final VoxelShape COLLISION_SIDE_0 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_90 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_180 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)1.0));
    protected static final VoxelShape COLLISION_SIDE_270 = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_CORNER_0 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_CORNER_90 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_270);
    protected static final VoxelShape COLLISION_CORNER_180 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_270, (VoxelShape)COLLISION_SIDE_0);
    protected static final VoxelShape COLLISION_CORNER_270 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_MIDDLE_90 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_180);
    protected static final VoxelShape COLLISION_MIDDLE_0 = Shapes.m_83110_((VoxelShape)COLLISION_SIDE_90, (VoxelShape)COLLISION_SIDE_270);

    public Bridge_Block(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch ((ConnectionStatus)((Object)state.m_61143_(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return CORNER_270;
            }
            case CORNER_NW: {
                return CORNER_180;
            }
            case CORNER_SE: {
                return CORNER_0;
            }
            case CORNER_SW: {
                return CORNER_90;
            }
            case END_N_TOGGLED: {
                return SIDE_180;
            }
            case END_E_TOGGLED: {
                return SIDE_270;
            }
            case END_S_TOGGLED: {
                return SIDE_0;
            }
            case END_W_TOGGLED: {
                return SIDE_90;
            }
            case MIDDLE_EW: {
                return MIDDLE_0;
            }
            case MIDDLE_NS: {
                return MIDDLE_90;
            }
            case SIDE_E: {
                return SIDE_270;
            }
            case SIDE_N: {
                return SIDE_180;
            }
            case SIDE_S: {
                return SIDE_0;
            }
            case SIDE_W: {
                return SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE;
            }
        }
        return BASE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch ((ConnectionStatus)((Object)state.m_61143_(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return COLLISION_CORNER_270;
            }
            case CORNER_NW: {
                return COLLISION_CORNER_180;
            }
            case CORNER_SE: {
                return COLLISION_CORNER_0;
            }
            case CORNER_SW: {
                return COLLISION_CORNER_90;
            }
            case END_N_TOGGLED: {
                return COLLISION_SIDE_180;
            }
            case END_E_TOGGLED: {
                return COLLISION_SIDE_270;
            }
            case END_S_TOGGLED: {
                return COLLISION_SIDE_0;
            }
            case END_W_TOGGLED: {
                return COLLISION_SIDE_90;
            }
            case MIDDLE_EW: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_NS: {
                return COLLISION_MIDDLE_90;
            }
            case SIDE_E: {
                return COLLISION_SIDE_270;
            }
            case SIDE_N: {
                return COLLISION_SIDE_180;
            }
            case SIDE_S: {
                return COLLISION_SIDE_0;
            }
            case SIDE_W: {
                return COLLISION_SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE_COLLISION;
            }
        }
        return BASE_COLLISION;
    }

    private BlockState StairState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean north = access.m_8055_(pos.m_122012_()).m_60734_() == this;
        boolean east = access.m_8055_(pos.m_122029_()).m_60734_() == this;
        boolean south = access.m_8055_(pos.m_122019_()).m_60734_() == this;
        boolean west = access.m_8055_(pos.m_122024_()).m_60734_() == this;
        ConnectionStatus connection = this.getConnectionStatus(north, east, south, west);
        return (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!(north || south || east || west)) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (north && !east && !south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && !east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && east && !south && !west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && west) {
            return ConnectionStatus.CORNER_SW;
        }
        if (!north && east && south && !west) {
            return ConnectionStatus.CORNER_SE;
        }
        if (north && !east && !south && west) {
            return ConnectionStatus.CORNER_NW;
        }
        if (north && east && !south && !west) {
            return ConnectionStatus.CORNER_NE;
        }
        if (!north && east && south && west) {
            return ConnectionStatus.SIDE_N;
        }
        if (north && !east && south && west) {
            return ConnectionStatus.SIDE_E;
        }
        if (north && east && !south && west) {
            return ConnectionStatus.SIDE_S;
        }
        if (north && east && south && !west) {
            return ConnectionStatus.SIDE_W;
        }
        return ConnectionStatus.BASE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction facing;
        BlockPos placePos;
        BlockItem blockItem;
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        ConnectionStatus connection = (ConnectionStatus)((Object)state.m_61143_(CONNECTION));
        if (item == ItemInit.PLIERS.get() || item == Items.f_42574_) {
            ConnectionStatus newConnection = ConnectionStatus.BASE;
            switch (connection) {
                case SIDE_E: 
                case SIDE_N: 
                case SIDE_S: 
                case SIDE_W: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case CORNER_SW: {
                    newConnection = ConnectionStatus.CORNER_NW;
                    break;
                }
                case CORNER_NW: {
                    newConnection = ConnectionStatus.CORNER_NE;
                    break;
                }
                case CORNER_NE: {
                    newConnection = ConnectionStatus.CORNER_SE;
                    break;
                }
                case CORNER_SE: {
                    newConnection = ConnectionStatus.END_N_TOGGLED;
                    break;
                }
                case END_N_TOGGLED: {
                    newConnection = ConnectionStatus.END_E_TOGGLED;
                    break;
                }
                case END_E_TOGGLED: {
                    newConnection = ConnectionStatus.END_S_TOGGLED;
                    break;
                }
                case END_S_TOGGLED: {
                    newConnection = ConnectionStatus.END_W_TOGGLED;
                    break;
                }
                case END_W_TOGGLED: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case BASE_TOGGLED: {
                    newConnection = ConnectionStatus.CORNER_SW;
                    break;
                }
                case MIDDLE_EW: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case MIDDLE_NS: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case BASE: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
            }
            level.m_46597_(pos, (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)newConnection)));
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() instanceof BlockItem && (blockItem = (BlockItem)itemstack.m_41720_()).m_40614_() == this && level.m_8055_(placePos = pos.m_121945_(facing = player.m_6350_())).m_60795_()) {
            level.m_7731_(placePos, this.m_49966_(), 3);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.m_60713_(state.m_60734_())) {
            level.m_7731_(pos, this.StairState(state, (LevelAccessor)level, pos), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CONNECTION});
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        ConnectionStatus connection = (ConnectionStatus)((Object)state.m_61143_(CONNECTION));
        if (connection == ConnectionStatus.BASE_TOGGLED || connection == ConnectionStatus.END_N_TOGGLED || connection == ConnectionStatus.END_E_TOGGLED || connection == ConnectionStatus.END_S_TOGGLED || connection == ConnectionStatus.END_W_TOGGLED) {
            return state;
        }
        return this.StairState(state, access, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext contx) {
        BlockPos pos = contx.m_8083_().m_7495_();
        Level world = contx.m_43725_();
        BlockState stateBelow = world.m_8055_(pos);
        if (stateBelow.m_60734_() instanceof Bridge_Block) {
            return null;
        }
        return this.StairState(super.m_5573_(contx), (LevelAccessor)world, contx.m_8083_());
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        MIDDLE_NS("middle_ns"),
        MIDDLE_EW("middle_ew"),
        CORNER_NE("corner_ne"),
        CORNER_NW("corner_nw"),
        CORNER_SE("corner_se"),
        CORNER_SW("corner_sw"),
        SIDE_N("side_n"),
        SIDE_E("side_e"),
        SIDE_S("side_s"),
        SIDE_W("side_w"),
        END_N_TOGGLED("end_n_toggled"),
        END_E_TOGGLED("end_e_toggled"),
        END_S_TOGGLED("end_s_toggled"),
        END_W_TOGGLED("end_w_toggled"),
        BASE_TOGGLED("base_toggled");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

