/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.renderer.base;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class BaseEndermanModel<T extends GeoAnimatable>
extends DefaultedEntityGeoModel<T> {
    private final boolean turnsHead;

    public BaseEndermanModel(ResourceLocation assetSubpath, boolean turnsHead, ResourceLocation texture, ResourceLocation animation) {
        super(assetSubpath, turnsHead);
        this.withAltTexture(texture);
        this.withAltAnimations(animation);
        this.turnsHead = turnsHead;
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        if (!this.turnsHead) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head == null) {
            return;
        }
        if (head.getChildBones().isEmpty()) {
            return;
        }
        CoreGeoBone headRotation = (CoreGeoBone)head.getChildBones().get(0);
        if (headRotation == null) {
            return;
        }
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        headRotation.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
        headRotation.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
    }
}

