/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.goblintraders.core.ModEntities;
import com.mrcrayfish.goblintraders.core.ModPotions;
import com.mrcrayfish.goblintraders.datagen.TradeProvider;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.BasicTrade;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class GoblinTradeProvider
extends TradeProvider {
    public GoblinTradeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    @Override
    public void registerTrades() {
        this.registerGoblinTraderTrades();
        this.registerVeinGoblinTraderTrades();
    }

    private void registerGoblinTraderTrades() {
        EnchantmentInstance[] shovelEnchantments;
        EnchantmentInstance[] axeEnchantments;
        EnchantmentInstance[] pickaxeEnchantments;
        Item[] creeperMusicDiscs;
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42616_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42410_, 8)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42416_, 2)).setPaymentStack(new ItemStack((ItemLike)Items.f_151050_)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42417_, 3)).setPaymentStack(new ItemStack((ItemLike)Items.f_151053_, 2)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_151052_, 2)).setPaymentStack(new ItemStack((ItemLike)Items.f_151051_, 1)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42413_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42583_, 4)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42484_, 2)).setPaymentStack(new ItemStack((ItemLike)Items.f_41832_)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42616_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42594_, 32)).setPriceMultiplier(0.0f).setMaxTrades(128).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42403_, 2)).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42616_, 6)).setPaymentStack(new ItemStack((ItemLike)Items.f_42279_)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42616_, 8)).setPaymentStack(new ItemStack((ItemLike)Items.f_42456_)).setPriceMultiplier(0.0f).setMaxTrades(4).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_41902_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_, 8)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42147_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42148_)).setSecondaryPaymentStack(new ItemStack((ItemLike)Items.f_42416_, 4)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42146_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42147_)).setSecondaryPaymentStack(new ItemStack((ItemLike)Items.f_42416_, 4)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42199_, 2)).setPaymentStack(new ItemStack((ItemLike)Items.f_41983_)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42517_, 2)).setPaymentStack(new ItemStack((ItemLike)Items.f_42454_)).setSecondaryPaymentStack(new ItemStack((ItemLike)Items.f_42516_, 3)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42616_)).setPaymentStack(new ItemStack((ItemLike)Items.f_151049_, 2)).setPriceMultiplier(0.0f).setMaxTrades(20).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42612_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_, 3)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42656_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_, 24)).setSecondaryPaymentStack(new ItemStack((ItemLike)Items.f_42516_, 8)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42363_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42201_, 4)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(10).build());
        ItemStack luckOfTheSeaBook = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)Enchantments.f_44953_, (Object)3), (ItemStack)luckOfTheSeaBook);
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42523_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42523_)).setSecondaryPaymentStack(luckOfTheSeaBook).setPriceMultiplier(0.5f).setMaxTrades(2).setExperience(30).addEnchantment(new EnchantmentInstance(Enchantments.f_44953_, 5)).build());
        ItemStack lureBook = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)Enchantments.f_44954_, (Object)3), (ItemStack)lureBook);
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42523_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42523_)).setSecondaryPaymentStack(lureBook).setPriceMultiplier(0.5f).setMaxTrades(2).setExperience(30).addEnchantment(new EnchantmentInstance(Enchantments.f_44954_, 5)).build());
        for (Item disc : creeperMusicDiscs = new Item[]{Items.f_42701_, Items.f_42702_, Items.f_42703_, Items.f_42706_, Items.f_42707_}) {
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)disc, 1)).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_, 32)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(100).build());
        }
        for (EnchantmentInstance pickaxeEnchant : pickaxeEnchantments = new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.f_44984_, 5), new EnchantmentInstance(Enchantments.f_44986_, 3), new EnchantmentInstance(Enchantments.f_44987_, 3)}) {
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)pickaxeEnchant.f_44947_, (Object)pickaxeEnchant.f_44948_), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42390_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42390_)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentInstance(pickaxeEnchant.f_44947_, pickaxeEnchant.f_44948_ + 1)).build());
        }
        for (EnchantmentInstance axeEnchant : axeEnchantments = new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.f_44984_, 5), new EnchantmentInstance(Enchantments.f_44986_, 3)}) {
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)axeEnchant.f_44947_, (Object)axeEnchant.f_44948_), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42391_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42391_)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentInstance(axeEnchant.f_44947_, axeEnchant.f_44948_ + 1)).build());
        }
        for (EnchantmentInstance shovelEnchant : shovelEnchantments = new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.f_44984_, 5), new EnchantmentInstance(Enchantments.f_44986_, 3)}) {
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)shovelEnchant.f_44947_, (Object)shovelEnchant.f_44948_), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42389_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42389_)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentInstance(shovelEnchant.f_44947_, shovelEnchant.f_44948_ + 1)).build());
        }
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42390_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42683_, 5)).setSecondaryPaymentStack(new ItemStack((ItemLike)Items.f_42390_)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(1000).addEnchantment(new EnchantmentInstance(Enchantments.f_44987_, 5)).addEnchantment(new EnchantmentInstance(Enchantments.f_44986_, 5)).build());
    }

    private void registerVeinGoblinTraderTrades() {
        Potion[] epicPotions;
        Potion[] rarePotions;
        EnchantmentInstance[] swordEnchantments;
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42616_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42619_)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42525_, 4)).setPaymentStack(new ItemStack((ItemLike)Items.f_42054_)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42616_, 1)).setPaymentStack(new ItemStack((ItemLike)Items.f_42048_, 64)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42588_, 2)).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_)).setPriceMultiplier(0.0f).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42747_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42418_, 2)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42419_, 5)).setPaymentStack(new ItemStack((ItemLike)Items.f_42792_, 4)).setPriceMultiplier(0.0f).setMaxTrades(20).setExperience(50).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42261_, 1)).setPaymentStack(new ItemStack((ItemLike)Items.f_42588_)).setSecondaryPaymentStack(new ItemStack((ItemLike)Items.f_42691_)).setPriceMultiplier(0.0f).setMaxTrades(128).setExperience(4).build());
        for (EnchantmentInstance swordEnchant : swordEnchantments = new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.f_44977_, 5), new EnchantmentInstance(Enchantments.f_44982_, 3), new EnchantmentInstance(Enchantments.f_44983_, 3), new EnchantmentInstance(Enchantments.f_44981_, 2), new EnchantmentInstance(Enchantments.f_44980_, 2), new EnchantmentInstance(Enchantments.f_44979_, 5), new EnchantmentInstance(Enchantments.f_44978_, 5)}) {
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)swordEnchant.f_44947_, (Object)swordEnchant.f_44948_), (ItemStack)enchantedBook);
            this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42388_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42388_)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentInstance(swordEnchant.f_44947_, swordEnchant.f_44948_ + 1)).build());
        }
        Item[] diamondArmorSet = new Item[]{Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_};
        EnchantmentInstance[] armorEnchantments = new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.f_44968_, 4), new EnchantmentInstance(Enchantments.f_44966_, 4), new EnchantmentInstance(Enchantments.f_44969_, 4), new EnchantmentInstance(Enchantments.f_44965_, 4), new EnchantmentInstance(Enchantments.f_44986_, 3)};
        for (Item piece : diamondArmorSet) {
            for (EnchantmentInstance armorEnchant : armorEnchantments) {
                ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
                EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)armorEnchant.f_44947_, (Object)armorEnchant.f_44948_), (ItemStack)enchantedBook);
                this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)piece)).setPaymentStack(new ItemStack((ItemLike)piece)).setSecondaryPaymentStack(enchantedBook).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(200).addEnchantment(new EnchantmentInstance(armorEnchant.f_44947_, armorEnchant.f_44948_ + 1)).build());
            }
        }
        for (Potion potion : rarePotions = new Potion[]{(Potion)ModPotions.EXTENDED_NIGHT_VISION.get(), (Potion)ModPotions.EXTENDED_INVISIBILITY.get(), (Potion)ModPotions.POWERFUL_JUMP_BOOST.get(), (Potion)ModPotions.EXTENDED_FIRE_RESISTANCE.get(), (Potion)ModPotions.POWERFUL_SPEED.get(), (Potion)ModPotions.EXTENDED_WATER_BREATHING.get(), (Potion)ModPotions.POWERFUL_INSTANT_HEALTH.get(), (Potion)ModPotions.POWERFUL_REGENERATION.get(), (Potion)ModPotions.EXTENDED_SLOW_FALLING.get()}) {
            ItemStack potionStack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potion);
            ItemStack awkwardPotion = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)awkwardPotion, (Potion)Potions.f_43602_);
            this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(potionStack).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_, 15)).setSecondaryPaymentStack(awkwardPotion).setPriceMultiplier(0.5f).setMaxTrades(8).setExperience(100).build());
        }
        for (Potion potion : epicPotions = new Potion[]{(Potion)ModPotions.HASTE.get(), (Potion)ModPotions.ABSORPTION.get(), (Potion)ModPotions.LEVITATION.get(), (Potion)ModPotions.LUCK.get(), (Potion)ModPotions.DOLPHINS_GRACE.get(), (Potion)ModPotions.POWERFUL_STRENGTH.get()}) {
            ItemStack potionStack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potion);
            ItemStack awkwardPotion = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)awkwardPotion, (Potion)Potions.f_43602_);
            this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(potionStack).setPaymentStack(new ItemStack((ItemLike)Items.f_42616_, 25)).setSecondaryPaymentStack(awkwardPotion).setPriceMultiplier(0.5f).setMaxTrades(4).setExperience(100).build());
        }
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.f_42388_)).setPaymentStack(new ItemStack((ItemLike)Items.f_42683_, 5)).setSecondaryPaymentStack(new ItemStack((ItemLike)Items.f_42388_)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(1000).addEnchantment(new EnchantmentInstance(Enchantments.f_44977_, 7)).addEnchantment(new EnchantmentInstance(Enchantments.f_44986_, 7)).build());
    }
}

