/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FirePanicGoal
extends Goal {
    private final AbstractGoblinEntity goblin;
    private final double speed;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public FirePanicGoal(AbstractGoblinEntity goblin, double speedIn) {
        this.goblin = goblin;
        this.speed = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.goblin.m_6060_() && !this.goblin.isStunned()) {
            BlockPos blockpos = this.getClosestWaterPos((BlockGetter)this.goblin.m_9236_(), (Entity)this.goblin, 5, 4);
            if (blockpos != null) {
                this.randPosX = blockpos.m_123341_();
                this.randPosY = blockpos.m_123342_();
                this.randPosZ = blockpos.m_123343_();
                return true;
            }
            return this.findRandomPosition();
        }
        return false;
    }

    public void m_8056_() {
        this.goblin.m_21573_().m_26519_(this.randPosX, this.randPosY, this.randPosZ, this.speed);
    }

    public boolean m_8045_() {
        return !this.goblin.m_21573_().m_26571_();
    }

    private boolean findRandomPosition() {
        Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)this.goblin, (int)5, (int)4);
        if (randomPos == null) {
            return false;
        }
        this.randPosX = randomPos.f_82479_;
        this.randPosY = randomPos.f_82480_;
        this.randPosZ = randomPos.f_82481_;
        return true;
    }

    @Nullable
    private BlockPos getClosestWaterPos(BlockGetter blockGetter, Entity entityIn, int horizontalRange, int verticalRange) {
        BlockPos entityPos = entityIn.m_20183_();
        int entityX = entityPos.m_123341_();
        int entityY = entityPos.m_123342_();
        int entityZ = entityPos.m_123343_();
        float range = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos randomPos = null;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (int x = entityX - horizontalRange; x <= entityX + horizontalRange; ++x) {
            for (int y = entityY - verticalRange; y <= entityY + verticalRange; ++y) {
                for (int z = entityZ - horizontalRange; z <= entityZ + horizontalRange; ++z) {
                    float f1;
                    currentPos.m_122178_(x, y, z);
                    if (!blockGetter.m_6425_((BlockPos)currentPos).m_205070_(FluidTags.f_13131_) || !((f1 = (float)((x - entityX) * (x - entityX) + (y - entityY) * (y - entityY) + (z - entityZ) * (z - entityZ))) < range)) continue;
                    range = f1;
                    randomPos = new BlockPos((Vec3i)currentPos);
                }
            }
        }
        return randomPos;
    }
}

