/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.mixin;

import java.util.Map;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantMenu.class})
public class MerchantMenuMixin {
    @Shadow
    @Final
    private MerchantContainer f_40028_;

    @Inject(method={"moveFromInventoryToPaymentSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void goblinTradersMoveFromInventoryToPaymentSlot(int tradeIndex, ItemStack payment, CallbackInfo ci) {
        if (!EnchantmentHelper.m_44831_((ItemStack)payment).isEmpty()) {
            ci.cancel();
            MerchantMenu menu = (MerchantMenu)this;
            for (int i = 3; i < menu.f_38839_.size(); ++i) {
                ItemStack slotStack = ((Slot)menu.f_38839_.get(i)).m_7993_();
                if (slotStack.m_41619_() || !MerchantMenuMixin.goblinTraders$isMatching(payment, slotStack)) continue;
                ItemStack stack = this.f_40028_.m_8020_(tradeIndex);
                int count = stack.m_41619_() ? 0 : stack.m_41613_();
                int addCount = Math.min(payment.m_41741_() - count, slotStack.m_41613_());
                ItemStack copy = slotStack.m_41777_();
                int newCount = count + addCount;
                slotStack.m_41774_(addCount);
                copy.m_41764_(newCount);
                this.f_40028_.m_6836_(tradeIndex, copy);
                if (newCount >= payment.m_41741_()) break;
            }
        }
    }

    @Unique
    private static boolean goblinTraders$isMatching(ItemStack a, ItemStack b) {
        if (a.m_41720_() == Items.f_42690_ && b.m_41720_() == Items.f_42690_) {
            Map givenEnchantments = EnchantmentHelper.m_44831_((ItemStack)b);
            Map paymentEnchantments = EnchantmentHelper.m_44831_((ItemStack)a);
            paymentEnchantments.entrySet().removeIf(entry -> {
                Integer level = (Integer)givenEnchantments.get(entry.getKey());
                return level != null && level >= (Integer)entry.getValue();
            });
            if (paymentEnchantments.isEmpty()) {
                return true;
            }
        }
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }
}

