/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Map;

public class BedBlockCompatibilityHandler
implements NBTCompatibilityHandler {
    private static final Property<Direction> FACING_PROPERTY;
    private static final Property<String> PART_PROPERTY;

    @Override
    public <B extends BlockStateHolder<B>> boolean isAffectedBlock(B block) {
        return block.getBlockType() == BlockTypes.RED_BED;
    }

    @Override
    public <B extends BlockStateHolder<B>> BlockStateHolder<?> updateNBT(B block, Map<String, Tag> values) {
        BlockType type;
        String bedType;
        Tag typeTag = values.get("color");
        if (typeTag instanceof IntTag && (bedType = this.convertBedType(((IntTag)typeTag).getValue())) != null && (type = BlockTypes.get("minecraft:" + bedType)) != null) {
            BlockStateHolder<BlockState> state = type.getDefaultState();
            Property facingProp = type.getProperty("facing");
            state = ((BlockState)state).with(facingProp, (Object)block.getState(FACING_PROPERTY));
            Property occupiedProp = type.getProperty("occupied");
            state = ((BlockState)state).with(occupiedProp, (Object)false);
            Property partProp = type.getProperty("part");
            state = ((BlockState)state).with(partProp, block.getState(PART_PROPERTY));
            values.remove("color");
            return state;
        }
        return block;
    }

    private String convertBedType(int oldType) {
        String color;
        switch (oldType) {
            case 0: {
                color = "white";
                break;
            }
            case 1: {
                color = "orange";
                break;
            }
            case 2: {
                color = "magenta";
                break;
            }
            case 3: {
                color = "light_blue";
                break;
            }
            case 4: {
                color = "yellow";
                break;
            }
            case 5: {
                color = "lime";
                break;
            }
            case 6: {
                color = "pink";
                break;
            }
            case 7: {
                color = "gray";
                break;
            }
            case 8: {
                color = "light_gray";
                break;
            }
            case 9: {
                color = "cyan";
                break;
            }
            case 10: {
                color = "purple";
                break;
            }
            case 11: {
                color = "blue";
                break;
            }
            case 12: {
                color = "brown";
                break;
            }
            case 13: {
                color = "green";
                break;
            }
            case 14: {
                color = "red";
                break;
            }
            case 15: {
                color = "black";
                break;
            }
            default: {
                return null;
            }
        }
        return color + "_bed";
    }

    static {
        Property tempPart;
        Property tempFacing;
        try {
            tempFacing = BlockTypes.RED_BED.getProperty("facing");
            tempPart = BlockTypes.RED_BED.getProperty("part");
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            tempFacing = null;
            tempPart = null;
        }
        FACING_PROPERTY = tempFacing;
        PART_PROPERTY = tempPart;
    }
}

