/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.block;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.loot.entry.SeedItemLootPoolEntry;
import com.ferreusveritas.dynamictrees.loot.function.MultiplyLogsCount;
import com.ferreusveritas.dynamictrees.loot.function.MultiplySticksCount;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.Connections;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesplus.init.DTPConfigs;
import com.ferreusveritas.dynamictreesplus.tree.CactusSpecies;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CactusBranchBlock
extends BranchBlock {
    public static final EnumProperty<Direction> ORIGIN = EnumProperty.m_61594_((String)"origin", Direction.class, (Predicate)((com.google.common.base.Predicate)dir -> dir != Direction.UP));
    public static final EnumProperty<CactusThickness> TRUNK_TYPE = EnumProperty.m_61587_((String)"type", CactusThickness.class);
    private static final double hurtMovementDelta = 0.003;

    public CactusBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(TRUNK_TYPE, (Comparable)((Object)CactusThickness.TRUNK))).m_61124_(ORIGIN, (Comparable)Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ORIGIN, TRUNK_TYPE});
    }

    public int branchSupport(BlockState blockState, BlockGetter blockAccess, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return 0;
    }

    public boolean checkForRot(LevelAccessor level, BlockPos pos, Species species, int fertility, int radius, RandomSource rand, float chance, boolean rapid) {
        return false;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        boolean damage = false;
        if (((Boolean)DTPConfigs.CACTUS_PRICKLE_ON_MOVE_ONLY.get()).booleanValue() && entity instanceof LivingEntity) {
            boolean falling = entity.m_20184_().f_82480_ < 0.0;
            entity.m_20334_(entity.m_20184_().f_82479_ * 0.25, entity.m_20184_().f_82480_ * (falling ? 0.5 : 1.0), entity.m_20184_().f_82481_ * 0.25);
            if (!(worldIn.f_46443_ || entity.f_19790_ == entity.m_20185_() && entity.f_19791_ == entity.m_20186_() && entity.f_19792_ == entity.m_20189_())) {
                double xMovement = Math.abs(entity.m_20185_() - entity.f_19790_);
                double yMovement = Math.abs(entity.m_20186_() - entity.f_19791_);
                double zMovement = Math.abs(entity.m_20189_() - entity.f_19792_);
                if (xMovement >= 0.003 || yMovement >= 0.003 || zMovement >= 0.003) {
                    damage = true;
                }
            }
        } else if (!(entity instanceof ItemEntity) || ((Boolean)DTPConfigs.CACTUS_KILL_ITEMS.get()).booleanValue()) {
            damage = true;
        }
        if (damage) {
            entity.m_6469_(worldIn.m_269111_().m_269325_(), 1.0f);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState returnState = this.m_49966_();
        BlockState adjState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        boolean trunk = context.m_43719_() == Direction.UP && (adjState.m_60734_() != this || adjState.m_61143_(TRUNK_TYPE) != CactusThickness.BRANCH);
        return (BlockState)((BlockState)returnState.m_61124_(TRUNK_TYPE, (Comparable)((Object)(trunk ? CactusThickness.TRUNK : CactusThickness.BRANCH)))).m_61124_(ORIGIN, (Comparable)(context.m_43719_() != Direction.DOWN ? context.m_43719_().m_122424_() : Direction.DOWN));
    }

    public Cell getHydrationCell(BlockGetter blockAccess, BlockPos pos, BlockState blockState, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    protected int getCactusRadius(CactusThickness trunk) {
        switch (trunk) {
            default: {
                return this.getFamily().getSecondaryThickness();
            }
            case TRUNK: {
                return this.getFamily().getPrimaryThickness();
            }
            case CORE: 
        }
        return 7;
    }

    public int getRadius(BlockState blockState) {
        return blockState.m_60734_() == this ? this.getCactusRadius((CactusThickness)((Object)blockState.m_61143_(TRUNK_TYPE))) : 0;
    }

    public int setRadius(LevelAccessor world, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        world.m_7731_(pos, (BlockState)this.getStateForRadius(radius).m_61124_(ORIGIN, (Comparable)Objects.requireNonNullElse(originDir, Direction.DOWN)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    public int probabilityForBlock(BlockState blockState, BlockGetter blockAccess, BlockPos pos, BranchBlock from) {
        return this.isSameTree(from) ? this.getRadius(blockState) + 2 : 0;
    }

    public GrowSignal growIntoAir(Level world, BlockPos pos, GrowSignal signal) {
        Direction originDir = signal.dir.m_122424_();
        CactusThickness trunk = signal.getSpecies() instanceof CactusSpecies ? ((CactusSpecies)signal.getSpecies()).thicknessForBranchPlaced((LevelAccessor)world, pos, true) : CactusThickness.BRANCH;
        if (originDir.m_122434_() != Direction.Axis.Y && (world.m_8055_(pos.m_7494_()).m_60734_() == this || world.m_8055_(pos.m_7495_()).m_60734_() == this)) {
            signal.success = false;
            return signal;
        }
        if (originDir == Direction.UP) {
            originDir = Direction.DOWN;
        }
        signal.success = world.m_7731_(pos, (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TRUNK_TYPE, (Comparable)((Object)trunk))).m_61124_(ORIGIN, (Comparable)originDir), 2);
        signal.radius = this.getCactusRadius(trunk);
        return signal;
    }

    public GrowSignal growSignal(Level world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            CactusThickness newIsTrunk;
            CactusThickness isTrunk;
            Species species = signal.getSpecies();
            Direction targetDir = species.getGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(world, pos, signal.getSpecies(), (BranchBlock)this, signal));
            signal.doTurn(targetDir);
            BlockPos deltaPos = pos.m_121945_(targetDir);
            BlockState deltaState = world.m_8055_(deltaPos);
            TreePart treepart = TreeHelper.getTreePart((BlockState)deltaState);
            if (treepart == this) {
                signal = treepart.growSignal(world, deltaPos, signal);
            } else if (world.m_46859_(deltaPos)) {
                signal = this.growIntoAir(world, deltaPos, signal);
            }
            BlockState thisState = world.m_8055_(pos);
            if (thisState.m_60734_() == this && species instanceof CactusSpecies && (isTrunk = (CactusThickness)((Object)thisState.m_61143_(TRUNK_TYPE))) != (newIsTrunk = ((CactusSpecies)species).thicknessAfterGrowthSignal(world, pos, signal, isTrunk))) {
                this.setRadius((LevelAccessor)world, pos, this.getCactusRadius(newIsTrunk), (Direction)thisState.m_61143_(ORIGIN));
            }
        }
        return signal;
    }

    public BlockState getStateForRadius(int radius) {
        CactusThickness thickness = CactusThickness.BRANCH;
        if (radius >= this.getCactusRadius(CactusThickness.CORE)) {
            thickness = CactusThickness.CORE;
        } else if (radius >= this.getCactusRadius(CactusThickness.TRUNK)) {
            thickness = CactusThickness.TRUNK;
        }
        return (BlockState)this.m_49966_().m_61124_(TRUNK_TYPE, (Comparable)((Object)thickness));
    }

    public Connections getConnectionData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Connections connections = new Connections();
        for (Direction dir : Direction.values()) {
            connections.setRadius(dir, this.getSideConnectionRadius((BlockGetter)world, pos, dir));
        }
        return connections;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int thisRadius = this.getRadius(state);
        VoxelShape shape = Shapes.m_83040_();
        int numConnections = 0;
        for (Direction dir : Direction.values()) {
            int connRadius = this.getSideConnectionRadius(worldIn, pos, dir);
            if (connRadius <= 0) continue;
            ++numConnections;
            double radius = (double)Mth.m_14045_((int)connRadius, (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AABB aabb = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82400_(radius);
            aabb = aabb.m_82386_((double)dir.m_122429_() * gap, (double)dir.m_122430_() * gap, (double)dir.m_122431_() * gap).m_82386_(0.5, 0.5, 0.5);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
        }
        if (state.m_61143_(TRUNK_TYPE) == CactusThickness.BRANCH && numConnections == 1 && ((Direction)state.m_61143_(ORIGIN)).m_122434_().m_122479_()) {
            double radius = (double)Mth.m_14045_((int)this.getCactusRadius(CactusThickness.BRANCH), (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AABB aabb = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82400_(radius);
            aabb = aabb.m_82386_((double)Direction.UP.m_122429_() * gap, (double)Direction.UP.m_122430_() * gap, (double)Direction.UP.m_122431_() * gap).m_82386_(0.5, 0.5, 0.5);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
        }
        double min = 0.5 - (double)thisRadius / 16.0;
        double max = 0.5 + (double)thisRadius / 16.0;
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)new AABB(min, min, min, max, max, max)), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public int getRadiusForConnection(BlockState blockState, BlockGetter blockAccess, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(blockState);
    }

    protected int getSideConnectionRadius(BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockPos deltaPos = pos.m_121945_(side);
        BlockState otherState = CoordUtils.getStateSafe((BlockGetter)blockAccess, (BlockPos)deltaPos);
        BlockState state = CoordUtils.getStateSafe((BlockGetter)blockAccess, (BlockPos)pos);
        if (otherState == null || state == null || state.m_60734_() != this) {
            return 0;
        }
        if (otherState.m_60734_() == this && (otherState.m_61143_(ORIGIN) == side.m_122424_() || state.m_61143_(ORIGIN) == side)) {
            return Math.min(this.getCactusRadius((CactusThickness)((Object)state.m_61143_(TRUNK_TYPE))), this.getCactusRadius((CactusThickness)((Object)otherState.m_61143_(TRUNK_TYPE))));
        }
        if (side == Direction.DOWN && state.m_61143_(ORIGIN) == side && (otherState.m_60734_() == this || otherState.m_60734_() instanceof RootyBlock)) {
            return this.getCactusRadius((CactusThickness)((Object)state.m_61143_(TRUNK_TYPE)));
        }
        return 0;
    }

    public MapSignal analyse(BlockState blockState, LevelAccessor world, BlockPos pos, Direction fromDir, MapSignal signal) {
        if (signal.depth++ < 32) {
            BlockState state = world.m_8055_(pos);
            signal.run(blockState, world, pos, fromDir);
            for (Direction dir : Direction.values()) {
                if (dir == fromDir) continue;
                BlockPos deltaPos = pos.m_121945_(dir);
                BlockState deltaState = world.m_8055_(deltaPos);
                if (deltaState.m_60734_() == this && deltaState.m_61143_(ORIGIN) == dir.m_122424_()) {
                    signal = ((TreePart)deltaState.m_60734_()).analyse(deltaState, world, deltaPos, dir.m_122424_(), signal);
                } else if (state.m_60734_() == this && state.m_61143_(ORIGIN) == dir) {
                    signal = TreeHelper.getTreePart((BlockState)deltaState).analyse(deltaState, world, deltaPos, dir.m_122424_(), signal);
                }
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, world, pos, fromDir);
        } else {
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)state.m_60734_();
                branch.breakDeliberate(world, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    public LootTable.Builder createBranchDrops() {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)this.getPrimitiveLog().get())).m_79078_(MultiplyLogsCount.multiplyLogsCount()).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)SeedItemLootPoolEntry.lootTableSeedItem().m_79078_(MultiplySticksCount.multiplySticksCount()).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()))).m_79165_(DTLootParameterSets.BRANCHES);
    }

    public static enum CactusThickness implements StringRepresentable
    {
        BRANCH("branch", 4),
        TRUNK("trunk", 5),
        CORE("core", 7);

        final String name;
        final int radius;

        private CactusThickness(String name, int radius) {
            this.name = name;
            this.radius = radius;
        }

        public int getRadius() {
            return this.radius;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

