/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.data;

import com.ferreusveritas.dynamictrees.data.provider.DataGenerationStreamEvent;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.loot.function.MultiplyLogsCount;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTPLootTableHandler {
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));

    @SubscribeEvent
    public static void onLootTableProviderGenerate(DataGenerationStreamEvent event) {
        CapProperties.REGISTRY.dataGenerationStream(event.getModId()).forEach(capProperties -> {
            DTPLootTableHandler.addCapBlockTable(capProperties, event.getExistingFileHelper(), event.getMap());
            DTPLootTableHandler.addCapTable(capProperties, event.getExistingFileHelper(), event.getMap());
        });
    }

    private static void addCapBlockTable(CapProperties capProperties, ExistingFileHelper existingFileHelper, Map<ResourceLocation, LootTable.Builder> map) {
        ResourceLocation capBlockTablePath;
        if (capProperties.shouldGenerateBlockDrops() && !existingFileHelper.exists(capBlockTablePath = capProperties.getBlockLootTableName(), PackType.SERVER_DATA)) {
            map.put(capBlockTablePath, capProperties.createBlockDrops());
        }
    }

    private static void addCapTable(CapProperties capProperties, ExistingFileHelper existingFileHelper, Map<ResourceLocation, LootTable.Builder> map) {
        ResourceLocation capTablePath;
        if (capProperties.shouldGenerateDrops() && !existingFileHelper.exists(capTablePath = capProperties.getLootTableName(), PackType.SERVER_DATA)) {
            map.put(capTablePath, capProperties.createDrops());
        }
    }

    public static LootTable.Builder createMushroomBranchDrops(Block primitiveLogBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)primitiveLogBlock).m_79078_(MultiplyLogsCount.multiplyLogsCount()).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(HAS_SILK_TOUCH))).m_79165_(DTLootParameterSets.BRANCHES);
    }

    public static LootTable.Builder createCapBlockDrops(Block primitiveCapBlock, Item primitiveSapling, int countMin, int countMax) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)primitiveCapBlock).m_79080_(HAS_SILK_TOUCH), LootItem.m_79579_((ItemLike)primitiveSapling).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)countMin, (float)countMax), (boolean)false)).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165026_((int)0))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}))).m_79165_(LootContextParamSets.f_81421_);
    }

    public static LootTable.Builder createCapDrops(Block primitiveCapBlock, Item primitiveSapling, LootContextParamSet parameterSet) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)primitiveCapBlock).m_79080_(HAS_SILK_TOUCH), LootItem.m_79579_((ItemLike)primitiveSapling)})).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.2f, 0.2333333f, 0.2666666f, 0.3f}))).m_79165_(parameterSet);
    }
}

