/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.resources;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.applier.ApplierRegistryEvent;
import com.ferreusveritas.dynamictrees.deserialisation.EnumDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.PropertyAppliers;
import com.ferreusveritas.dynamictrees.deserialisation.RegistryEntryDeserialiser;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomShapeConfiguration;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.shapekits.MushroomShapeKit;
import com.ferreusveritas.dynamictreesplus.systems.thicknesslogic.CactusThicknessLogic;
import com.ferreusveritas.dynamictreesplus.tree.CactusSpecies;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomFamily;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import com.google.gson.JsonElement;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="dynamictreesplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class JsonRegistries {
    private static final Logger LOGGER = LogManager.getLogger();

    private static void logError(ResourceLocation name, String error, String registryName) {
        LOGGER.error("Error whilst loading type \"" + registryName + "\" with name \"" + name + "\": {}", (Object)error);
    }

    private static void logWarning(ResourceLocation name, String warning, String registryName) {
        LOGGER.warn("Warning whilst loading type \"" + registryName + "\" with name \"" + name + "\": {}", (Object)warning);
    }

    @SubscribeEvent
    public static void registerFamilyCommonAppliers(ApplierRegistryEvent.Common<Family, JsonElement> event) {
        JsonRegistries.registerMushroomCommonApplier((PropertyAppliers<Family, JsonElement>)event.getAppliers());
    }

    public static void registerMushroomCommonApplier(PropertyAppliers<Family, JsonElement> appliers) {
        appliers.register("common_cap", HugeMushroomFamily.class, ResourceLocation.class, (family, registryName) -> {
            ResourceLocation processedRegName = TreeRegistry.processResLoc((ResourceLocation)registryName);
            CapProperties.REGISTRY.runOnNextLock(CapProperties.REGISTRY.generateIfValidRunnable(processedRegName, family::setCommonCap, () -> JsonRegistries.logWarning(family.getRegistryName(), "Could not set common cap for family with name \"" + family + "\" as cap \"" + processedRegName + "\" was not found.", Family.REGISTRY.getName())));
        });
    }

    @SubscribeEvent
    public static void registerSpeciesLoadAppliers(ApplierRegistryEvent.Load<Species, JsonElement> event) {
        JsonRegistries.registerCactusLoadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
    }

    @SubscribeEvent
    public static void registerSpeciesReloadAppliers(ApplierRegistryEvent.Reload<Species, JsonElement> event) {
        JsonRegistries.registerMushroomReloadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
        JsonRegistries.registerCactusReloadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
    }

    @SubscribeEvent
    public static void registerSpeciesDataAppliers(ApplierRegistryEvent.GatherData<Species, JsonElement> event) {
        JsonRegistries.registerCactusReloadApplier((PropertyAppliers<Species, JsonElement>)event.getAppliers());
    }

    public static void registerCactusLoadApplier(PropertyAppliers<Species, JsonElement> appliers) {
        appliers.register("is_seed_edible", CactusSpecies.class, Boolean.class, CactusSpecies::setSeedEdible);
    }

    public static void registerMushroomReloadApplier(PropertyAppliers<Species, JsonElement> appliers) {
        appliers.register("cap_properties", HugeMushroomSpecies.class, CapProperties.class, HugeMushroomSpecies::setCapProperties).register("mushroom_shape_kit", HugeMushroomSpecies.class, MushroomShapeConfiguration.class, HugeMushroomSpecies::setMushroomShapeConfiguration).register("accept_any_soil", HugeMushroomSpecies.class, Boolean.class, HugeMushroomSpecies::setAcceptAnySoil).register("max_light_for_planting", HugeMushroomSpecies.class, Integer.class, HugeMushroomSpecies::setMaxLightForPlanting);
    }

    public static void registerCactusReloadApplier(PropertyAppliers<Species, JsonElement> appliers) {
        appliers.register("cactus_thickness_logic", CactusSpecies.class, CactusThicknessLogic.class, CactusSpecies::setThicknessLogic);
    }

    @SubscribeEvent
    public static void registerJsonDeserializers(JsonDeserialisers.RegistryEvent event) {
        CactusThicknessLogic.REGISTRY.postRegistryEvent();
        MushroomShapeKit.REGISTRY.postRegistryEvent();
        CactusThicknessLogic.REGISTRY.lock();
        MushroomShapeKit.REGISTRY.lock();
        JsonDeserialisers.register(CactusThicknessLogic.class, (JsonDeserialiser)new RegistryEntryDeserialiser(CactusThicknessLogic.REGISTRY));
        JsonDeserialisers.register(MushroomShapeKit.class, (JsonDeserialiser)new RegistryEntryDeserialiser(MushroomShapeKit.REGISTRY));
        JsonDeserialisers.register(CactusBranchBlock.CactusThickness.class, (JsonDeserialiser)new EnumDeserialiser(CactusBranchBlock.CactusThickness.class));
    }
}

