/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeature.FruitGenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CactusFruitGenFeature
extends FruitGenFeature {
    public CactusFruitGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{FRUIT, QUANTITY, FRUITING_RADIUS, PLACE_CHANCE});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)new GenFeatureConfiguration((GenFeature)this).with(FRUIT, (Object)Fruit.NULL)).with(QUANTITY, (Object)2)).with(FRUITING_RADIUS, (Object)4)).with(PLACE_CHANCE, (Object)Float.valueOf(0.6f));
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return species.hasFruit((Fruit)configuration.get(FRUIT));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.endPoints().isEmpty()) {
            int qty = (Integer)configuration.get(QUANTITY);
            qty = (int)((float)qty * context.fruitProductionFactor().floatValue());
            for (int i = 0; i < qty; ++i) {
                BlockPos endPoint = (BlockPos)context.endPoints().get(context.random().m_188503_(context.endPoints().size()));
                this.placeDuringWorldGen(configuration, context.species(), context.level(), context.pos().m_7494_(), endPoint, context.bounds(), context.seasonValue());
            }
            return true;
        }
        return false;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() != 0) {
            return false;
        }
        LevelAccessor world = context.level();
        BlockState blockState = world.m_8055_(context.treePos());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        Fruit fruit = (Fruit)configuration.get(FRUIT);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural()) {
            BlockPos rootPos = context.pos();
            float fruitingFactor = fruit.seasonalFruitProductionFactor(context.levelContext(), rootPos);
            if (fruitingFactor > fruit.getMinProductionFactor() && fruitingFactor > world.m_213780_().m_188501_()) {
                FindEndsNode endFinder = new FindEndsNode();
                TreeHelper.startAnalysisFromRoot((LevelAccessor)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
                List endPoints = endFinder.getEnds();
                int qty = (Integer)configuration.get(QUANTITY);
                if (!endPoints.isEmpty()) {
                    for (int i = 0; i < qty; ++i) {
                        BlockPos endPoint = (BlockPos)endPoints.get(world.m_213780_().m_188503_(endPoints.size()));
                        this.place(configuration, context.species(), world, rootPos.m_7494_(), endPoint, SeasonHelper.getSeasonValue((LevelContext)context.levelContext(), (BlockPos)rootPos));
                    }
                }
            }
        }
        return true;
    }

    protected boolean shouldPlace(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos pos) {
        BlockState belowState = world.m_8055_(pos.m_7495_());
        return pos != BlockPos.f_121853_ && (CoordUtils.coordHashCode((BlockPos)pos, (int)0) & 6) == 0 && world.m_213780_().m_188501_() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue() && world.m_8055_(pos).m_247087_() && (!(belowState.m_60734_() instanceof CactusBranchBlock) || belowState.m_61143_(CactusBranchBlock.TRUNK_TYPE) == CactusBranchBlock.CactusThickness.BRANCH);
    }

    protected void place(GenFeatureConfiguration configuration, Species species, LevelAccessor world, BlockPos treePos, BlockPos branchPos, Float seasonValue) {
        BlockPos fruitPos = branchPos.m_7494_();
        if (this.shouldPlace(configuration, world, fruitPos)) {
            ((Fruit)configuration.get(FRUIT)).place(world, fruitPos, seasonValue);
        }
    }

    protected void placeDuringWorldGen(GenFeatureConfiguration configuration, Species species, LevelAccessor world, BlockPos treePos, BlockPos branchPos, SafeChunkBounds bounds, Float seasonValue) {
        BlockPos fruitPos = branchPos.m_7494_();
        if (this.shouldPlaceDuringWorldGen(configuration, world, fruitPos)) {
            ((Fruit)configuration.get(FRUIT)).placeDuringWorldGen(world, fruitPos, seasonValue);
        }
    }
}

