/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.tree;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.data.provider.BranchLoaderBuilder;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.event.BakedModelEventHandler;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CactusFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(CactusFamily::new);
    public static final String BRANCH_BOTTOM = "branch_bottom";

    public CactusFamily(ResourceLocation registryName) {
        super(registryName);
    }

    public MapColor getDefaultBranchMapColor() {
        return MapColor.f_283915_;
    }

    public SoundType getDefaultBranchSoundType() {
        return SoundType.f_56745_;
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        return new CactusBranchBlock(name, this.getProperties());
    }

    public int getPrimaryThickness() {
        return 5;
    }

    public int getSecondaryThickness() {
        return 4;
    }

    public BiFunction<BlockModelBuilder, ExistingFileHelper, BranchLoaderBuilder> getBranchLoaderConstructor() {
        return (parent, existingFileHelper) -> new BranchLoaderBuilder(BakedModelEventHandler.CACTUS, parent, existingFileHelper);
    }
}

