/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigModListScreen;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.SubMenuConfigScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.TextStencilElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class BaseConfigScreen
extends ConfigScreen {
    public static final Color COLOR_TITLE_A = new Color(-3760196).setImmutable();
    public static final Color COLOR_TITLE_B = new Color(-608069).setImmutable();
    public static final Color COLOR_TITLE_C = new Color(-263788).setImmutable();
    public static final FadableScreenElement DISABLED_RENDERER = (ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, AbstractSimiWidget.COLOR_DISABLED);
    private static final Map<String, UnaryOperator<BaseConfigScreen>> DEFAULTS = new HashMap<String, UnaryOperator<BaseConfigScreen>>();
    @Nullable
    BoxWidget clientConfigWidget;
    @Nullable
    BoxWidget commonConfigWidget;
    @Nullable
    BoxWidget serverConfigWidget;
    @Nullable
    BoxWidget goBack;
    @Nullable
    BoxWidget others;
    @Nullable
    BoxWidget title;
    @Nullable
    ForgeConfigSpec clientSpec;
    @Nullable
    ForgeConfigSpec commonSpec;
    @Nullable
    ForgeConfigSpec serverSpec;
    String clientButtonLabel = "Client Config";
    String commonButtonLabel = "Common Config";
    String serverButtonLabel = "Server Config";
    String modID;
    protected boolean returnOnClose;

    public static void setDefaultActionFor(String modID, UnaryOperator<BaseConfigScreen> transform) {
        DEFAULTS.put(modID, transform);
    }

    public BaseConfigScreen(@Nullable Screen parent, String modID) {
        super(parent);
        this.modID = modID;
        if (DEFAULTS.containsKey(modID)) {
            DEFAULTS.get(modID).apply(this);
        } else {
            this.searchForConfigSpecs();
        }
    }

    public BaseConfigScreen searchForConfigSpecs() {
        if (!ConfigHelper.hasAnyForgeConfig(this.modID)) {
            return this;
        }
        try {
            this.clientSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.CLIENT, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find ClientConfigSpec for mod: " + this.modID);
        }
        try {
            this.commonSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.COMMON, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find CommonConfigSpec for mod: " + this.modID);
        }
        try {
            this.serverSpec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.SERVER, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find ServerConfigSpec for mod: " + this.modID);
        }
        return this;
    }

    public BaseConfigScreen withSpecs(@Nullable ForgeConfigSpec client, @Nullable ForgeConfigSpec common, @Nullable ForgeConfigSpec server) {
        this.clientSpec = client;
        this.commonSpec = common;
        this.serverSpec = server;
        return this;
    }

    public BaseConfigScreen withButtonLabels(@Nullable String client, @Nullable String common, @Nullable String server) {
        if (client != null) {
            this.clientButtonLabel = client;
        }
        if (common != null) {
            this.commonButtonLabel = common;
        }
        if (server != null) {
            this.serverButtonLabel = server;
        }
        return this;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.returnOnClose = true;
        TextStencilElement clientText = new TextStencilElement(this.f_96547_, Component.m_237113_((String)this.clientButtonLabel)).centered(true, true);
        this.clientConfigWidget = (BoxWidget)new BoxWidget(this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 15 - 30, 200, 16).showingElement(clientText);
        this.m_142416_(this.clientConfigWidget);
        if (this.clientSpec != null) {
            this.clientConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.CLIENT, this.clientSpec)));
            clientText.withElementRenderer(BoxWidget.gradientFactory.apply(this.clientConfigWidget));
        } else {
            this.clientConfigWidget.f_93623_ = false;
            this.clientConfigWidget.updateGradientFromState();
            clientText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement commonText = new TextStencilElement(this.f_96547_, Component.m_237113_((String)this.commonButtonLabel)).centered(true, true);
        this.commonConfigWidget = (BoxWidget)new BoxWidget(this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 15, 200, 16).showingElement(commonText);
        this.m_142416_(this.commonConfigWidget);
        if (this.commonSpec != null) {
            this.commonConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.COMMON, this.commonSpec)));
            commonText.withElementRenderer(BoxWidget.gradientFactory.apply(this.commonConfigWidget));
        } else {
            this.commonConfigWidget.f_93623_ = false;
            this.commonConfigWidget.updateGradientFromState();
            commonText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement serverText = new TextStencilElement(this.f_96547_, Component.m_237113_((String)this.serverButtonLabel)).centered(true, true);
        this.serverConfigWidget = (BoxWidget)new BoxWidget(this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 15 + 30, 200, 16).showingElement(serverText);
        this.m_142416_(this.serverConfigWidget);
        if (this.serverSpec == null) {
            this.serverConfigWidget.f_93623_ = false;
            this.serverConfigWidget.updateGradientFromState();
            serverText.withElementRenderer(DISABLED_RENDERER);
        } else if (this.f_96541_.f_91073_ == null) {
            serverText.withElementRenderer(DISABLED_RENDERER);
            this.serverConfigWidget.getToolTip().add((Component)Component.m_237113_((String)"Stored individually per World"));
            this.serverConfigWidget.getToolTip().addAll(FontHelper.cutTextComponent((Component)Component.m_237113_((String)"Gameplay settings can only be accessed from the in-game menu after joining a World or Server."), FontHelper.Palette.ALL_GRAY));
        } else {
            this.serverConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.SERVER, this.serverSpec)));
            serverText.withElementRenderer(BoxWidget.gradientFactory.apply(this.serverConfigWidget));
        }
        TextStencilElement titleText = (TextStencilElement)new TextStencilElement(this.f_96547_, BaseConfigScreen.getModDisplayName(this.modID).orElse(this.modID.toLowerCase(Locale.ROOT))).centered(true, true).withElementRenderer((ms, w, h, alpha) -> {
            UIRenderHelper.angledGradient(ms, 0.0f, 0, h / 2, (float)h, (float)(w / 2), COLOR_TITLE_A, COLOR_TITLE_B);
            UIRenderHelper.angledGradient(ms, 0.0f, w / 2, h / 2, (float)h, (float)(w / 2), COLOR_TITLE_B, COLOR_TITLE_C);
        });
        int boxWidth = this.f_96543_ + 10;
        int boxHeight = 39;
        int boxPadding = 4;
        this.title = (BoxWidget)((ElementWidget)((ElementWidget)((ElementWidget)((BoxWidget)new BoxWidget(-5, this.f_96544_ / 2 - 110, boxWidth, boxHeight).setActive(false)).withBorderColors(AbstractSimiWidget.COLOR_IDLE)).withPadding(0.0f, boxPadding)).rescaleElement((float)boxWidth / 2.0f, (float)(boxHeight - 2 * boxPadding) / 2.0f)).showingElement((RenderElement)titleText.at(0.0f, 7.0f));
        this.m_142416_(this.title);
        ConfigScreen.modID = this.modID;
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.f_96543_ / 2 - 134, this.f_96544_ / 2, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> this.linkTo(this.parent));
        this.goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((Component)Component.m_237113_((String)"Go Back"));
        this.m_142416_(this.goBack);
        TextStencilElement othersText = new TextStencilElement(this.f_96547_, Component.m_237113_((String)"Access Configs of other Mods")).centered(true, true);
        this.others = (BoxWidget)new BoxWidget(this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 15 + 90, 200, 16).showingElement(othersText);
        othersText.withElementRenderer(BoxWidget.gradientFactory.apply(this.others));
        this.others.withCallback(() -> this.linkTo(new ConfigModListScreen(this)));
        this.m_142416_(this.others);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280137_(this.f_96547_, "Access Configs for Mod:", this.f_96543_ / 2, this.f_96544_ / 2 - 105, ((Color)UIRenderHelper.COLOR_TEXT_STRONG_ACCENT.getFirst()).getRGB());
    }

    private void linkTo(@Nullable Screen screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259) {
            this.linkTo(this.parent);
        }
        return false;
    }
}

