/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.data;

import java.util.Comparator;
import java.util.function.Function;
import net.createmod.catnip.data.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class LongAttached<V>
extends Pair<Long, V> {
    protected LongAttached(Long first, V second) {
        super(first, second);
    }

    public static <V> LongAttached<V> with(long number, V value) {
        return new LongAttached<V>(number, value);
    }

    public static <V> LongAttached<V> withZero(V value) {
        return new LongAttached<V>(0L, value);
    }

    public boolean isZero() {
        return (Long)this.first == 0L;
    }

    public boolean exceeds(long value) {
        return (Long)this.first > value;
    }

    public boolean isOrBelowZero() {
        return (Long)this.first <= 0L;
    }

    public void increment() {
        Long l = (Long)this.first;
        this.first = (Long)this.first + 1L;
    }

    public void decrement() {
        Long l = (Long)this.first;
        this.first = (Long)this.first - 1L;
    }

    public V getValue() {
        return (V)this.getSecond();
    }

    public CompoundTag serializeNBT(Function<V, CompoundTag> serializer) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Item", (Tag)serializer.apply(this.getValue()));
        nbt.m_128356_("Location", ((Long)this.getFirst()).longValue());
        return nbt;
    }

    public static Comparator<? super LongAttached<?>> comparator() {
        return (i1, i2) -> Long.compare((Long)i2.getFirst(), (Long)i1.getFirst());
    }

    public static <T> LongAttached<T> read(CompoundTag nbt, Function<CompoundTag, T> deserializer) {
        return LongAttached.with(nbt.m_128454_("Location"), deserializer.apply(nbt.m_128469_("Item")));
    }
}

