/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.ghostblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.ghostblock.GhostBlockParams;
import net.createmod.catnip.placement.PlacementClient;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    private static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, Vec3 var3, GhostBlockParams var4);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            ms.m_85836_();
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BlockState state = params.state;
            BakedModel model = dispatcher.m_110910_(state);
            BlockPos pos = params.pos;
            ms.m_85837_((double)pos.m_123341_() - camera.f_82479_, (double)pos.m_123342_() - camera.f_82480_, (double)pos.m_123343_() - camera.f_82481_);
            for (RenderType layer : CatnipClientServices.CLIENT_HOOKS.getRenderTypesForBlockModel(state, RandomSource.m_216335_((long)42L), null)) {
                VertexConsumer vb = buffer.getEarlyBuffer(layer);
                CatnipClientServices.CLIENT_HOOKS.renderVirtualBlockStateModel(dispatcher, ms, vb, state, model, 1.0f, 1.0f, 1.0f, layer);
            }
            ms.m_85849_();
        }
    }

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            ms.m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher dispatcher = mc.m_91289_();
            BakedModel model = dispatcher.m_110910_(params.state);
            RenderType layer = RenderType.m_110466_();
            VertexConsumer vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.m_85837_((double)pos.m_123341_() - camera.f_82479_, (double)pos.m_123342_() - camera.f_82480_, (double)pos.m_123343_() - camera.f_82481_);
            ms.m_85837_(0.5, 0.5, 0.5);
            ms.m_85841_(0.85f, 0.85f, 0.85f);
            ms.m_85837_(-0.5, -0.5, -0.5);
            float alpha = params.alphaSupplier.get().floatValue() * 0.75f * PlacementClient.getCurrentAlpha();
            this.renderModel(ms.m_85850_(), vb, params.state, model, 1.0f, 1.0f, 1.0f, alpha, LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)pos), OverlayTexture.f_118083_);
            ms.m_85849_();
        }

        public void renderModel(PoseStack.Pose pose, VertexConsumer consumer, @Nullable BlockState state, BakedModel model, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
            RandomSource random = RandomSource.m_216327_();
            for (Direction direction : Direction.values()) {
                random.m_188584_(42L);
                TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.m_213637_(state, direction, random), packedLight, packedOverlay);
            }
            random.m_188584_(42L);
            TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.m_213637_(state, null, random), packedLight, packedOverlay);
        }

        private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, float alpha, List<BakedQuad> quads, int packedLight, int packedOverlay) {
            for (BakedQuad quad : quads) {
                float f2;
                float f1;
                float f;
                if (quad.m_111304_()) {
                    f = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
                    f1 = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
                    f2 = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
                } else {
                    f = 1.0f;
                    f1 = 1.0f;
                    f2 = 1.0f;
                }
                CatnipClientServices.CLIENT_HOOKS.vertexConsumerPutBulkDataWithAlpha(consumer, pose, quad, f, f1, f2, alpha, packedLight, packedOverlay);
            }
        }
    }
}

