/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class UIRenderHelper {
    public static final Couple<Color> COLOR_TEXT = Couple.create(new Color(-1118482), new Color(-6052957)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_DARKER = Couple.create(new Color(-6052957), new Color(-8355712)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_ACCENT = Couple.create(new Color(-2232577), new Color(-6246208)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_STRONG_ACCENT = Couple.create(new Color(-7686442), new Color(-9530709)).map(Color::setImmutable);
    public static final Color COLOR_STREAK = new Color(0x101010, false).setImmutable();
    @Nullable
    public static CustomRenderTarget framebuffer;

    public static void init() {
        RenderSystem.recordRenderCall(() -> {
            Window mainWindow = Minecraft.m_91087_().m_91268_();
            framebuffer = CustomRenderTarget.create(mainWindow);
        });
    }

    public static void updateWindowSize(Window mainWindow) {
        if (framebuffer != null) {
            framebuffer.m_83941_(mainWindow.m_85441_(), mainWindow.m_85442_(), Minecraft.f_91002_);
        }
    }

    public static void drawFramebuffer(PoseStack poseStack, float alpha) {
        if (framebuffer != null) {
            framebuffer.renderWithAlpha(poseStack, alpha);
        }
    }

    public static void swapAndBlitColor(RenderTarget src, RenderTarget dst) {
        GlStateManager._glBindFramebuffer((int)36008, (int)src.f_83920_);
        GlStateManager._glBindFramebuffer((int)36009, (int)dst.f_83920_);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)src.f_83917_, (int)src.f_83918_, (int)0, (int)0, (int)dst.f_83917_, (int)dst.f_83918_, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36160, (int)dst.f_83920_);
    }

    public static void streak(GuiGraphics graphics, float angle, int x, int y, int breadth, int length) {
        UIRenderHelper.streak(graphics, angle, x, y, breadth, length, COLOR_STREAK);
    }

    public static void streak(GuiGraphics graphics, float angle, int x, int y, int breadth, int length, Color c) {
        Color color = c.copy().setImmutable();
        Color c1 = color.scaleAlpha(0.625f);
        Color c2 = color.scaleAlpha(0.5f);
        Color c3 = color.scaleAlpha(0.0625f);
        Color c4 = color.scaleAlpha(0.0f);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angle - 90.0f));
        UIRenderHelper.streak(graphics, breadth / 2, length, c1, c2, c3, c4);
        poseStack.m_85849_();
    }

    private static void streak(GuiGraphics graphics, int width, int height, Color c1, Color c2, Color c3, Color c4) {
        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            return;
        }
        double split1 = 0.5;
        double split2 = 0.75;
        graphics.m_280024_(-width, 0, width, (int)(split1 * (double)height), c1.getRGB(), c2.getRGB());
        graphics.m_280024_(-width, (int)(split1 * (double)height), width, (int)(split2 * (double)height), c2.getRGB(), c3.getRGB());
        graphics.m_280024_(-width, (int)(split2 * (double)height), width, height, c3.getRGB(), c4.getRGB());
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, float breadth, float length, Couple<Color> c) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, 0, breadth, length, c);
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, int z, float breadth, float length, Couple<Color> c) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, z, breadth, length, (Color)c.getFirst(), (Color)c.getSecond());
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, float breadth, float length, Color color1, Color color2) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, 0, breadth, length, color1, color2);
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, int z, float breadth, float length, Color startColor, Color endColor) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, (float)z);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angle - 90.0f));
        float w = breadth / 2.0f;
        UIRenderHelper.drawGradientRect(poseStack.m_85850_().m_252922_(), 0, -w, 0.0f, w, length, startColor, endColor);
        poseStack.m_85849_();
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, float left, float top, float right, float bottom, Color startColor, Color endColor) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(mat, right, top, (float)zLevel).m_6122_(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).m_5752_();
        buffer.m_252986_(mat, left, top, (float)zLevel).m_6122_(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).m_5752_();
        buffer.m_252986_(mat, left, bottom, (float)zLevel).m_6122_(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).m_5752_();
        buffer.m_252986_(mat, right, bottom, (float)zLevel).m_6122_(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void breadcrumbArrow(GuiGraphics graphics, int x, int y, int z, int width, int height, int indent, Couple<Color> colors) {
        UIRenderHelper.breadcrumbArrow(graphics, x, y, z, width, height, indent, (Color)colors.getFirst(), (Color)colors.getSecond());
    }

    public static void breadcrumbArrow(GuiGraphics graphics, int x, int y, int z, int width, int height, int indent, Color startColor, Color endColor) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x - indent), (float)y, (float)z);
        UIRenderHelper.breadcrumbArrow(graphics, width, height, indent, startColor, endColor);
        poseStack.m_85849_();
    }

    private static void breadcrumbArrow(GuiGraphics graphics, int width, int height, int indent, Color c1, Color c2) {
        float x0 = 0.0f;
        float x1 = indent;
        float x2 = width;
        float x3 = indent + width;
        float y0 = 0.0f;
        float y1 = (float)height / 2.0f;
        float y2 = height;
        indent = Math.abs(indent);
        width = Math.abs(width);
        Color fc1 = Color.mixColors(c1, c2, 0.0f);
        Color fc2 = Color.mixColors(c1, c2, (float)indent / ((float)width + 2.0f * (float)indent));
        Color fc3 = Color.mixColors(c1, c2, (float)(indent + width) / ((float)width + 2.0f * (float)indent));
        Color fc4 = Color.mixColors(c1, c2, 1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        Matrix4f model = graphics.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(model, x0, y1, 0.0f).m_6122_(fc1.getRed(), fc1.getGreen(), fc1.getBlue(), fc1.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x1, y0, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x1, y1, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x0, y1, 0.0f).m_6122_(fc1.getRed(), fc1.getGreen(), fc1.getBlue(), fc1.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x1, y1, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x1, y2, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x1, y2, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x1, y0, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x2, y0, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x1, y2, 0.0f).m_6122_(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x2, y0, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x2, y2, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x2, y1, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x2, y0, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x3, y0, 0.0f).m_6122_(fc4.getRed(), fc4.getGreen(), fc4.getBlue(), fc4.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x2, y2, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x2, y1, 0.0f).m_6122_(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha()).m_5752_();
        bufferbuilder.m_252986_(model, x3, y2, 0.0f).m_6122_(fc4.getRed(), fc4.getGreen(), fc4.getBlue(), fc4.getAlpha()).m_5752_();
        tessellator.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static void drawRadialSector(GuiGraphics graphics, float innerRadius, float outerRadius, float startAngle, float arcAngle, Color innerColor, Color outerColor) {
        List<Point2D> innerPoints = UIRenderHelper.getPointsForCircleArc(innerRadius, startAngle, arcAngle);
        List<Point2D> outerPoints = UIRenderHelper.getPointsForCircleArc(outerRadius, startAngle, arcAngle);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        Matrix3f n = graphics.m_280168_().m_85850_().m_252943_();
        for (int i = 0; i < innerPoints.size(); ++i) {
            Point2D point = outerPoints.get(i);
            builder.m_252986_(pose, (float)point.getX(), (float)point.getY(), 0.0f).m_193479_(outerColor.getRGB()).m_5752_();
            point = innerPoints.get(i);
            builder.m_252986_(pose, (float)point.getX(), (float)point.getY(), 0.0f).m_193479_(innerColor.getRGB()).m_5752_();
        }
        Tesselator.m_85913_().m_85914_();
        RenderSystem.disableBlend();
    }

    private static List<Point2D> getPointsForCircleArc(float radius, float startAngle, float arcAngle) {
        int segmentCount = Math.abs(arcAngle) <= 90.0f ? 16 : 32;
        ArrayList<Point2D> points = new ArrayList<Point2D>(segmentCount);
        float theta = (float)Math.PI / 180 * arcAngle / (float)(segmentCount - 1);
        float t = (float)Math.PI / 180 * startAngle;
        for (int i = 0; i < segmentCount; ++i) {
            points.add(new Point2D.Float((float)((double)radius * Math.cos(t)), (float)((double)radius * Math.sin(t))));
            t += theta;
        }
        return points;
    }

    public static void drawColoredTexture(GuiGraphics graphics, Color c, int x, int y, int tex_left, int tex_top, int width, int height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, y, 0, tex_left, tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(GuiGraphics graphics, Color c, int x, int y, int z, float tex_left, float tex_top, int width, int height, int sheet_width, int sheet_height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, x + width, y, y + height, z, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    public static void drawStretched(GuiGraphics graphics, int left, int top, int w, int h, int z, TextureSheetSegment tex) {
        tex.bind();
        UIRenderHelper.drawTexturedQuad(graphics.m_280168_().m_85850_().m_252922_(), Color.WHITE, left, left + w, top, top + h, z, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + tex.getWidth()) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + tex.getHeight()) / 256.0f);
    }

    public static void drawCropped(GuiGraphics graphics, int left, int top, int w, int h, int z, TextureSheetSegment tex) {
        tex.bind();
        UIRenderHelper.drawTexturedQuad(graphics.m_280168_().m_85850_().m_252922_(), Color.WHITE, left, left + w, top, top + h, z, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + w) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + h) / 256.0f);
    }

    private static void drawColoredTexture(GuiGraphics graphics, Color c, int left, int right, int top, int bot, int z, int tex_width, int tex_height, float tex_left, float tex_top, int sheet_width, int sheet_height) {
        UIRenderHelper.drawTexturedQuad(graphics.m_280168_().m_85850_().m_252922_(), c, left, right, top, bot, z, (tex_left + 0.0f) / (float)sheet_width, (tex_left + (float)tex_width) / (float)sheet_width, (tex_top + 0.0f) / (float)sheet_height, (tex_top + (float)tex_height) / (float)sheet_height);
    }

    private static void drawTexturedQuad(Matrix4f m, Color c, int left, int right, int top, int bot, int z, float u1, float u2, float v1, float v2) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172814_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(m, (float)left, (float)bot, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u1, v2).m_5752_();
        bufferbuilder.m_252986_(m, (float)right, (float)bot, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u2, v2).m_5752_();
        bufferbuilder.m_252986_(m, (float)right, (float)top, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u2, v1).m_5752_();
        bufferbuilder.m_252986_(m, (float)left, (float)top, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u1, v1).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void flipForGuiRender(PoseStack poseStack) {
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
    }

    public static class CustomRenderTarget
    extends RenderTarget {
        public CustomRenderTarget(boolean useDepth) {
            super(useDepth);
        }

        public static CustomRenderTarget create(Window mainWindow) {
            CustomRenderTarget framebuffer = new CustomRenderTarget(true);
            framebuffer.m_83941_(mainWindow.m_85441_(), mainWindow.m_85442_(), Minecraft.f_91002_);
            framebuffer.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            CatnipClientServices.CLIENT_HOOKS.enableStencilBuffer(framebuffer);
            return framebuffer;
        }

        public void renderWithAlpha(PoseStack poseStack, float alpha) {
            Window window = Minecraft.m_91087_().m_91268_();
            float guiScaledWidth = window.m_85445_();
            float guiScaledHeight = window.m_85446_();
            float vx = guiScaledWidth;
            float vy = guiScaledHeight;
            float tx = (float)this.f_83917_ / (float)this.f_83915_;
            float ty = (float)this.f_83918_ / (float)this.f_83916_;
            RenderSystem.disableDepthTest();
            Minecraft minecraft = Minecraft.m_91087_();
            ShaderInstance shaderinstance = minecraft.f_91063_.f_172635_;
            shaderinstance.m_173350_("DiffuseSampler", (Object)this.f_83923_);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
            if (shaderinstance.f_173308_ != null) {
                shaderinstance.f_173308_.m_5679_(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
            }
            if (shaderinstance.f_173309_ != null) {
                shaderinstance.f_173309_.m_5679_(matrix4f);
            }
            shaderinstance.m_173363_();
            Tesselator tesselator = RenderSystem.renderThreadTesselator();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_(0.0, (double)vy, 0.0).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            bufferbuilder.m_5483_((double)vx, (double)vy, 0.0).m_7421_(tx, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            bufferbuilder.m_5483_((double)vx, 0.0, 0.0).m_7421_(tx, ty).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, ty).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
            BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            shaderinstance.m_173362_();
            RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
        }
    }
}

