/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.math;

import net.minecraft.core.Direction;

public class DirectionHelper {
    public static Direction rotateAround(Direction dir, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (dir != Direction.WEST && dir != Direction.EAST) {
                    return DirectionHelper.rotateX(dir);
                }
                return dir;
            }
            case Y: {
                if (dir != Direction.UP && dir != Direction.DOWN) {
                    return dir.m_122427_();
                }
                return dir;
            }
            case Z: {
                if (dir != Direction.NORTH && dir != Direction.SOUTH) {
                    return DirectionHelper.rotateZ(dir);
                }
                return dir;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    public static Direction rotateX(Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Direction.DOWN;
            case Direction.EAST, Direction.WEST -> throw new IllegalStateException("Unable to get X-rotated facing of " + dir);
            case Direction.SOUTH -> Direction.UP;
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
        };
    }

    public static Direction rotateZ(Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> Direction.DOWN;
            case Direction.NORTH, Direction.SOUTH -> throw new IllegalStateException("Unable to get Z-rotated facing of " + dir);
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.EAST;
            case Direction.DOWN -> Direction.WEST;
        };
    }

    public static Direction getPositivePerpendicular(Direction.Axis horizontalAxis) {
        return horizontalAxis == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
    }
}

