/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.net;

import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.net.ClientboundPacket;
import net.createmod.ponder.Ponder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.config.ModConfig;

public class ClientboundConfigPacket
implements ClientboundPacket {
    public static final ResourceLocation ID = Ponder.asResource("config_packet");
    private final String path;
    private final String value;

    public ClientboundConfigPacket(String path, String value) {
        this.path = path;
        this.value = value;
    }

    public ClientboundConfigPacket(FriendlyByteBuf buffer) {
        this.path = buffer.m_130277_();
        this.value = buffer.m_130277_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.path);
        buffer.m_130070_(this.value);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static class Handler {
        public static void handle(ClientboundConfigPacket packet) {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            Minecraft.m_91087_().execute(() -> {
                ConfigHelper.ConfigPath path;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                try {
                    path = ConfigHelper.ConfigPath.parse(packet.path);
                }
                catch (IllegalArgumentException e) {
                    player.m_5661_((Component)Ponder.lang().text(e.getMessage()).component(), false);
                    return;
                }
                if (path.getType() != ModConfig.Type.CLIENT) {
                    Ponder.LOGGER.warn("Received type-mismatched config packet on client");
                    return;
                }
                try {
                    ConfigHelper.setConfigValue(path, packet.value);
                    player.m_5661_((Component)Component.m_237113_((String)"Great Success!"), false);
                }
                catch (ConfigHelper.InvalidValueException e) {
                    player.m_5661_((Component)Component.m_237113_((String)"Config could not be set the the specified value!"), false);
                }
                catch (Exception e) {
                    player.m_5661_((Component)Component.m_237113_((String)"Something went wrong while trying to set config value. Check the client logs for more information"), false);
                    Ponder.LOGGER.warn("Exception during client-side config value set:", (Throwable)e);
                }
            });
        }
    }
}

