/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.api.element;

import com.mojang.blaze3d.platform.Window;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class ParrotPose {
    private static final Parrot.Variant[] VARIANTS = new Parrot.Variant[]{Parrot.Variant.RED_BLUE, Parrot.Variant.GREEN, Parrot.Variant.YELLOW_BLUE, Parrot.Variant.GRAY};

    public abstract void tick(PonderScene var1, Parrot var2, Vec3 var3);

    public Parrot create(PonderLevel world) {
        Parrot entity = new Parrot(EntityType.f_20508_, (Level)world);
        int nextInt = Ponder.RANDOM.nextInt(VARIANTS.length);
        entity.m_28464_(VARIANTS[nextInt]);
        return entity;
    }

    public static class FaceCursorPose
    extends FaceVecPose {
        @Override
        protected Vec3 getFacedVec(PonderScene scene) {
            Minecraft minecraft = Minecraft.m_91087_();
            Window w = minecraft.m_91268_();
            double mouseX = minecraft.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
            double mouseY = minecraft.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
            return scene.getTransform().screenToScene(mouseX, mouseY, 300, 0.0f);
        }
    }

    public static class FacePointOfInterestPose
    extends FaceVecPose {
        @Override
        protected Vec3 getFacedVec(PonderScene scene) {
            return scene.getPointOfInterest();
        }
    }

    public static abstract class FaceVecPose
    extends ParrotPose {
        @Override
        public void tick(PonderScene scene, Parrot entity, Vec3 location) {
            Vec3 p_200602_2_ = this.getFacedVec(scene);
            Vec3 Vector3d2 = location.m_82549_(entity.m_20299_(0.0f));
            double d0 = p_200602_2_.f_82479_ - Vector3d2.f_82479_;
            double d1 = p_200602_2_.f_82480_ - Vector3d2.f_82480_;
            double d2 = p_200602_2_.f_82481_ - Vector3d2.f_82481_;
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            float targetPitch = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
            float targetYaw = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875)) + 90.0f));
            entity.m_146926_(AngleHelper.angleLerp(0.4f, entity.m_146909_(), targetPitch));
            entity.m_146922_(AngleHelper.angleLerp(0.4f, entity.m_146908_(), targetYaw));
        }

        protected abstract Vec3 getFacedVec(PonderScene var1);
    }

    public static class FlappyPose
    extends ParrotPose {
        @Override
        public void tick(PonderScene scene, Parrot entity, Vec3 location) {
            double length = entity.m_20182_().m_82492_(entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82553_();
            entity.m_6853_(false);
            double phase = Math.min(length * 15.0, 8.0);
            float f = (float)((double)(PonderUI.ponderTicks % 100) * phase);
            entity.f_29351_ = Mth.m_14031_((float)f) + 1.0f;
            if (length == 0.0) {
                entity.f_29351_ = 0.0f;
            }
        }
    }

    public static class DancePose
    extends ParrotPose {
        @Override
        public Parrot create(PonderLevel world) {
            Parrot entity = super.create(world);
            entity.m_6818_(BlockPos.f_121853_, true);
            return entity;
        }

        @Override
        public void tick(PonderScene scene, Parrot entity, Vec3 location) {
            entity.f_19859_ = entity.m_146908_();
            entity.m_146922_(entity.m_146908_() - 2.0f);
        }
    }
}

