/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.ShadedBlockSbbBuilder;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.element.WorldSectionElement;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.AnimatedSceneElementBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class WorldSectionElementImpl
extends AnimatedSceneElementBase
implements WorldSectionElement {
    public static final SuperByteBufferCache.Compartment<Pair<Integer, Integer>> PONDER_WORLD_SECTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    @Nullable
    List<BlockEntity> renderedBlockEntities;
    @Nullable
    List<Pair<BlockEntity, Consumer<Level>>> tickableBlockEntities;
    @Nullable
    Selection section;
    boolean redraw;
    Vec3 prevAnimatedOffset = Vec3.f_82478_;
    Vec3 animatedOffset = Vec3.f_82478_;
    Vec3 prevAnimatedRotation = Vec3.f_82478_;
    Vec3 animatedRotation = Vec3.f_82478_;
    Vec3 centerOfRotation = Vec3.f_82478_;
    @Nullable
    Vec3 stabilizationAnchor = null;
    @Nullable
    BlockPos selectedBlock;

    public WorldSectionElementImpl() {
    }

    public WorldSectionElementImpl(Selection section) {
        this.section = section.copy();
        this.centerOfRotation = section.getCenter();
    }

    @Override
    public void mergeOnto(WorldSectionElement other) {
        this.setVisible(false);
        if (other.isEmpty()) {
            other.set(this.section);
        } else {
            other.add(this.section);
        }
    }

    @Override
    public void set(Selection selection) {
        this.applyNewSelection(selection.copy());
    }

    @Override
    public void add(Selection toAdd) {
        this.applyNewSelection(this.section.add(toAdd));
    }

    @Override
    public void erase(Selection toErase) {
        this.applyNewSelection(this.section.substract(toErase));
    }

    private void applyNewSelection(Selection selection) {
        this.section = selection;
        this.queueRedraw();
    }

    @Override
    public void setCenterOfRotation(Vec3 center) {
        this.centerOfRotation = center;
    }

    @Override
    public void stabilizeRotation(Vec3 anchor) {
        this.stabilizationAnchor = anchor;
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.resetAnimatedTransform();
        this.resetSelectedBlock();
    }

    @Override
    public void selectBlock(BlockPos pos) {
        this.selectedBlock = pos;
    }

    @Override
    public void resetSelectedBlock() {
        this.selectedBlock = null;
    }

    public void resetAnimatedTransform() {
        this.prevAnimatedOffset = Vec3.f_82478_;
        this.animatedOffset = Vec3.f_82478_;
        this.prevAnimatedRotation = Vec3.f_82478_;
        this.animatedRotation = Vec3.f_82478_;
    }

    @Override
    public void queueRedraw() {
        this.redraw = true;
    }

    @Override
    public boolean isEmpty() {
        return this.section == null;
    }

    @Override
    public void setEmpty() {
        this.section = null;
    }

    @Override
    public void setAnimatedRotation(Vec3 eulerAngles, boolean force) {
        this.animatedRotation = eulerAngles;
        if (force) {
            this.prevAnimatedRotation = this.animatedRotation;
        }
    }

    @Override
    public Vec3 getAnimatedRotation() {
        return this.animatedRotation;
    }

    @Override
    public void setAnimatedOffset(Vec3 offset, boolean force) {
        this.animatedOffset = offset;
        if (force) {
            this.prevAnimatedOffset = this.animatedOffset;
        }
    }

    @Override
    public Vec3 getAnimatedOffset() {
        return this.animatedOffset;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.isEmpty();
    }

    @Override
    public Pair<Vec3, BlockHitResult> rayTrace(PonderLevel world, Vec3 source, Vec3 target) {
        world.setMask(this.section);
        Vec3 transformedTarget = this.reverseTransformVec(target);
        BlockHitResult rayTraceBlocks = world.m_45547_(new ClipContext(this.reverseTransformVec(source), transformedTarget, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
        world.clearMask();
        double t = rayTraceBlocks.m_82450_().m_82546_(transformedTarget).m_82556_() / source.m_82546_(target).m_82556_();
        Vec3 actualHit = VecHelper.lerp((float)t, target, source);
        return Pair.of(actualHit, rayTraceBlocks);
    }

    private Vec3 reverseTransformVec(Vec3 in) {
        float pt = AnimationTickHolder.getPartialTicks();
        in = in.m_82546_(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)Vec3.f_82478_) || !this.prevAnimatedRotation.equals((Object)Vec3.f_82478_)) {
            double rotX = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82479_, (double)this.animatedRotation.f_82479_);
            double rotZ = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82481_, (double)this.animatedRotation.f_82481_);
            double rotY = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82480_, (double)this.animatedRotation.f_82480_);
            in = in.m_82546_(this.centerOfRotation);
            in = VecHelper.rotate(in, -rotX, Direction.Axis.X);
            in = VecHelper.rotate(in, -rotZ, Direction.Axis.Z);
            in = VecHelper.rotate(in, -rotY, Direction.Axis.Y);
            in = in.m_82549_(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                in = in.m_82546_(this.stabilizationAnchor);
                in = VecHelper.rotate(in, rotX, Direction.Axis.X);
                in = VecHelper.rotate(in, rotZ, Direction.Axis.Z);
                in = VecHelper.rotate(in, rotY, Direction.Axis.Y);
                in = in.m_82549_(this.stabilizationAnchor);
            }
        }
        return in;
    }

    public void transformMS(PoseStack ms, float pt) {
        Vec3 vec = VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset);
        ms.m_85837_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        if (!this.animatedRotation.equals((Object)Vec3.f_82478_) || !this.prevAnimatedRotation.equals((Object)Vec3.f_82478_)) {
            double rotX = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82479_, (double)this.animatedRotation.f_82479_);
            double rotZ = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82481_, (double)this.animatedRotation.f_82481_);
            double rotY = Mth.m_14139_((double)pt, (double)this.prevAnimatedRotation.f_82480_, (double)this.animatedRotation.f_82480_);
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(this.centerOfRotation)).rotateXDegrees((float)rotX)).rotateYDegrees((float)rotY)).rotateZDegrees((float)rotZ)).translateBack(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(this.stabilizationAnchor)).rotateXDegrees((float)(-rotX))).rotateYDegrees((float)(-rotY))).rotateZDegrees((float)(-rotZ))).translateBack(this.stabilizationAnchor);
            }
        }
    }

    @Override
    public void tick(PonderScene scene) {
        this.prevAnimatedOffset = this.animatedOffset;
        this.prevAnimatedRotation = this.animatedRotation;
        if (!this.isVisible()) {
            return;
        }
        this.loadBEsIfMissing(scene.getWorld());
        this.renderedBlockEntities.removeIf(be -> scene.getWorld().m_7702_(be.m_58899_()) != be);
        this.tickableBlockEntities.removeIf(be -> scene.getWorld().m_7702_(((BlockEntity)be.getFirst()).m_58899_()) != be.getFirst());
        this.tickableBlockEntities.forEach(be -> ((Consumer)be.getSecond()).accept(scene.getWorld()));
    }

    @Override
    public void whileSkipping(PonderScene scene) {
        if (this.redraw) {
            this.renderedBlockEntities = null;
            this.tickableBlockEntities = null;
        }
        this.redraw = false;
    }

    protected void loadBEsIfMissing(PonderLevel world) {
        if (this.renderedBlockEntities != null) {
            return;
        }
        this.tickableBlockEntities = new ArrayList<Pair<BlockEntity, Consumer<Level>>>();
        this.renderedBlockEntities = new ArrayList<BlockEntity>();
        this.section.forEach(pos -> {
            BlockEntity blockEntity = world.m_7702_((BlockPos)pos);
            BlockState blockState = world.m_8055_((BlockPos)pos);
            Block block = blockState.m_60734_();
            if (blockEntity == null) {
                return;
            }
            if (!(block instanceof EntityBlock)) {
                return;
            }
            blockEntity.m_155250_(world.m_8055_((BlockPos)pos));
            BlockEntityTicker ticker = ((EntityBlock)block).m_142354_((Level)world, blockState, blockEntity.m_58903_());
            if (ticker != null) {
                this.addTicker(blockEntity, ticker);
            }
            this.renderedBlockEntities.add(blockEntity);
        });
    }

    private <T extends BlockEntity> void addTicker(T blockEntity, BlockEntityTicker<?> ticker) {
        this.tickableBlockEntities.add(Pair.of(blockEntity, w -> ticker.m_155252_(w, blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity)));
    }

    @Override
    public void renderFirst(PonderLevel world, MultiBufferSource buffer, GuiGraphics graphics, float fade, float pt) {
        PoseStack poseStack = graphics.m_280168_();
        int light = -1;
        if (fade != 1.0f) {
            light = (int)Mth.m_14179_((float)fade, (float)5.0f, (float)15.0f);
        }
        if (this.redraw) {
            this.renderedBlockEntities = null;
            this.tickableBlockEntities = null;
        }
        poseStack.m_85836_();
        this.transformMS(poseStack, pt);
        world.pushFakeLight(light);
        this.renderBlockEntities(world, poseStack, buffer, pt);
        world.popLight();
        Map<BlockPos, Integer> blockBreakingProgressions = world.getBlockBreakingProgressions();
        PoseStack overlayMS = null;
        for (Map.Entry<BlockPos, Integer> entry : blockBreakingProgressions.entrySet()) {
            BlockPos pos = entry.getKey();
            if (!this.section.test(pos)) continue;
            if (overlayMS == null) {
                overlayMS = new PoseStack();
                overlayMS.m_85850_().m_252922_().set((Matrix4fc)poseStack.m_85850_().m_252922_());
                overlayMS.m_85850_().m_252943_().set((Matrix3fc)poseStack.m_85850_().m_252943_());
            }
            SheetedDecalTextureGenerator builder = new SheetedDecalTextureGenerator(buffer.m_6299_((RenderType)ModelBakery.f_119229_.get(entry.getValue())), overlayMS.m_85850_().m_252922_(), overlayMS.m_85850_().m_252943_(), 1.0f);
            poseStack.m_85836_();
            poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            Minecraft.m_91087_().m_91289_().m_110918_(world.m_8055_(pos), pos, (BlockAndTintGetter)world, poseStack, (VertexConsumer)builder);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    @Override
    protected void renderLayer(PonderLevel world, MultiBufferSource buffer, RenderType type, GuiGraphics graphics, float fade, float pt) {
        SuperByteBuffer structureBuffer;
        PoseStack poseStack = graphics.m_280168_();
        SuperByteBufferCache bufferCache = SuperByteBufferCache.getInstance();
        int code = this.hashCode() ^ world.hashCode();
        Pair<Integer, Integer> key = Pair.of(code, RenderType.m_110506_().indexOf(type));
        if (this.redraw) {
            bufferCache.invalidate(PONDER_WORLD_SECTION, key);
        }
        if ((structureBuffer = bufferCache.get(PONDER_WORLD_SECTION, key, () -> this.buildStructureBuffer(world, type))).isEmpty()) {
            return;
        }
        this.transformMS(structureBuffer.getTransforms(), pt);
        int light = this.lightCoordsFromFade(fade);
        structureBuffer.light(light).renderInto(poseStack, buffer.m_6299_(type));
    }

    @Override
    protected void renderLast(PonderLevel world, MultiBufferSource buffer, GuiGraphics graphics, float fade, float pt) {
        PoseStack poseStack = graphics.m_280168_();
        this.redraw = false;
        if (this.selectedBlock == null) {
            return;
        }
        BlockState blockState = world.m_8055_(this.selectedBlock);
        if (blockState.m_60795_()) {
            return;
        }
        VoxelShape shape = blockState.m_60651_((BlockGetter)world, this.selectedBlock, CollisionContext.m_82750_((Entity)Minecraft.m_91087_().f_91074_));
        if (shape.m_83281_()) {
            return;
        }
        poseStack.m_85836_();
        this.transformMS(poseStack, pt);
        poseStack.m_252880_((float)this.selectedBlock.m_123341_(), (float)this.selectedBlock.m_123342_(), (float)this.selectedBlock.m_123343_());
        AABBOutline aabbOutline = new AABBOutline(shape.m_83215_());
        aabbOutline.getParams().lineWidth(0.015625f).colored(0xEFEFEF).disableLineNormals();
        aabbOutline.render(poseStack, (SuperRenderTypeBuffer)buffer, Vec3.f_82478_, pt);
        poseStack.m_85849_();
    }

    private void renderBlockEntities(PonderLevel world, PoseStack ms, MultiBufferSource buffer, float pt) {
        this.loadBEsIfMissing(world);
        Iterator<BlockEntity> iterator = this.renderedBlockEntities.iterator();
        while (iterator.hasNext()) {
            BlockEntity tile = iterator.next();
            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(tile);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            BlockPos pos = tile.m_58899_();
            ms.m_85836_();
            ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            try {
                renderer.m_6922_(tile, pt, ms, buffer, LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)pos), OverlayTexture.f_118083_);
            }
            catch (Exception e) {
                iterator.remove();
                String message = "BlockEntity " + CatnipServices.REGISTRIES.getKeyOrThrow(tile.m_58903_()).toString() + " could not be rendered virtually.";
                Ponder.LOGGER.error(message, (Throwable)e);
            }
            ms.m_85849_();
        }
    }

    private SuperByteBuffer buildStructureBuffer(PonderLevel world, RenderType layer) {
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.poseStack;
        RandomSource random = objects.random;
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        world.setMask(this.section);
        world.pushFakeLight(0);
        ModelBlockRenderer.m_111000_();
        this.section.forEach(pos -> {
            BlockState state = world.m_8055_((BlockPos)pos);
            FluidState fluidState = world.m_6425_((BlockPos)pos);
            poseStack.m_85836_();
            poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            if (state.m_60799_() == RenderShape.MODEL) {
                BlockEntity blockEntity = world.m_7702_((BlockPos)pos);
                BakedModel model = dispatcher.m_110910_(state);
                long seed = state.m_60726_(pos);
                random.m_188584_(seed);
                if (CatnipClientServices.CLIENT_HOOKS.doesBlockModelContainRenderType(layer, state, random, blockEntity)) {
                    CatnipClientServices.CLIENT_HOOKS.tesselateBlockVirtual(world, dispatcher, model, state, (BlockPos)pos, poseStack, sbbBuilder, true, random, seed, OverlayTexture.f_118083_, layer);
                }
            }
            if (!fluidState.m_76178_() && ItemBlockRenderTypes.m_109287_((FluidState)fluidState) == layer) {
                dispatcher.m_234363_(pos, (BlockAndTintGetter)world, (VertexConsumer)sbbBuilder.unwrap(true), state, fluidState);
            }
            poseStack.m_85849_();
        });
        ModelBlockRenderer.m_111077_();
        world.popLight();
        world.clearMask();
        return sbbBuilder.end();
    }

    private static class ThreadLocalObjects {
        public final PoseStack poseStack = new PoseStack();
        public final RandomSource random = RandomSource.m_216343_();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }
}

