/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.instruction;

import java.util.function.UnaryOperator;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.WorldModifyInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityDataInstruction
extends WorldModifyInstruction {
    private boolean redraw;
    private UnaryOperator<CompoundTag> data;
    private Class<? extends BlockEntity> type;

    public BlockEntityDataInstruction(Selection selection, Class<? extends BlockEntity> type, UnaryOperator<CompoundTag> data, boolean redraw) {
        super(selection);
        this.type = type;
        this.data = data;
        this.redraw = redraw;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderLevel world = scene.getWorld();
        selection.forEach(pos -> {
            if (!world.getBounds().m_71051_((Vec3i)pos)) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_((BlockPos)pos);
            if (!this.type.isInstance(blockEntity)) {
                return;
            }
            CompoundTag apply = (CompoundTag)this.data.apply(blockEntity.m_187480_());
            blockEntity.m_142466_(apply);
        });
    }

    @Override
    protected boolean needsRedraw() {
        return this.redraw;
    }
}

