/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.instruction;

import net.createmod.ponder.api.element.AnimatedSceneElement;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.PonderElement;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.ElementLinkImpl;
import net.createmod.ponder.foundation.instruction.TickingInstruction;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public abstract class FadeIntoSceneInstruction<T extends AnimatedSceneElement>
extends TickingInstruction {
    protected Direction fadeInFrom;
    protected T element;
    private ElementLink<T> elementLink;

    public FadeIntoSceneInstruction(int fadeInTicks, Direction fadeInFrom, T element) {
        super(false, fadeInTicks);
        this.fadeInFrom = fadeInFrom;
        this.element = element;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        scene.addElement((PonderElement)this.element);
        this.element.setVisible(true);
        this.element.setFade(0.0f);
        this.element.setFadeVec(this.fadeInFrom == null ? Vec3.f_82478_ : Vec3.m_82528_((Vec3i)this.fadeInFrom.m_122436_()).m_82490_(0.5));
        if (this.elementLink != null) {
            scene.linkElement(this.element, this.elementLink);
        }
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        float fade = this.totalTicks == 0 ? 1.0f : (float)this.remainingTicks / (float)this.totalTicks;
        this.element.setFade(1.0f - fade * fade);
        if (this.remainingTicks == 0) {
            if (this.totalTicks == 0) {
                this.element.setFade(1.0f);
            }
            this.element.setFade(1.0f);
        }
    }

    public ElementLink<T> createLink(PonderScene scene) {
        this.elementLink = new ElementLinkImpl<T>(this.getElementClass());
        scene.linkElement(this.element, this.elementLink);
        return this.elementLink;
    }

    protected abstract Class<T> getElementClass();
}

