/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class VinesOnTrunkGenFeature
extends GenFeature {
    protected final BooleanProperty[] sideVineStates = new BooleanProperty[]{null, null, VineBlock.f_57834_, VineBlock.f_57836_, VineBlock.f_57837_, VineBlock.f_57835_};
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Float> PLACE_FRUIT_CHANCE = ConfigurationProperty.floatProperty((String)"place_fruit_chance");

    public VinesOnTrunkGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, PLACE_CHANCE, MAX_HEIGHT, PLACE_FRUIT_CHANCE});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)new GenFeatureConfiguration((GenFeature)this).with(BLOCK, (Object)Blocks.f_50191_)).with(PLACE_CHANCE, (Object)Float.valueOf(0.8f))).with(MAX_HEIGHT, (Object)10)).with(PLACE_FRUIT_CHANCE, (Object)Float.valueOf(0.1f));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        boolean placed = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!(context.random().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue())) continue;
            BlockPos offset = context.pos().m_121955_(dir.m_122436_());
            this.placeVines(configuration, context.level(), offset, dir);
            placed = true;
        }
        return placed;
    }

    private void placeVines(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos pos, Direction direction) {
        BlockState state = ((Block)configuration.get(BLOCK)).m_49966_();
        if (state.m_61138_((Property)LadderBlock.f_54337_)) {
            state = (BlockState)((Block)configuration.get(BLOCK)).m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)direction);
        } else if (state.m_61138_((Property)VineBlock.f_57834_)) {
            state = (BlockState)((Block)configuration.get(BLOCK)).m_49966_().m_61124_((Property)this.sideVineStates[direction.m_122424_().ordinal()], (Comparable)Boolean.valueOf(true));
        }
        RandomSource rand = world.m_213780_();
        for (int i = 0; i < (Integer)configuration.get(MAX_HEIGHT); ++i) {
            BlockPos current = pos.m_6630_(i);
            if (state.m_61138_((Property)VineBlock.f_57833_) && (VineBlock.m_57853_((BlockGetter)world, (BlockPos)current.m_7494_(), (Direction)Direction.UP) || TreeHelper.isBranch((BlockState)world.m_8055_(current.m_7494_())))) {
                state = (BlockState)state.m_61124_((Property)VineBlock.f_57833_, (Comparable)Boolean.valueOf(true));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61406_) && rand.m_188501_() < ((Float)configuration.get(PLACE_FRUIT_CHANCE)).floatValue()) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(1 + rand.m_188503_(2)));
            }
            if (!world.m_8055_(current).m_247087_() || !TreeHelper.isBranch((BlockState)world.m_8055_(current.m_121955_(direction.m_122424_().m_122436_())))) continue;
            world.m_7731_(current, state, 0);
        }
    }
}

