/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.world;

import com.aetherteam.aether.data.resources.AetherFeatureStates;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import maxhyper.dtaether.DynamicTreesAether;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DynamicCrystalIslandFeature
extends Feature<NoneFeatureConfiguration> {
    protected static final String DEEP_AETHER = "deep_aether";
    protected static BlockState goldenGrassState;

    public DynamicCrystalIslandFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        LevelContext levelContext = LevelContext.create((LevelAccessor)context.m_159774_());
        ChunkPos chunkPos = context.m_159774_().m_46865_(context.m_159777_()).m_7697_();
        AtomicReference<Double> closestRingDistance = new AtomicReference<Double>(1024.0);
        AtomicReference<BlockPos> closestRing = new AtomicReference<BlockPos>(context.m_159777_());
        DynamicTreeFeature.DISC_PROVIDER.getPoissonDiscs(levelContext, chunkPos).forEach(disc -> {
            BlockPos ringPos = new BlockPos(disc.x, context.m_159777_().m_123342_(), disc.z);
            double dist = context.m_159777_().m_123331_((Vec3i)ringPos);
            if (dist < (Double)closestRingDistance.get()) {
                closestRingDistance.set(dist);
                closestRing.set(ringPos);
            }
        });
        BlockPos newOrigin = closestRing.get();
        Species crystalSpecies = (Species)Species.REGISTRY.get(DynamicTreesAether.location("crystal"));
        BlockState grassState = this.getGrassState((LevelAccessor)context.m_159774_(), newOrigin);
        this.m_5974_((LevelWriter)context.m_159774_(), newOrigin, grassState);
        if (crystalSpecies.isValid() && crystalSpecies.generate(new GenerationContext(levelContext, crystalSpecies, newOrigin, newOrigin.m_122032_(), context.m_159774_().m_204166_(newOrigin), Direction.Plane.HORIZONTAL.m_235690_(context.m_225041_()), 8, SafeChunkBounds.ANY_WG))) {
            int i = 0;
            while (i < 3) {
                BlockState state = i == 0 ? grassState : AetherFeatureStates.HOLYSTONE;
                if (i != 0) {
                    this.m_5974_((LevelWriter)context.m_159774_(), newOrigin.m_6625_(i), state);
                }
                int finalI = i++;
                Arrays.stream(Direction.values()).toList().subList(2, 6).forEach(direction -> {
                    this.m_5974_((LevelWriter)context.m_159774_(), newOrigin.m_121945_(direction).m_6625_(finalI), state);
                    if (finalI != 2) {
                        this.m_5974_((LevelWriter)context.m_159774_(), newOrigin.m_5484_(direction, 2).m_6625_(finalI), state);
                        this.m_5974_((LevelWriter)context.m_159774_(), newOrigin.m_121945_(direction).m_121945_(direction.m_122427_()).m_6625_(finalI), state);
                    }
                });
            }
            return true;
        }
        return false;
    }

    protected BlockState getGrassState(LevelAccessor level, BlockPos pos) {
        BlockState grassState = AetherFeatureStates.AETHER_GRASS_BLOCK;
        List<ResourceLocation> biomes = Arrays.stream(new ResourceLocation[]{new ResourceLocation(DEEP_AETHER, "golden_heights"), new ResourceLocation(DEEP_AETHER, "golden_grove")}).toList();
        if (ModList.get().isLoaded(DEEP_AETHER) && biomes.stream().anyMatch(rl -> level.m_204166_(pos).m_203373_(rl))) {
            Block grassBlock;
            if (goldenGrassState == null && (grassBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(DEEP_AETHER, "golden_heights_grass_block"))) != null && grassBlock != Blocks.f_50016_) {
                goldenGrassState = grassBlock.m_49966_();
            }
            grassState = goldenGrassState;
        }
        return grassState;
    }
}

