/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonElement;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.model.ModelInstance;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionModelProvider
implements DataProvider {
    private final Map<ResourceLocation, ModelInstance<?>> models = new HashMap();
    private final String modName;
    private final PackOutput output;
    private final ExistingFileHelper existingFileHelper;

    public FusionModelProvider(String modid, PackOutput output, ExistingFileHelper existingFileHelper) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.output = output;
        this.existingFileHelper = existingFileHelper;
    }

    @Deprecated
    public FusionModelProvider(String modid, PackOutput output) {
        this(modid, output, null);
    }

    public final CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.generate();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        Path output = this.output.m_245114_();
        for (Map.Entry<ResourceLocation, ModelInstance<?>> entry : this.models.entrySet()) {
            ResourceLocation location = entry.getKey();
            ModelInstance<?> model = entry.getValue();
            String extension = location.m_135815_().lastIndexOf(".") > location.m_135815_().lastIndexOf("/") ? "" : ".json";
            Path path = Path.of("assets", location.m_135827_(), "models", location.m_135815_() + extension);
            tasks.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)FusionModelTypeRegistry.serializeModelData(model), (Path)output.resolve(path)));
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    protected abstract void generate();

    public final void addModel(ResourceLocation location, ModelInstance<?> model) {
        ModelInstance<?> previousValue = this.models.put(location, model);
        if (previousValue != null) {
            throw new RuntimeException("Duplicate model for '" + location + "'!");
        }
        if (this.existingFileHelper != null) {
            this.existingFileHelper.trackGenerated(location, PackType.CLIENT_RESOURCES, ".json", "models");
        }
    }

    public String m_6055_() {
        return "Fusion Model Provider: " + this.modName;
    }
}

