/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight;

import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.zjjohn121110.aethersdelight.CommonSetup;
import net.zjjohn121110.aethersdelight.Config;
import net.zjjohn121110.aethersdelight.block.AethersDelightBlocks;
import net.zjjohn121110.aethersdelight.block.entity.AethersDelightBlockEntity;
import net.zjjohn121110.aethersdelight.item.AethersDelightItems;
import net.zjjohn121110.aethersdelight.loot.AethersDelightLootModifier;
import org.slf4j.Logger;

@Mod(value="aethersdelight")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AethersDelight {
    public static final String MOD_ID = "aethersdelight";
    private static final Logger LOGGER = LogUtils.getLogger();

    public AethersDelight() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(CommonSetup::init);
        AethersDelightItems.register(modEventBus);
        AethersDelightBlocks.register(modEventBus);
        AethersDelightBlockEntity.BLOCK_ENTITY_TYPES.register(modEventBus);
        AethersDelightBlockEntity.TILES.register(modEventBus);
        AethersDelightLootModifier.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    @SubscribeEvent
    public static void addPacks(AddPackFindersEvent event) {
        Pack pack;
        Path resourcPath;
        if (ModList.get().isLoaded("ancient_aether") && event.getPackType() == PackType.SERVER_DATA && event.getPackType() == PackType.SERVER_DATA) {
            resourcPath = ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"packs/compat/ancient_aether_compat"});
            pack = Pack.m_245429_((String)"builtin/compat/ancient_aether_compat", (Component)Component.m_237115_((String)"pack.aethersdelight.ancient_aether_compat.title"), (boolean)true, path -> new PathPackResources(path, resourcPath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (ModList.get().isLoaded("aether_redux") && event.getPackType() == PackType.SERVER_DATA && event.getPackType() == PackType.SERVER_DATA) {
            resourcPath = ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"packs/compat/aether_redux_compat"});
            pack = Pack.m_245429_((String)"builtin/compat/aether_redux_compat", (Component)Component.m_237115_((String)"pack.aethersdelight.aether_redux_compat.title"), (boolean)true, path -> new PathPackResources(path, resourcPath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="aethersdelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

