/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.datagen;

import java.util.function.Function;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.zjjohn121110.aethersdelight.block.AethersDelightBlocks;
import net.zjjohn121110.aethersdelight.block.custom.GingerCropBlock;
import net.zjjohn121110.aethersdelight.block.custom.LeekCropBlock;
import net.zjjohn121110.aethersdelight.block.custom.ParsnipCropBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "aethersdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(AethersDelightBlocks.ARKENIUM_BLOCK);
        this.blockWithItem(AethersDelightBlocks.RAW_ARKENIUM_BLOCK);
        this.blockWithItem(AethersDelightBlocks.ARKENIUM_ORE);
        this.makeGingerCrop((CropBlock)AethersDelightBlocks.GINGER_CROP.get(), "ginger_stage", "ginger_stage");
        this.makeParsnipCrop((CropBlock)AethersDelightBlocks.PARSNIP_CROP.get(), "parsnip_stage", "parsnip_stage");
        this.makeLeekCrop((CropBlock)AethersDelightBlocks.LEEK_CROP.get(), "leek_stage", "leek_stage");
        this.simpleBlockWithItem((Block)AethersDelightBlocks.WILD_GINGER.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)AethersDelightBlocks.WILD_GINGER.get()).m_135815_(), this.blockTexture((Block)AethersDelightBlocks.WILD_GINGER.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)AethersDelightBlocks.WILD_PARSNIP.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)AethersDelightBlocks.WILD_PARSNIP.get()).m_135815_(), this.blockTexture((Block)AethersDelightBlocks.WILD_PARSNIP.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)AethersDelightBlocks.WILD_LEEK.get(), (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture((Block)AethersDelightBlocks.WILD_LEEK.get()).m_135815_(), this.blockTexture((Block)AethersDelightBlocks.WILD_LEEK.get()))).renderType("cutout"));
    }

    public void makeGingerCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.gingerStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] gingerStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + state.m_61143_((Property)((GingerCropBlock)block).m_7959_()), new ResourceLocation("aethersdelight", "block/" + textureName + state.m_61143_((Property)((GingerCropBlock)block).m_7959_())))).renderType("cutout"))};
        return models;
    }

    public void makeParsnipCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.parsnipStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] parsnipStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + state.m_61143_((Property)((ParsnipCropBlock)block).m_7959_()), new ResourceLocation("aethersdelight", "block/" + textureName + state.m_61143_((Property)((ParsnipCropBlock)block).m_7959_())))).renderType("cutout"))};
        return models;
    }

    public void makeLeekCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.leekStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] leekStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + state.m_61143_((Property)((LeekCropBlock)block).m_7959_()), new ResourceLocation("aethersdelight", "block/" + textureName + state.m_61143_((Property)((LeekCropBlock)block).m_7959_())))).renderType("cutout"))};
        return models;
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }
}

