/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.datagen;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.zjjohn121110.aethersdelight.block.AethersDelightBlocks;
import net.zjjohn121110.aethersdelight.item.AethersDelightItems;
import vectorwing.farmersdelight.data.ItemModels;

public class ModItemModelProvider
extends ItemModelProvider {
    public static final ResourceLocation MUG = new ResourceLocation("aethersdelight", "item/mug");
    Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "aethersdelight".equals(ForgeRegistries.ITEMS.getKey(i).m_135827_())).collect(Collectors.toSet());

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "aethersdelight", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(AethersDelightItems.RAW_ARKENIUM);
        this.simpleItem(AethersDelightItems.ARKENIUM_INGOT);
        this.simpleItem(AethersDelightItems.ARKENIUM_NUGGET);
        this.simpleItem(AethersDelightItems.GINGER);
        this.simpleItem(AethersDelightItems.GINGER_SPICE);
        this.simpleItem(AethersDelightItems.GINGERBREAD_DOUGH);
        this.simpleItem(AethersDelightItems.GINGERBREAD);
        this.simpleItem(AethersDelightItems.GINGERBREAD_MOA);
        this.simpleItem(AethersDelightItems.GINGERBREAD_STAR);
        this.simpleItem(AethersDelightItems.GINGERBREAD_MAN_BASE);
        this.simpleItem(AethersDelightItems.GINGERBREAD_MOA_BASE);
        this.simpleItem(AethersDelightItems.GINGERBREAD_STAR_BASE);
        this.simpleItem(AethersDelightItems.PEPPERMINT_LEAF);
        this.simpleItem(AethersDelightItems.PEPPERMINT_EXTRACT);
        this.simpleItem(AethersDelightItems.PARSNIP);
        this.simpleItem(AethersDelightItems.COOKED_PARSNIP);
        this.simpleItem(AethersDelightItems.LEEK);
        this.simpleItem(AethersDelightItems.BLUE_BERRY_JAM);
        this.simpleItem(AethersDelightItems.ENCHANTED_BERRY_JAM);
        this.simpleItem(AethersDelightItems.BLUE_BERRY_MUFFIN);
        this.simpleItem(AethersDelightItems.ENCHANTED_BERRY_MUFFIN);
        this.simpleItem(AethersDelightItems.FRIED_MOA_EGG);
        this.simpleItem(AethersDelightItems.RAW_MOA);
        this.simpleItem(AethersDelightItems.COOKED_MOA);
        this.simpleItem(AethersDelightItems.RAW_MOA_CUTS);
        this.simpleItem(AethersDelightItems.COOKED_MOA_CUTS);
        this.simpleItem(AethersDelightItems.WING);
        this.simpleItem(AethersDelightItems.COOKED_WING);
        this.simpleItem(AethersDelightItems.WHITE_APPLE_PIE);
        this.simpleItem(AethersDelightItems.WHITE_APPLE_PIE_SLICE);
        this.simpleItem(AethersDelightItems.SWET_SOUP);
        this.simpleItem(AethersDelightItems.GINGER_SOUP);
        this.simpleItem(AethersDelightItems.MOA_STEW);
        this.simpleItem(AethersDelightItems.FLYING_BEEF_STEW);
        this.simpleItem(AethersDelightItems.PARSNIP_PASTA);
        this.simpleItem(AethersDelightItems.MOA_EGG_OMELETTE);
        this.simpleItem(AethersDelightItems.PEPPERMINT_CANDY_DOUGH);
        this.simpleItem(AethersDelightItems.PEPPERMINT_CANDY);
        this.simpleItem(AethersDelightItems.CANDIED_WHITE_APPLE);
        this.simpleItem(AethersDelightItems.COOKIE_CUTTER_MAN);
        this.simpleItem(AethersDelightItems.COOKIE_CUTTER_MOA);
        this.simpleItem(AethersDelightItems.COOKIE_CUTTER_STAR);
        this.handheldItem(AethersDelightItems.HOLYSTONE_KNIFE);
        this.handheldItem(AethersDelightItems.ZANITE_KNIFE);
        this.handheldItem(AethersDelightItems.GRAVITITE_KNIFE);
        this.handheldItem(AethersDelightItems.ARKENIUM_KNIFE);
        this.simpleItemBlockTexture(AethersDelightBlocks.WILD_GINGER);
        this.simpleItemBlockTexture(AethersDelightBlocks.WILD_PARSNIP);
        this.simpleItemBlockTexture(AethersDelightBlocks.WILD_LEEK);
        this.simpleItem(AethersDelightItems.AECHOR_ICE_CREAM_BUCKET_BLOCK);
        this.simpleItem(AethersDelightItems.AECHOR_ICE_CREAM);
        this.simpleItem(AethersDelightItems.AECHOR_ICE_CREAM_BASE);
        this.simpleItem(AethersDelightItems.ROAST_MOA_BLOCK);
        this.simpleItem(AethersDelightItems.ROAST_MOA);
        HashSet mugItems = Sets.newHashSet((Object[])new Item[]{(Item)AethersDelightItems.GINGER_ALE.get(), (Item)AethersDelightItems.PEPPERMINT_TEA.get()});
        ItemModels.takeAll(this.items, (Object[])mugItems.toArray(new Item[0])).forEach(item -> this.itemMugModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("aethersdelight", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("aethersdelight", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleItemBlockTexture(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("aethersdelight", "block/" + item.getId().m_135815_()));
    }

    public void itemMugModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), MUG)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    public ResourceLocation resourceItem(String path) {
        return new ResourceLocation("aethersdelight", "item/" + path);
    }
}

