/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics;

import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.CreateBuildInfo;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.providers.ProviderType;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ithundxr.createnumismatics.ModSetup;
import dev.ithundxr.createnumismatics.ModSetupLate;
import dev.ithundxr.createnumismatics.base.data.NumismaticsTagGen;
import dev.ithundxr.createnumismatics.base.data.lang.NumismaticsLangGen;
import dev.ithundxr.createnumismatics.base.data.recipe.NumismaticsSequencedAssemblyRecipeGen;
import dev.ithundxr.createnumismatics.base.data.recipe.NumismaticsStandardRecipeGen;
import dev.ithundxr.createnumismatics.content.backend.GlobalBankManager;
import dev.ithundxr.createnumismatics.forge.NumismaticsImpl;
import dev.ithundxr.createnumismatics.multiloader.Loader;
import dev.ithundxr.createnumismatics.registry.NumismaticsAdvancements;
import dev.ithundxr.createnumismatics.registry.NumismaticsCommands;
import dev.ithundxr.createnumismatics.registry.NumismaticsCreativeModeTabs;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.function.BiConsumer;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Numismatics {
    public static final String MOD_ID = "numismatics";
    public static final String NAME = "Create: Numismatics";
    public static final String VERSION = Numismatics.findVersion();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Numismatics");
    public static final GlobalBankManager BANK = new GlobalBankManager();
    private static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"numismatics");

    public static void init() {
        LOGGER.info("{} {} initializing! Create version: {} on platform: {}", new Object[]{NAME, VERSION, CreateBuildInfo.VERSION, Loader.getCurrent()});
        ModSetup.register();
        Numismatics.finalizeRegistrate();
        Numismatics.registerCommands(NumismaticsCommands::register);
        NumismaticsPackets.PACKETS.registerC2SListener();
        if (Utils.isDevEnv() && Loader.FABRIC.isCurrent()) {
            SharedConstants.f_136183_ = false;
        }
    }

    public static void postRegistrationInit() {
        ModSetupLate.registerPostRegistration();
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String findVersion() {
        return NumismaticsImpl.findVersion();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void finalizeRegistrate() {
        NumismaticsImpl.finalizeRegistrate();
    }

    public static void gatherData(DataGenerator.PackGenerator gen) {
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, NumismaticsTagGen::generateBlockTags);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, NumismaticsTagGen::generateItemTags);
        REGISTRATE.addDataGenerator(ProviderType.LANG, NumismaticsLangGen::generate);
        gen.m_253108_(NumismaticsSequencedAssemblyRecipeGen::new);
        gen.m_253108_(NumismaticsStandardRecipeGen::new);
        gen.m_253108_(NumismaticsAdvancements::new);
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void crashDev(String message) {
        if (Utils.isDevEnv()) {
            throw new RuntimeException(message);
        }
        LOGGER.error(message);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerCommands(BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean> consumer) {
        NumismaticsImpl.registerCommands(consumer);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        NumismaticsCreativeModeTabs.Tabs.MAIN.use();
    }
}

