/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.SlotInputMergingCoinBag;
import dev.ithundxr.createnumismatics.content.coins.SlotOutputMergingCoinBag;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BankMenu
extends MenuBase<BankAccount> {
    public static final int COIN_SLOTS;
    public static final int COIN_INPUT_SLOT_INDEX;
    public static final int CARD_SLOT_INDEX;
    public static final int PLAYER_INV_START_INDEX;
    public static final int PLAYER_HOTBAR_END_INDEX;
    public static final int PLAYER_INV_END_INDEX;
    protected ContainerData dataAccess;
    private CardSwitchContainer cardSwitchContainer;

    public BankMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public BankMenu(MenuType<?> type, int id, Inventory inv, BankAccount contentHolder, ContainerData dataAccess) {
        super(type, id, inv, (Object)contentHolder);
        this.dataAccess = dataAccess;
        this.m_38884_(dataAccess);
    }

    protected BankAccount createOnClient(FriendlyByteBuf extraData) {
        BankAccount account = BankAccount.clientSide(extraData);
        this.dataAccess = account.dataAccess;
        this.m_38884_(this.dataAccess);
        return account;
    }

    protected void initAndReadInventory(BankAccount contentHolder) {
    }

    protected void addSlots() {
        if (this.cardSwitchContainer == null) {
            this.cardSwitchContainer = new CardSwitchContainer(arg_0 -> ((BankMenu)this).m_6199_(arg_0), this::switchTo);
        }
        int x = 13;
        int y = 71;
        for (Coin coin : Coin.values()) {
            this.m_38897_(new SlotOutputMergingCoinBag(((BankAccount)this.contentHolder).linkedCoinBag, coin, x, y));
            x += 18;
        }
        this.m_38897_(new SlotInputMergingCoinBag(((BankAccount)this.contentHolder).linkedCoinBag, null, 159, y));
        this.m_38897_(new CardSlot.BoundCardSlot(this.cardSwitchContainer, 0, 8, 109));
        this.addPlayerSlots(40, 152);
    }

    private boolean switchTo(UUID otherAccount) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BankAccount account = Numismatics.BANK.getAccount(otherAccount);
            if (account != null) {
                if (account.isAuthorized((Player)serverPlayer)) {
                    Utils.openScreen(serverPlayer, account, account::sendToMenu);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void saveData(BankAccount contentHolder) {
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (playerIn instanceof ServerPlayer) {
            this.m_150411_(this.player, this.cardSwitchContainer);
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot clickedSlot = (Slot)this.f_38839_.get(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotStack = CoinItem.clearDisplayedCount(clickedSlot.m_7993_());
        ItemStack returnStack = slotStack.m_41777_();
        if (index <= CARD_SLOT_INDEX) {
            int count = slotStack.m_41613_();
            if (!this.m_38903_(slotStack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
            returnStack = ItemStack.f_41583_;
            clickedSlot.m_6201_(count);
        } else {
            if (slotStack.m_41720_() instanceof CoinItem && !this.m_38903_(slotStack, COIN_INPUT_SLOT_INDEX, COIN_INPUT_SLOT_INDEX + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(slotStack) && !this.m_38903_(slotStack, CARD_SLOT_INDEX, CARD_SLOT_INDEX + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= PLAYER_INV_START_INDEX && index < PLAYER_HOTBAR_END_INDEX && !this.m_38903_(slotStack, PLAYER_HOTBAR_END_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= PLAYER_HOTBAR_END_INDEX && index < PLAYER_INV_END_INDEX && !this.m_38903_(slotStack, PLAYER_INV_START_INDEX, PLAYER_HOTBAR_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (slotStack.m_41619_()) {
            clickedSlot.m_5852_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        return returnStack;
    }

    static {
        COIN_INPUT_SLOT_INDEX = COIN_SLOTS = Coin.values().length;
        CARD_SLOT_INDEX = COIN_INPUT_SLOT_INDEX + 1;
        PLAYER_INV_START_INDEX = CARD_SLOT_INDEX + 1;
        PLAYER_HOTBAR_END_INDEX = PLAYER_INV_START_INDEX + 9;
        PLAYER_INV_END_INDEX = PLAYER_INV_START_INDEX + 36;
    }

    private class CardSwitchContainer
    implements Container {
        private final Consumer<CardSwitchContainer> slotsChangedCallback;
        private final Function<UUID, Boolean> uuidChangedCallback;
        @NotNull
        protected final List<ItemStack> stacks = new ArrayList<ItemStack>();

        public CardSwitchContainer(Consumer<CardSwitchContainer> slotsChangedCallback, Function<UUID, Boolean> uuidChangedCallback) {
            this.slotsChangedCallback = slotsChangedCallback;
            this.uuidChangedCallback = uuidChangedCallback;
            this.stacks.add(ItemStack.f_41583_);
        }

        public int m_6643_() {
            return 1;
        }

        protected ItemStack getStack() {
            return this.stacks.get(0);
        }

        public boolean m_7983_() {
            return this.getStack().m_41619_();
        }

        @NotNull
        public ItemStack m_8020_(int slot) {
            return this.getStack();
        }

        @NotNull
        public ItemStack m_7407_(int slot, int amount) {
            ItemStack stack = ContainerHelper.m_18969_(this.stacks, (int)0, (int)amount);
            if (!stack.m_41619_()) {
                this.slotsChangedCallback.accept(this);
            }
            return stack;
        }

        @NotNull
        public ItemStack m_8016_(int slot) {
            return ContainerHelper.m_18966_(this.stacks, (int)0);
        }

        public void m_6836_(int slot, @NotNull ItemStack stack) {
            this.stacks.set(0, stack);
            if (CardItem.isBound(stack) && NumismaticsTags.AllItemTags.CARDS.matches(stack) && !this.uuidChangedCallback.apply(CardItem.get(stack)).booleanValue()) {
                this.stacks.set(0, CardItem.clear(stack));
                BankMenu.this.m_150411_(BankMenu.this.player, this);
            }
            this.slotsChangedCallback.accept(this);
        }

        public void m_6596_() {
        }

        public boolean m_6542_(@NotNull Player player) {
            return true;
        }

        public void m_6211_() {
            this.stacks.set(0, ItemStack.f_41583_);
        }
    }
}

