/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.phantomwing.rusticdelight.Configuration;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SquidsDropCalamariModifier
extends LootModifier {
    public static final Supplier<Codec<SquidsDropCalamariModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SquidsDropCalamariModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.INT.fieldOf("minAmount").forGetter(m -> m.minAmount)).and((App)Codec.INT.fieldOf("maxAmount").forGetter(m -> m.maxAmount)).apply((Applicative)inst, SquidsDropCalamariModifier::new)));
    private final Item item;
    private final int minAmount;
    private final int maxAmount;

    public SquidsDropCalamariModifier(LootItemCondition[] conditionsIn, Item item, int minAmount, int maxAmount) {
        super(conditionsIn);
        this.item = item;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)Configuration.SQUIDS_DROP_CALAMARI.get()).booleanValue()) {
            return generatedLoot;
        }
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

