/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.world.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.phantomwing.rusticdelight.Configuration;
import com.phantomwing.rusticdelight.world.ModPlacementModifiers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.jetbrains.annotations.NotNull;

public class ConfigurableRarityFilter
extends PlacementFilter {
    public static final MapCodec<ConfigurableRarityFilter> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ExtraCodecs.f_263723_.fieldOf("option").forGetter(instance -> instance.chance)).apply((Applicative)builder, ConfigurableRarityFilter::new));
    private final String chance;

    private ConfigurableRarityFilter(String chance) {
        this.chance = chance;
    }

    public static ConfigurableRarityFilter withConfigurableChance(String chance) {
        return new ConfigurableRarityFilter(chance);
    }

    protected boolean m_213917_(@NotNull PlacementContext context, RandomSource random, @NotNull BlockPos pos) {
        int configuredValue = Configuration.getIntConfigurationValue(this.chance);
        if (configuredValue <= 0) {
            return false;
        }
        return random.m_188501_() < 1.0f / (float)configuredValue;
    }

    @NotNull
    public PlacementModifierType<?> m_183327_() {
        return ModPlacementModifiers.CONFIGURABLE_RARITY_FILTER.get();
    }
}

