/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat;

import com.hlysine.create_connected.compat.CopycatsManager;
import com.hlysine.create_connected.compat.Mods;
import com.hlysine.create_connected.config.CCConfigs;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MigratingCopycatBlock
extends CopycatBlock {
    public MigratingCopycatBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        BlockState state = super.m_5573_(pContext);
        assert (state != null);
        return MigratingCopycatBlock.migrate(state);
    }

    public boolean generateAdditionalStates() {
        return false;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        return MigratingCopycatBlock.migrateOnUpdate(pLevel.m_5776_(), super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos));
    }

    protected static BlockState migrateOnUpdate(boolean isClient, BlockState state) {
        if (!isClient && ((Boolean)CCConfigs.common().migrateCopycatsOnBlockUpdate.get()).booleanValue()) {
            return MigratingCopycatBlock.migrate(state);
        }
        return state;
    }

    protected static BlockState migrate(BlockState state) {
        return Mods.COPYCATS.runIfInstalled(() -> () -> CopycatsManager.convertIfEnabled(state)).orElse(state);
    }

    protected boolean isSelfState(BlockState state) {
        if (state.m_60713_((Block)this)) {
            return true;
        }
        return Mods.COPYCATS.runIfInstalled(() -> () -> state.m_60713_(CopycatsManager.convertIfEnabled((Block)this))).orElse(false);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (Mods.COPYCATS.runIfInstalled(() -> () -> {
            Block oldBlock = CopycatsManager.convertIfEnabled(pState.m_60734_());
            Block newBlock = CopycatsManager.convertIfEnabled(pNewState.m_60734_());
            return oldBlock.equals(newBlock);
        }).orElse(false).booleanValue()) {
            return;
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState pState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder pParams) {
        List drops = super.m_49635_(pState, pParams);
        return Mods.COPYCATS.runIfInstalled(() -> () -> {
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack drop = (ItemStack)drops.get(i);
                Item converted = CopycatsManager.convert(drop.m_41720_());
                if (converted.equals(drop.m_41720_())) continue;
                drops.set(i, new ItemStack((ItemLike)converted, drop.m_41613_()));
            }
            return drops;
        }).orElse(drops);
    }
}

